/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.sponge7;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import minimotd.net.kyori.adventure.platform.spongeapi.SpongeAudiences;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.network.status.Favicon;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.channel.MessageReceiver;
import xyz.jpenilla.minimotd.common.CommandHandler;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.MiniMOTDPlatform;
import xyz.jpenilla.minimotd.common.util.UpdateChecker;
import xyz.jpenilla.minimotd.sponge7.ClientPingServerEventListener;

@Plugin(id="minimotd-sponge7")
public final class MiniMOTDPlugin
implements MiniMOTDPlatform<Favicon> {
    private final Logger logger;
    private final Path dataDirectory;
    private final MiniMOTD<Favicon> miniMOTD;
    private final SpongeAudiences audiences;
    private final Game game;
    private final Injector injector;

    @Inject
    public MiniMOTDPlugin(@NonNull Logger logger, @ConfigDir(sharedRoot=false) @NonNull Path dataDirectory, @NonNull SpongeAudiences audiences,  @NonNull Metrics.Factory metricsFactory, @NonNull Injector injector, @NonNull Game game) {
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.audiences = audiences;
        this.game = game;
        this.miniMOTD = new MiniMOTD<Favicon>(this);
        this.injector = injector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<MiniMOTD<Favicon>>(){}).toInstance((Object)MiniMOTDPlugin.this.miniMOTD);
            }
        }});
        metricsFactory.make(10768);
    }

    @Listener
    public void gameStarted(@NonNull GameStartedServerEvent event) {
        Sponge.getEventManager().registerListener((Object)this, ClientPingServerEvent.class, (EventListener)this.injector.getInstance(ClientPingServerEventListener.class));
        this.registerCommands();
        if (this.miniMOTD.configManager().pluginSettings().updateChecker()) {
            Task.builder().async().execute(() -> new UpdateChecker().checkVersion().forEach(arg_0 -> ((Logger)this.logger).info(arg_0))).submit((Object)this);
        }
    }

    @Listener
    public void reloaded(@NonNull GameReloadEvent event) {
        try {
            this.miniMOTD.reload();
        }
        catch (Exception ex) {
            this.miniMOTD.logger().warn("Failed to reload MiniMOTD.", (Throwable)ex);
        }
    }

    private void registerCommands() {
        CommandHandler handler = new CommandHandler(this.miniMOTD);
        final class WrappingExecutor
        implements CommandExecutor {
            private final CommandHandler.Executor handler;

            WrappingExecutor(CommandHandler.Executor handler) {
                this.handler = handler;
            }

            public @NonNull CommandResult execute(@NonNull CommandSource src, @NonNull CommandContext args) {
                this.handler.execute(MiniMOTDPlugin.this.audiences.receiver((MessageReceiver)src));
                return CommandResult.success();
            }
        }
        CommandSpec help = CommandSpec.builder().executor((CommandExecutor)new WrappingExecutor(handler::help)).build();
        CommandSpec about = CommandSpec.builder().executor((CommandExecutor)new WrappingExecutor(handler::about)).build();
        CommandSpec reload = CommandSpec.builder().executor((CommandExecutor)new WrappingExecutor(handler::reload)).build();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().permission("minimotd.admin").child((CommandCallable)help, new String[]{"help"}).child((CommandCallable)about, new String[]{"about"}).child((CommandCallable)reload, new String[]{"reload"}).build(), new String[]{"minimotd"});
    }

    @Override
    public @NonNull Path dataDirectory() {
        return this.dataDirectory;
    }

    @Override
    public @NonNull Logger logger() {
        return this.logger;
    }

    @Override
    public @NonNull Favicon loadIcon(@NonNull BufferedImage image) throws IOException {
        return this.game.getRegistry().loadFavicon(image);
    }
}

