/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.common.config;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import minimotd.org.spongepowered.configurate.CommentedConfigurationNode;
import minimotd.org.spongepowered.configurate.ConfigurateException;
import minimotd.org.spongepowered.configurate.ConfigurationOptions;
import minimotd.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import minimotd.org.spongepowered.configurate.objectmapping.ObjectMapper;
import minimotd.org.spongepowered.configurate.serialize.SerializationException;
import minimotd.org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.jspecify.annotations.NullMarked;
import xyz.jpenilla.minimotd.common.config.PlayerCountModifier;
import xyz.jpenilla.minimotd.common.config.PostProcessor;

@NullMarked
public final class ConfigLoader<C> {
    private static final TypeSerializerCollection SERIALIZERS = TypeSerializerCollection.builder().register(PlayerCountModifier.serializer()).build();
    private final HoconConfigurationLoader loader;
    private final ObjectMapper<C> mapper;
    private final List<Consumer<C>> postProcess;

    public ConfigLoader(Class<C> configClass, Path configPath, UnaryOperator<ConfigurationOptions> optionsModifier) {
        this.postProcess = this.findPostProcessors(configClass);
        this.loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(configPath)).defaultOptions(options -> ((ConfigurationOptions)optionsModifier.apply((ConfigurationOptions)options)).serializers(builder -> builder.registerAll(SERIALIZERS)))).build();
        try {
            this.mapper = ObjectMapper.factory().get(configClass);
        }
        catch (SerializationException ex) {
            throw new IllegalStateException("Failed to initialize an object mapper for type: " + configClass.getSimpleName(), ex);
        }
    }

    private List<Consumer<C>> findPostProcessors(Class<C> configClass) {
        ArrayList<Consumer<C>> ret = new ArrayList<Consumer<C>>();
        for (Method method : configClass.getDeclaredMethods()) {
            if (method.getAnnotation(PostProcessor.class) == null) continue;
            ret.add(config -> {
                try {
                    method.setAccessible(true);
                    method.invoke(config, new Object[0]);
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException("Failed to invoke post processor method", ex);
                }
            });
        }
        return ret;
    }

    public ConfigLoader(Class<C> configClass, Path configPath) {
        this(configClass, configPath, options -> options);
    }

    public C load() throws ConfigurateException {
        CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.load();
        C config = this.mapper.load(node);
        for (Consumer<C> processor : this.postProcess) {
            processor.accept(config);
        }
        return config;
    }

    public void save(C config) throws ConfigurateException {
        CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.createNode();
        this.mapper.save(config, node);
        this.loader.save(node);
    }
}

