/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class Nag {
    private static final String EQUALS_LINE = "====================================================";
    private final List<String> lines = new ArrayList<String>();
    private boolean exception = false;
    private boolean error = false;

    public Nag lines(String ... lines) {
        this.lines.addAll(Arrays.asList(lines));
        return this;
    }

    public Nag line(String line) {
        this.lines.add(line);
        return this;
    }

    public Nag error(boolean withException) {
        this.error = true;
        this.exception = withException;
        return this;
    }

    protected abstract void logError(String var1, @Nullable Throwable var2);

    protected abstract void logWarn(String var1, @Nullable Throwable var2);

    public void logBanner() {
        ArrayList<String> toLog = new ArrayList<String>();
        toLog.add(EQUALS_LINE);
        toLog.addAll(this.lines);
        toLog.add(EQUALS_LINE);
        for (String line : toLog) {
            if (this.error) {
                this.logError(line, null);
                continue;
            }
            this.logWarn(line, null);
        }
        if (this.exception) {
            this.logError("Please see the above notice.", new RuntimeException("Please see the above notice."));
        }
    }

    public static final class JavaUtilLogging
    extends Nag {
        private final java.util.logging.Logger logger;

        public JavaUtilLogging(java.util.logging.Logger logger) {
            this.logger = logger;
        }

        @Override
        protected void logError(String message, @Nullable Throwable throwable) {
            if (throwable != null) {
                this.logger.log(Level.SEVERE, message, throwable);
            } else {
                this.logger.severe(message);
            }
        }

        @Override
        protected void logWarn(String message, @Nullable Throwable throwable) {
            if (throwable != null) {
                this.logger.log(Level.WARNING, message, throwable);
            } else {
                this.logger.warning(message);
            }
        }
    }

    public static final class Slf4J
    extends Nag {
        private final Logger logger;

        public Slf4J(Logger logger) {
            this.logger = logger;
        }

        @Override
        protected void logError(String message, @Nullable Throwable throwable) {
            if (throwable != null) {
                this.logger.error(message, throwable);
            } else {
                this.logger.error(message);
            }
        }

        @Override
        protected void logWarn(String message, @Nullable Throwable throwable) {
            if (throwable != null) {
                this.logger.warn(message, throwable);
            } else {
                this.logger.warn(message);
            }
        }
    }
}

