/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.sponge8;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import net.kyori.adventure.text.Component;
import org.jspecify.annotations.NonNull;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.network.status.Favicon;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.PingResponse;
import xyz.jpenilla.minimotd.common.config.MOTDConfig;
import xyz.jpenilla.minimotd.common.util.ComponentColorDownsampler;

final class ClientPingServerEventListener
implements EventListener<ClientPingServerEvent> {
    private static final Method GET_PROTOCOL;
    private final MiniMOTD<Favicon> miniMOTD;

    @Inject
    private ClientPingServerEventListener(@NonNull MiniMOTD<Favicon> miniMOTD) {
        this.miniMOTD = miniMOTD;
    }

    public void handle(@NonNull ClientPingServerEvent event) {
        ClientPingServerEvent.Response.Players players;
        ClientPingServerEvent.Response response = event.response();
        ClientPingServerEvent.Response.Players players0 = response.players().orElse(null);
        if (players0 != null) {
            players = players0;
        } else {
            response.setHidePlayers(false);
            players = response.players().orElse(null);
            if (players == null) {
                this.miniMOTD.logger().warn(String.format("Failed to handle ClientPingServerEvent: '%s', response.players() was null.", event));
                return;
            }
        }
        MOTDConfig config = this.miniMOTD.configManager().mainConfig();
        PingResponse<Favicon> mini = this.miniMOTD.createMOTD(config, players.online(), players.max());
        mini.playerCount().applyCount(arg_0 -> ((ClientPingServerEvent.Response.Players)players).setOnline(arg_0), arg_0 -> ((ClientPingServerEvent.Response.Players)players).setMax(arg_0));
        mini.motd(motd -> {
            if (this.legacy(event.client().version())) {
                response.setDescription(ComponentColorDownsampler.downsampler().downsample((Component)motd));
            } else {
                response.setDescription(motd);
            }
        });
        mini.icon(arg_0 -> ((ClientPingServerEvent.Response)response).setFavicon(arg_0));
        if (mini.disablePlayerListHover()) {
            players.profiles().clear();
        }
        if (mini.hidePlayerCount()) {
            response.setHidePlayers(true);
        }
    }

    private boolean legacy(@NonNull MinecraftVersion version) {
        try {
            return version.isLegacy() || (Integer)GET_PROTOCOL.invoke((Object)version, new Object[0]) < 735;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to get protocol version", e);
        }
    }

    static {
        try {
            Class<?> protocolMinecraftVersion = Class.forName("org.spongepowered.common.ProtocolMinecraftVersion");
            GET_PROTOCOL = protocolMinecraftVersion.getMethod("getProtocol", new Class[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

