/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.sponge8;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandExecutor;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.EventListenerRegistration;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.lifecycle.LoadedGameEvent;
import org.spongepowered.api.event.lifecycle.RefreshGameEvent;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.network.status.Favicon;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;
import org.spongepowered.plugin.metadata.PluginMetadata;
import xyz.jpenilla.minimotd.common.CommandHandler;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.MiniMOTDPlatform;
import xyz.jpenilla.minimotd.common.util.UpdateChecker;
import xyz.jpenilla.minimotd.sponge8.ClientPingServerEventListener;

@Plugin(value="minimotd-sponge8")
public final class MiniMOTDPlugin
implements MiniMOTDPlatform<Favicon> {
    private final Path dataDirectory;
    private final PluginMetadata pluginMetadata;
    private final Logger logger;
    private final PluginContainer pluginContainer;
    private final MiniMOTD<Favicon> miniMOTD;
    private final Injector injector;

    @Inject
    public MiniMOTDPlugin(@ConfigDir(sharedRoot=false) @NonNull Path dataDirectory, @NonNull PluginContainer pluginContainer, @NonNull Injector injector) {
        this.dataDirectory = dataDirectory;
        this.pluginContainer = pluginContainer;
        this.pluginMetadata = pluginContainer.metadata();
        this.logger = LoggerFactory.getLogger((String)this.pluginMetadata.id());
        this.miniMOTD = new MiniMOTD<Favicon>(this);
        this.injector = injector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<MiniMOTD<Favicon>>(){}).toInstance((Object)MiniMOTDPlugin.this.miniMOTD);
            }
        }});
        Sponge.eventManager().registerListener(EventListenerRegistration.builder(ClientPingServerEvent.class).plugin(pluginContainer).listener((EventListener)this.injector.getInstance(ClientPingServerEventListener.class)).order(Order.DEFAULT).build());
    }

    @Listener
    public void onGameLoaded(@NonNull LoadedGameEvent event) {
        if (this.miniMOTD.configManager().pluginSettings().updateChecker()) {
            Sponge.asyncScheduler().submit(Task.builder().plugin(this.pluginContainer).execute(() -> new UpdateChecker().checkVersion().forEach(arg_0 -> ((Logger)this.logger).info(arg_0))).build());
        }
    }

    @Listener
    public void registerCommands(@NonNull RegisterCommandEvent<// Could not load outer class - annotation placement on inner may be incorrect
    Command.Parameterized> event) {
        CommandHandler handler = new CommandHandler(this.miniMOTD);
        final class WrappingExecutor
        implements CommandExecutor {
            private final CommandHandler.Executor handler;

            WrappingExecutor(CommandHandler.Executor handler) {
                this.handler = handler;
            }

            public CommandResult execute(@NonNull CommandContext context) {
                this.handler.execute(context.cause().audience());
                return CommandResult.success();
            }
        }
        Command.Parameterized about = Command.builder().executor((CommandExecutor)new WrappingExecutor(handler::about)).build();
        Command.Parameterized help = Command.builder().executor((CommandExecutor)new WrappingExecutor(handler::help)).build();
        Command.Parameterized reload = Command.builder().executor((CommandExecutor)new WrappingExecutor(handler::reload)).build();
        event.register(this.pluginContainer, (Object)Command.builder().permission("minimotd.admin").addChild(about, new String[]{"about"}).addChild(help, new String[]{"help"}).addChild(reload, new String[]{"reload"}).build(), "minimotd", new String[0]);
    }

    @Listener
    public void onRefresh(@NonNull RefreshGameEvent event) {
        try {
            this.miniMOTD.reload();
        }
        catch (Exception ex) {
            this.miniMOTD.logger().warn("Failed to reload MiniMOTD.", (Throwable)ex);
        }
    }

    @Override
    public @NonNull Path dataDirectory() {
        return this.dataDirectory;
    }

    @Override
    public @NonNull Logger logger() {
        return this.logger;
    }

    @Override
    public @NonNull Favicon loadIcon(@NonNull BufferedImage image) throws Exception {
        return Favicon.load((BufferedImage)image);
    }
}

