/*
 * Decompiled with CFR 0.152.
 */
package rems.carpet.mixins.SignCommand;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1802;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import rems.carpet.REMSSettings;

@Mixin(value={class_2625.class})
public abstract class SignBlockEntityMixin {
    private static final Set<String> ALLOWED_COMMANDS = new HashSet<String>(Arrays.asList("say", "player", "tick"));

    @Shadow
    protected abstract class_2561[] method_33830(boolean var1);

    @Inject(method={"onActivate"}, at={@At(value="HEAD")}, cancellable=true)
    private void runCommandOnActivated(class_3222 player, CallbackInfoReturnable<Boolean> ci) {
        if (REMSSettings.SignCommand) {
            class_2561[] texts = this.method_33830(player.method_33793());
            String fullCommand = this.processSignText(texts);
            if (fullCommand.isEmpty() || !fullCommand.startsWith("/")) {
                return;
            }
            String actualCommand = fullCommand.substring(1);
            if (!this.isCommandAllowed(actualCommand)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u8be5\u6307\u4ee4\u672a\u88ab\u5141\u8bb8\u901a\u8fc7\u544a\u793a\u724c\u6267\u884c"), false);
                ci.setReturnValue((Object)true);
                return;
            }
            if (player.method_6047().method_31574(class_1802.field_8162) && !player.method_5715()) {
                ci.setReturnValue((Object)true);
                this.executeValidatedCommand(player, actualCommand);
            }
        }
    }

    private String processSignText(class_2561[] texts) {
        StringBuilder commandBuilder = new StringBuilder();
        for (int i = 0; i < texts.length; ++i) {
            String line = texts[i].getString().replaceAll("\u00a7.", "").replaceAll("[\\x00-\\x1F]", "").trim();
            if (line.isEmpty()) continue;
            if (line.endsWith("\\")) {
                commandBuilder.append(line, 0, line.length() - 1);
                continue;
            }
            commandBuilder.append(line);
            if (i == texts.length - 1) continue;
            commandBuilder.append(" ");
        }
        return commandBuilder.toString().replaceAll("\\s+", " ").trim();
    }

    private boolean isCommandAllowed(String rawCommand) {
        String[] parts = rawCommand.split(" ", 2);
        String baseCommand = parts[0].toLowerCase();
        int colonIndex = baseCommand.indexOf(58);
        if (colonIndex != -1) {
            baseCommand = baseCommand.substring(colonIndex + 1);
        }
        return ALLOWED_COMMANDS.contains(baseCommand);
    }

    private void executeValidatedCommand(class_3222 player, String command) {
        class_3218 world = player.method_14220();
        class_2168 commandSource = new class_2168(class_2165.field_17395, player.method_19538(), player.method_5802(), world, 0, player.method_5477().getString(), player.method_5476(), world.method_8503(), (class_1297)player);
        player.method_5682().execute(() -> {
            try {
                CommandDispatcher dispatcher = commandSource.method_9211().method_3734().method_9235();
                ParseResults results = dispatcher.parse(command, (Object)commandSource);
                if (results.getExceptions().isEmpty()) {
                    dispatcher.execute(results);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u6307\u4ee4\u8bed\u6cd5\u9519\u8bef"), false);
                }
            }
            catch (CommandSyntaxException e) {
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c\u6267\u884c\u5931\u8d25: " + e.getMessage())), false);
            }
        });
    }
}

