/*
 * Decompiled with CFR 0.152.
 */
package rems.carpet;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rems.carpet.REMSSettings;
import rems.carpet.command.soundsuppressionintroduce.UpdateDepressionCommands;
import rems.carpet.utils.ComponentTranslate;

public class REMSServer
implements CarpetExtension,
ModInitializer {
    public static String MOD_ID = "remscarpetadditions";
    public static final String MOD_NAME = "Carpet REMS Additions";
    public static final Logger LOGGER = LogManager.getLogger((String)"Carpet REMS Additions");
    private static final REMSServer INSTANCE = new REMSServer();
    private static MinecraftServer minecraftServer;
    public static Boolean shouldKeepPearl;

    public static MinecraftServer getServer() {
        if (minecraftServer == null) {
            throw new RuntimeException("MinecraftServer hasn't finished initializing yet!");
        }
        return minecraftServer;
    }

    public static String getVersion() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow()).getMetadata().getVersion().getFriendlyString();
    }

    public static void loadExtension() {
        CarpetServer.manageExtension((CarpetExtension)INSTANCE);
    }

    public void onInitialize() {
        REMSServer.loadExtension();
        shouldKeepPearl = Boolean.getBoolean("pearl.keep");
        CommandRegistrationCallback.EVENT.register((dispatcher, context, environment) -> UpdateDepressionCommands.register((CommandDispatcher<class_2168>)dispatcher, context));
    }

    public void onGameStarted() {
        LOGGER.info(MOD_ID + " v" + REMSServer.getVersion() + "\u8f7d\u5165\u6210\u529f");
        LOGGER.info("\u5f00\u6e90\u94fe\u63a5\uff1ahttps://github.com/Hure-herd/REMS-Carpet-extra");
        CarpetServer.settingsManager.parseSettingsClass(REMSSettings.class);
    }

    public Map<String, String> canHasTranslations(String lang) {
        return ComponentTranslate.getTranslationFromResourcePath(lang);
    }

    public void onServerLoaded(MinecraftServer server) {
        minecraftServer = server;
    }
}

