/*
 * This file is part of the Carpet REMS Addition project, licensed under the
 * GNU Lesser General Public License v3.0
 *
 * Copyright (C) 2025 A Minecraft Server and contributors
 *
 * Carpet REMS Addition is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Carpet REMS Addition is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Carpet REMS Addition. If not, see <https://www.gnu.org/licenses/>.
 */

package rems.carpet.mixins.ChestMinecartEntityChunkLoader;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rems.carpet.REMSSettings;
import java.util.Comparator;
import net.minecraft.class_1297;
import net.minecraft.class_1694;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3230;

@Mixin(class_1297.class)
public class ChestMinecartEntityMixin {
    private static final class_3230<class_1923> CHEST_MINECART_TICKET = class_3230.method_20628("chest_minecart_loader", Comparator.comparingLong(class_1923::method_8324), 40);

    @Inject(method = "move", at = @At("HEAD"))
    private void onTick(CallbackInfo ci) {
        if ((Object) this instanceof class_1694) {
            class_1694 self = (class_1694) (Object) this;
            class_1937 world = self.method_5770();
            if (REMSSettings.chestMinecartChunkLoader && self.method_16914() && !world.field_9236 && "Load".equals(self.method_5797().getString())) {
                int chunkX = (int) Math.floor(self.method_23317()) >> 4;
                int chunkZ = (int) Math.floor(self.method_23321()) >> 4;
                class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                ((class_3218) world).method_14178().method_17297(CHEST_MINECART_TICKET, chunkPos, 2,chunkPos);
            }
        }
    }
}
