/*
 * This file is part of the Carpet AMS Addition project, licensed under the
 * GNU Lesser General Public License v3.0
 *
 * Copyright (C) 2025 A Minecraft Server and contributors
 *
 * Carpet AMS Addition is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Carpet AMS Addition is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Carpet AMS Addition. If not, see <https://www.gnu.org/licenses/>.
 */

package rems.carpet.mixins.DisablePortalUpdate;

import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2423;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import rems.carpet.REMSSettings;

@Mixin(class_2423.class)
@SuppressWarnings("deprecation")
public abstract class NetherPortalBlockMixin extends class_2248 {
    public NetherPortalBlockMixin(class_2251 settings) {
        super(settings);
    }

    @Shadow
    public abstract class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState,
                                                         class_1936 world, class_2338 pos, class_2338 neighborPos);

    @Inject(method = "getStateForNeighborUpdate", at = @At("HEAD"), cancellable = true)
    private void update(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos,
                        class_2338 neighborPos, CallbackInfoReturnable<class_2680> cir) {
        if (REMSSettings.disablePortalUpdate) {
            cir.setReturnValue(super.method_9559(state, direction, neighborState, world, pos, neighborPos));
        }
    }
}
