/*
 * This file is part of the Carpet REMS Addition project, licensed under the
 * GNU Lesser General Public License v3.0
 *
 * Copyright (C) 2025 A Minecraft Server and contributors
 *
 * Carpet REMS Addition is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Carpet REMS Addition is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Carpet REMS Addition. If not, see <https://www.gnu.org/licenses/>.
 */

package rems.carpet.mixins.EnderPearlChunkLoader;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rems.carpet.REMSServer;
import rems.carpet.REMSSettings;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1684;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_3194;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_3857;

@Mixin(class_1684.class)
public abstract class EnderPearlEntityMixin extends class_3857 {

    @Shadow public abstract void method_5773();

    private boolean sync = true;
    private class_243 realPos = null;
    private class_243 realVelocity = null;
    private int tick = 1;

    protected EnderPearlEntityMixin(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    private static final class_3230<class_1923> ENDER_PEARL_TICKET =
            class_3230.method_20628("ender_pearl", Comparator.comparingLong(class_1923::method_8324), 2);

    private static final class_3230<class_1923> ENDER_PEARL_TICKETS =
            class_3230.method_20628("ender_pearl", Comparator.comparingLong(class_1923::method_8324), 10);

    private static boolean isEntityTickingChunk(class_2818 chunk) {
        //#if MC<12001
        //$$ return (chunk != null && chunk.getLevelType() == ChunkHolder.LevelType.ENTITY_TICKING);
        //#else
        return (chunk != null && chunk.method_12225() == class_3194.field_13877);
        //#endif
    }

    private static int getHighestMotionBlockingY(class_2487 nbtCompound) {
        int highestY = Integer.MIN_VALUE;
        if (REMSSettings.pearlTickets && nbtCompound != null) {
            for (long element : nbtCompound.method_10562("Heightmaps").method_10565("MOTION_BLOCKING")) {
                for (int i = 0; i < 7; i++) {
                    //#if MC<12101
                    int y = (int)(element & 0b111111111) - 1;
                    //#else
                    //$$ int y = (int)(element & 0b111111111);
                    //#endif
                    if (y > highestY) highestY = y;
                    element = element >> 9;
                }
            }
        }
        return highestY;
    }

    @Inject(method = "tick", at = @At(value = "HEAD"))
    private void skippyChunkLoading(CallbackInfo ci) {
        class_1937 world = this.method_5770();

        if (REMSSettings.pearlTickets && world instanceof class_3218) {
            class_243 currPos = this.method_19538().method_1019(class_243.field_1353);
            class_243 currVelocity = this.method_18798().method_1019(class_243.field_1353);

            if (this.sync) {
                this.realPos = currPos;
                this.realVelocity = currVelocity;
            }
            //#if MC<12101
            class_243 nextPos = this.realPos.method_1019(this.realVelocity);
            class_243 nextVelocity = this.realVelocity.method_1021(0.99F).method_1023(0, this.method_7490(), 0);
            //#else
            //$$ Vec3d nextVelocity = this.realVelocity.multiply(0.99F).subtract(0, 0.0297, 0);
            //$$ Vec3d nextPos = this.realPos.add(nextVelocity);
            //#endif
            class_1923 currChunkPos = new class_1923(new class_2338((int)currPos.field_1352, (int)currPos.field_1351, (int)currPos.field_1350));
            class_1923 nextChunkPos = new class_1923(new class_2338((int)nextPos.field_1352, (int)nextPos.field_1351, (int)nextPos.field_1350));
            class_3215 serverChunkManager = ((class_3218) world).method_14178();

            if (!this.sync || !isEntityTickingChunk(serverChunkManager.method_21730(nextChunkPos.field_9181, nextChunkPos.field_9180))) {
                class_2487 nbtCompound1;
                class_2487 nbtCompound2;
                try {
                    //#if MC<12101
                    nbtCompound1 = serverChunkManager.field_17254.method_23696(currChunkPos).get().orElse(null);
                    nbtCompound2 = serverChunkManager.field_17254.method_23696(nextChunkPos).get().orElse(null);
                    //#else
                    //$$ nbtCompound1 = serverChunkManager.chunkLoadingManager.getNbt(currChunkPos).get().orElse(null);
                    //$$ nbtCompound2 = serverChunkManager.chunkLoadingManager.getNbt(nextChunkPos).get().orElse(null);
                    //#endif
                } catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("NbtCompound exception");
                }

                int highestMotionBlockingY = Integer.max(getHighestMotionBlockingY(nbtCompound1), getHighestMotionBlockingY(nbtCompound2));
                class_2874 worldDimension = world.method_8597();
                highestMotionBlockingY += worldDimension.comp_651();
                class_1657 owner = (class_1657) this.method_24921();
                if(this.tick == 1){
                    serverChunkManager.method_17297(ENDER_PEARL_TICKETS, nextChunkPos, 2, currChunkPos);
                    serverChunkManager.method_17297(ENDER_PEARL_TICKETS, currChunkPos, 2, currChunkPos);
                    this.tick =2;
                }

                if (this.realPos.field_1351 > highestMotionBlockingY
                        && nextPos.field_1351 > highestMotionBlockingY
                        && nextPos.field_1351 + nextVelocity.field_1351 > highestMotionBlockingY) {
                        serverChunkManager.method_17297(ENDER_PEARL_TICKETS, currChunkPos, 2, currChunkPos);
                        this.method_18799(class_243.field_1353);
                        this.method_33574(currPos);
                        this.sync = false;
                        if(REMSSettings.pearlPosVelocity){
                        owner.method_7353(class_2561.method_30163("EnderPearlY" + realPos), false);
                        owner.method_7353(class_2561.method_30163("EnderPearlV" + realVelocity), false);}
                } else {
                    serverChunkManager.method_17297(ENDER_PEARL_TICKET, nextChunkPos, 2, nextChunkPos);
                    this.method_18799(this.realVelocity);
                    this.method_33574(this.realPos);
                    this.sync = true;
                    this.tick =1;
                }
                this.realPos = nextPos;
                this.realVelocity = nextVelocity;
            }
        }
    }

    //#if MC>=12102
    //$$ @Redirect(method = "tick",
    //$$        at= @At(value = "INVOKE",
    //$$        target = "Lnet/minecraft/server/network/ServerPlayerEntity;handleThrownEnderPearl(Lnet/minecraft/entity/projectile/thrown/EnderPearlEntity;)J"))
    //$$ private long load(ServerPlayerEntity instance, EnderPearlEntity enderPearl){
    //$$     if(REMSSettings.pearlTickets){
    //$$         int pearlBlockX = (int) Math.floor(enderPearl.getX());
    //$$         int pearlBlockZ = (int) Math.floor(enderPearl.getZ());
    //$$          double pearlX = enderPearl.getX();
    //$$          double pearlZ = enderPearl.getZ();
    //$$          double blockMinX = pearlBlockX;
    //$$          double blockMaxX = blockMinX + 1;
    //$$          double blockMinZ = pearlBlockZ;
    //$$          double blockMaxZ = blockMinZ + 1;
    //$$          if(pearlX >= blockMinX && pearlX < blockMaxX && pearlZ >= blockMinZ && pearlZ < blockMaxZ) {
    //$$            return instance.handleThrownEnderPearl(enderPearl);
    //$$        }
    //$$        else{
    //$$            return 0;
    //$$        }
    //$$    } else {
    //$$        return instance.handleThrownEnderPearl(enderPearl);
    //$$    }
    //$$ }
    //#endif

    //#if MC>=12102
    //$$ protected Item getDefaultItem() {
    //$$     return Items.ENDER_PEARL;
    //$$ }
    //#endif

    //#if MC<12102
    @Unique
    private long highSpeedTick = -1L;

    @Unique
    private long chunkTicketExpiryTicks = 0L;

    private static int getSectionCoordFloored(double coord) {
        return class_3532.method_15357(coord) >> 4;
    }

    private static int getSectionCoord(int coord) {
        return coord >> 4;
    }

    private static long addEnderPearlTicket(class_3218 ServerWolrd, class_1923 chunkPos) {
        ServerWolrd.method_14178().method_17297(ENDER_PEARL_TICKETS, chunkPos, 2, chunkPos);
        return ENDER_PEARL_TICKETS.method_20629();
    }

    @Inject(
            method = "tick",
            at = @At("HEAD")
    )
    private void getVector(CallbackInfo ci, @Share("i") LocalIntRef i, @Share("j") LocalIntRef j) {
        i.set(getSectionCoordFloored(this.method_19538().method_10216()));
        j.set(getSectionCoordFloored(this.method_19538().method_10215()));
    }

    @Inject(
            method = "tick",
            at = @At("TAIL")
    )
    private void loadingChunks(
            CallbackInfo ci,
            @Share("i") LocalIntRef i,
            @Share("j") LocalIntRef j
    ) {
        class_1297 entity = this.method_24921();
        if(!REMSSettings.enderpearlloadchunk){
            return;
        }

        double xVel = Math.abs(this.method_18798().method_10216());
        double zVel = Math.abs(this.method_18798().method_10215());
        boolean highSpeed = xVel >= 20d || zVel >= 20d;

        if (highSpeed && this.highSpeedTick == -1L) {
            this.highSpeedTick = this.field_6012;
        }

        if (!REMSServer.shouldKeepPearl && highSpeedTick != -1L && this.field_6012 - highSpeedTick > REMSSettings.Pearltime
        ) {
            REMSServer.LOGGER.warn(
                    "The pearl(own: {}) has been in high speed for a long time and has been removed",
                    entity instanceof class_3222 ? entity.method_5477().getString() : "unknown"
            );
            this.method_31472();
        }

        if (this.method_5805()) {
            class_2338 blockPos = class_2338.method_49638(this.method_19538());
            if (
                    (
                            --this.chunkTicketExpiryTicks <= 0L
                                    || i.get() != getSectionCoord(blockPos.method_10263())
                                    || j.get() != getSectionCoord(blockPos.method_10260())
                    )
                            && entity instanceof class_3222 serverPlayerEntity
            ) {
                this.chunkTicketExpiryTicks = this.handleThrownEnderPearl();
                if (!serverPlayerEntity.method_51469().field_26934.method_31793(this)) {
                    serverPlayerEntity.method_51469().field_26934.method_31790(this);
                }
            }
        }
    }

    @Unique
    private long handleThrownEnderPearl() {
        if (this.method_37908() instanceof class_3218 serverWorld) {
            class_1923 chunkPos = this.method_31476();
            serverWorld.method_14197();
            return addEnderPearlTicket(serverWorld, chunkPos) - 1L;
        } else {
            return 0L;
        }
    }
    //#endif
}

