/*
 * This file is part of the Carpet AMS Addition project, licensed under the
 * GNU Lesser General Public License v3.0
 *
 * Copyright (C) 2025 A Minecraft Server and contributors
 *
 * Carpet AMS Addition is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Carpet AMS Addition is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Carpet AMS Addition. If not, see <https://www.gnu.org/licenses/>.
 */

package rems.carpet.mixins.MergeTNTPro;

import carpet.fakes.TntEntityInterface;
import carpet.CarpetSettings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import carpet.logging.LoggerRegistry;
import carpet.logging.logHelpers.TNTLogHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import rems.carpet.REMSSettings;


@Mixin(class_1541.class)
public abstract class TntEntityMixin extends class_1297 implements TntEntityInterface
{
    @Shadow public abstract int getFuse();

    private TNTLogHelper logHelper;
    private boolean mergeBool = false;
    private int mergedTNT = 1;

    public TntEntityMixin(class_1299<?> entityType_1, class_1937 world_1)
    {
        super(entityType_1, world_1);
    }


    @Inject(method = "<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/entity/LivingEntity;)V",
            at = @At("RETURN"))
    private void modifyTNTAngle(class_1937 world, double x, double y, double z, class_1309 entity, CallbackInfo ci)
    {
        if (CarpetSettings.hardcodeTNTangle != -1.0D)
            method_18800(-Math.sin(CarpetSettings.hardcodeTNTangle) * 0.02, 0.2, -Math.cos(CarpetSettings.hardcodeTNTangle) * 0.02);
    }

    @Inject(method = "<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V", at = @At("RETURN"))
    private void initTNTLoggerPrime(class_1299<? extends class_1541> entityType_1, class_1937 world_1, CallbackInfo ci)
    {
        if (LoggerRegistry.__tnt && !world_1.field_9236)
        {
            logHelper = new TNTLogHelper();
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void initTracker(CallbackInfo ci)
    {
        if (LoggerRegistry.__tnt && logHelper != null && !logHelper.initialized)
        {
            logHelper.onPrimed(method_23317(), method_23318(), method_23321(), method_18798());
        }
    }


    @Inject(method = "<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/entity/LivingEntity;)V",
            at = @At(value = "RETURN"))
    private void initTNTLogger(class_1937 world_1, double double_1, double double_2, double double_3,
                               class_1309 livingEntity_1, CallbackInfo ci)
    {
        if(CarpetSettings.tntPrimerMomentumRemoved)
            this.method_18799(new class_243(0.0, 0.20000000298023224D, 0.0));
    }

    @Inject(method = "explode", at = @At(value = "HEAD"))
    private void onExplode(CallbackInfo ci) {
        if (LoggerRegistry.__tnt && logHelper != null)
            logHelper.onExploded(method_23317(), method_23318(), method_23321(), this.method_37908().method_8510());

        if (mergedTNT > 1)
            for (int i = mergedTNT; i < mergedTNT - 1; i++){
                this.method_37908().method_8437(this, this.method_23317(), this.method_23323(0.0625),
                        this.method_23321(), 4.0F, class_1937.class_7867.field_40891);
            }
    }

    @Inject(method = "tick", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/entity/TntEntity;setVelocity(Lnet/minecraft/util/math/Vec3d;)V",
            //#if MC<1206
            //$$ ordinal = 2))
            //#else
            ordinal = 1))
            //#endif
    private void tryMergeTnT(CallbackInfo ci)
    {
        if(REMSSettings.mergeTNTPro){
            class_243 velocity = method_18798();
            if(!method_5770().field_9236 && mergeBool && velocity.field_1352 == 0 && velocity.field_1351 == 0 && velocity.field_1350 == 0){
                mergeBool = false;
                for(class_1297 entity : method_5770().method_8335(this, this.method_5829())){
                    if(entity instanceof class_1541 && !entity.method_31481()){
                        class_1541 entityTNTPrimed = (class_1541)entity;
                        class_243 tntVelocity = entityTNTPrimed.method_18798();
                        if(tntVelocity.field_1352 == 0 && tntVelocity.field_1351 == 0 && tntVelocity.field_1350 == 0
                                && this.method_23317() == entityTNTPrimed.method_23317() && this.method_23321() == entityTNTPrimed.method_23321() && this.method_23318() == entityTNTPrimed.method_23318()
                                && getFuse() == entityTNTPrimed.method_6969() +1){
                            mergedTNT += ((TntEntityInterface) entityTNTPrimed).getMergedTNT();
                            entityTNTPrimed.method_5650(class_1297.class_5529.field_26999);
                        }
                    }
                }
            }
        }
    }

    @Inject(method = "tick", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/entity/TntEntity;setFuse(I)V",
            ordinal = 0))
    private void setMergeable(CallbackInfo ci)
    {
        class_243 velocity = method_18798();
        if(!method_5770().field_9236 && (velocity.field_1351 != 0 || velocity.field_1352 != 0 || velocity.field_1350 != 0)){
            mergeBool = true;
        }
    }

    @Override
    public int getMergedTNT() {
        return mergedTNT;
    }
}