/*
 * This file is part of the Carpet REMS Addition project, licensed under the
 * GNU Lesser General Public License v3.0
 *
 * Copyright (C) 2025 A Minecraft Server and contributors
 *
 * Carpet REMS Addition is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Carpet REMS Addition is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Carpet REMS Addition. If not, see <https://www.gnu.org/licenses/>.
 */

package rems.carpet.mixins.PistonBlockChunkLoader;

import rems.carpet.REMSSettings;
import net.minecraft.block.*;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2665;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Comparator;


@Mixin(class_2665.class)
public abstract class PistonBlockMixin
{

    private static final class_3230<class_1923> PISTON_BLOCK_TICKET = class_3230.method_20628("piston_block", Comparator.comparingLong(class_1923::method_8324), 60);

    private static final int DiamondOreHash = new class_2960("minecraft", "diamond_ore").hashCode();

    private static final int GoldOreHash = new class_2960("minecraft", "gold_ore").hashCode();

    private static final int RedStoneOreHash = new class_2960("minecraft", "redstone_ore").hashCode();

    private static final int BedrockHash = new class_2960("minecraft", "bedrock").hashCode();

    private static final int RedStoneTorchHash = new class_2960("minecraft", "redstone_torch").hashCode();

    @Inject(method = "onSyncedBlockEvent", at = @At("HEAD"))
    private void load(class_2680 state, class_1937 world, class_2338 pos, int type, int data, CallbackInfoReturnable info)
    {
        if(REMSSettings.pistonBlockChunkLoader && !world.field_9236)
        {
            class_2350 direction = state.method_11654(class_2318.field_10927);

            class_2338 nbp = new class_2338(pos.method_10263(), pos.method_10264() + 1, pos.method_10260());
            class_2248 block = world.method_8320(nbp).method_26204();

            class_2338 nbp1 = new class_2338(pos.method_10263(), pos.method_10264() - 1, pos.method_10260());
            class_2248 block1 = world.method_8320(nbp1).method_26204();

            class_2338 nbp2 = pos.method_10093(direction.method_10153()).method_10084();
            class_2248 block2 = world.method_8320(nbp2).method_26204();

            if (class_7923.field_41175.method_10221(block).hashCode() == DiamondOreHash)
            {
                int x = pos.method_10263() + direction.method_10148();
                int z = pos.method_10260() + direction.method_10165();

                class_1923 cp = new class_1923(x >> 4, z >> 4);
                ((class_3218) world).method_14178().method_17297(PISTON_BLOCK_TICKET, cp, 1, cp);
            }
            if (class_7923.field_41175.method_10221(block).hashCode() == RedStoneOreHash)
            {
                int x = pos.method_10263() + direction.method_10148();
                int z = pos.method_10260() + direction.method_10165();

                class_1923 cp = new class_1923(x >> 4, z >> 4);
                ((class_3218) world).method_14178().method_17297(PISTON_BLOCK_TICKET, cp, 3, cp);
            }
            if (class_7923.field_41175.method_10221(block).hashCode() == GoldOreHash)
            {
                int x = pos.method_10263() + direction.method_10148();
                int z = pos.method_10260() + direction.method_10165();

                class_1923 cp = new class_1923(x >> 4, z >> 4);
                ((class_3218) world).method_14178().method_17297(PISTON_BLOCK_TICKET, cp, 2, cp);
            }
            if (class_7923.field_41175.method_10221(block1).hashCode() == BedrockHash && class_7923.field_41175.method_10221(block2).hashCode() == RedStoneTorchHash &&
                    world.method_27983() == class_1937.field_25180)
            {
                int x = pos.method_10263() + direction.method_10148();
                int z = pos.method_10260() + direction.method_10165();

                class_1923 cp = new class_1923(x >> 4, z >> 4);
                ((class_3218) world).method_14178().method_17297(PISTON_BLOCK_TICKET, cp, 1, cp);
            }
        }
    }
}
