/*
 * This file is part of the Carpet REMS Addition project, licensed under the
 * GNU Lesser General Public License v3.0
 *
 * Copyright (C) 2025 A Minecraft Server and contributors
 *
 * Carpet REMS Addition is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Carpet REMS Addition is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Carpet REMS Addition. If not, see <https://www.gnu.org/licenses/>.
 */

package rems.carpet.mixins.PortalPearlWarp;

import org.spongepowered.asm.mixin.injection.Redirect;
import rems.carpet.REMSSettings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1684;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_3222;
import net.minecraft.class_3857;
import net.minecraft.class_3965;

import static net.minecraft.class_2398.field_11214;

@Mixin(class_1684.class)
public abstract class EnderPearlTeleportMixin {
    //#if MC<12102
    //#if MC>12006
    //$$ @Redirect(method ="canTeleportEntityTo",at=@At(value = "INVOKE",target = "Lnet/minecraft/entity/Entity;canUsePortals(Z)Z"))
    //$$ private static boolean canTeleportEntityTo(Entity pearl, boolean b){
    //$$    if(REMSSettings.PortalPearlWarp && pearl instanceof EnderPearlEntity){
    //$$        if(pearl.getX() > 914 && pearl.getX() < 916 && pearl.getZ() > 914 && pearl.getZ() < 916
    //$$            || pearl.getX() > 7323 && pearl.getX() < 7325 && pearl.getZ() > 7323 && pearl.getZ() < 7325
    //$$            || pearl.getX() > 58591 && pearl.getX() < 58593 && pearl.getZ() > 58591 && pearl.getZ() < 58593
    //$$            || pearl.getX() > 468742 && pearl.getX() < 468744 && pearl.getZ() > 468742 && pearl.getZ() < 468744
    //$$            || pearl.getX() < -7323 && pearl.getX() > -7325 && pearl.getZ() < -7323 && pearl.getZ() > -7325
    //$$            || pearl.getX() < -58591 && pearl.getX() > -58593 && pearl.getZ() < -58591 && pearl.getZ() > -58593
    //$$            || pearl.getX() < -468742 && pearl.getX() > -468744 && pearl.getZ() < -468742 && pearl.getZ() > -468744 //地狱的地狱门位置
    //$$            || pearl.getX() > 29999599 && pearl.getX() < 29999601 && pearl.getZ() > 29999599 && pearl.getZ() < 29999601
    //$$            || pearl.getX() > 3749941 && pearl.getX() < 3749943 && pearl.getZ() > 3749941 && pearl.getZ() < 3749943
    //$$            || pearl.getX() > 468734 && pearl.getX() < 468736 && pearl.getZ() > 468734 && pearl.getZ() < 468736
    //$$            || pearl.getX() > 58584 && pearl.getX() < 58586 && pearl.getZ() > 58584 && pearl.getZ() < 58586
    //$$            || pearl.getX() < -29999599 && pearl.getX() > -29999601 && pearl.getZ() < -29999599 && pearl.getZ() > -29999601
    //$$            || pearl.getX() < -3749941 && pearl.getX() > -3749943 && pearl.getZ() < -3749941 && pearl.getZ() > -3749943
    //$$            || pearl.getX() < -468734 && pearl.getX() > -468736 && pearl.getZ() < -468734 && pearl.getZ() > -468736
    //$$            || pearl.getX() < -58584 && pearl.getX() > -58586 && pearl.getZ() < -58584 && pearl.getZ() > -58586
    //$$          ){
    //$$            return false;}
    //$$        else {
    //$$            return true;
    //$$        }
    //$$    }
    //$$    return true;
    //$$ }
    //#endif
    @Inject(method = "onCollision", at = @At("HEAD"), cancellable = true)
    private void onPearlHit(class_239 hitResult, CallbackInfo ci) {
        if(REMSSettings.PortalPearlWarp){
        class_3857 pearl = (class_3857) (Object) this;
        class_1937 world = pearl.method_37908();

        if (world.method_8608() || pearl.method_7495().method_7909() != class_1802.field_8634) return;

        if (hitResult.method_17783() != class_239.class_240.field_1332) return;
        class_3965 blockHit = (class_3965) hitResult;
        class_2338 hitPos = blockHit.method_17777();

        if (!world.method_8320(hitPos).method_27852(class_2246.field_10540)) return;

        if(pearl.method_23317() > 914 && pearl.method_23317() < 916 && pearl.method_23321() > 914 && pearl.method_23321() < 916
            || pearl.method_23317() > 7323 && pearl.method_23317() < 7325 && pearl.method_23321() > 7323 && pearl.method_23321() < 7325
            || pearl.method_23317() > 58591 && pearl.method_23317() < 58593 && pearl.method_23321() > 58591 && pearl.method_23321() < 58593
            || pearl.method_23317() > 468742 && pearl.method_23317() < 468744 && pearl.method_23321() > 468742 && pearl.method_23321() < 468744
            || pearl.method_23317() < -7323 && pearl.method_23317() > -7325 && pearl.method_23321() < -7323 && pearl.method_23321() > -7325
            || pearl.method_23317() < -58591 && pearl.method_23317() > -58593 && pearl.method_23321() < -58591 && pearl.method_23321() > -58593
            || pearl.method_23317() < -468742 && pearl.method_23317() > -468744 && pearl.method_23321() < -468742 && pearl.method_23321() > -468744 //地狱的地狱门位置
            || pearl.method_23317() > 29999599 && pearl.method_23317() < 29999601 && pearl.method_23321() > 29999599 && pearl.method_23321() < 29999601
            || pearl.method_23317() > 3749941 && pearl.method_23317() < 3749943 && pearl.method_23321() > 3749941 && pearl.method_23321() < 3749943
            || pearl.method_23317() > 468734 && pearl.method_23317() < 468736 && pearl.method_23321() > 468734 && pearl.method_23321() < 468736
            || pearl.method_23317() > 58584 && pearl.method_23317() < 58586 && pearl.method_23321() > 58584 && pearl.method_23321() < 58586
            || pearl.method_23317() < -29999599 && pearl.method_23317() > -29999601 && pearl.method_23321() < -29999599 && pearl.method_23321() > -29999601
            || pearl.method_23317() < -3749941 && pearl.method_23317() > -3749943 && pearl.method_23321() < -3749941 && pearl.method_23321() > -3749943
            || pearl.method_23317() < -468734 && pearl.method_23317() > -468736 && pearl.method_23321() < -468734 && pearl.method_23321() > -468736
            || pearl.method_23317() < -58584 && pearl.method_23317() > -58586 && pearl.method_23321() < -58584 && pearl.method_23321() > -58586//主世界的地狱门位置
            ) {

        class_1297 owner = pearl.method_24921();
        if (!(owner instanceof class_3222 player)) return;

        ci.cancel();

        double scale = 1.0;
        if (world.method_27983() == class_1937.field_25179) {
            scale = 0.125; // 主世界坐标缩小8倍
        } else if (world.method_27983() == class_1937.field_25180) {
            scale = 8.0; // 地狱坐标扩大8倍
        }

        double tx = hitPos.method_10263() * scale;
        double ty = hitPos.method_10264();
        double tz = hitPos.method_10260() * scale;

        pearl.method_31472();

        player.method_6082(tx, ty, tz, field_11214.method_10299());
        player.method_5814(tx,ty,tz);
        player.field_13987.method_14363(
              tx,
              ty,
              tz,
              player.method_36454(),
              player.method_36455()
            );
        }
    }
    }
    //#endif
}