/*
 * This file is part of the Carpet REMS Addition project, licensed under the
 * GNU Lesser General Public License v3.0
 *
 * Copyright (C) 2025 A Minecraft Server and contributors
 *
 * Carpet REMS Addition is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Carpet REMS Addition is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Carpet REMS Addition. If not, see <https://www.gnu.org/licenses/>.
 */

package rems.carpet.mixins.SignCommand;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import rems.carpet.REMSServer;
import rems.carpet.REMSSettings;
import rems.carpet.utils.SignCommand;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5837;
import net.minecraft.class_8242;

@Mixin(class_2625.class) // 向告示牌实体注入代码
public abstract class SignBlockEntityMixin {
    @Inject(method = "tryChangeText", at = @At("HEAD"), cancellable = true)
    public void PreventChangeTextWhenEmptyHands(class_1657 player, boolean front, List<class_5837> messages, CallbackInfo ci) {
        if (REMSSettings.SignCommand) {
            if (player instanceof class_3222) {
                REMSServer.LOGGER.debug("Player is trying to change the text, checking sign text");
                class_3218 world = (class_3218) player.method_5770();
                class_2338 pos = ((class_2625) (Object) this).method_11016();
                if (world.method_8321(pos) instanceof class_2625 signBlockEntity) {
                    boolean isFront = signBlockEntity.method_49834(player);
                    class_8242 texts = signBlockEntity.method_49843(isFront);
                    class_2561[] text = texts.method_49877(false);
                    REMSServer.LOGGER.debug("Sign text: " + text[0].getString());
                    if (text[0].getString().startsWith("/")) {
                        REMSServer.LOGGER.debug("Player is trying to change the text, but the text starts with /");
                        class_2561 message = class_2561.method_43470(SignCommand.getTranslation("carpet.runCommandOnSignTips"));
                        player.method_7353(message, false);
                    }
                }
            }
        }
    }
}
