/*
 * This file is part of the Carpet AMS Addition project, licensed under the
 * GNU Lesser General Public License v3.0
 *
 * Copyright (C) 2023  A Minecraft Server and contributors
 *
 * Carpet AMS Addition is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Carpet AMS Addition is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Carpet AMS Addition.  If not, see <https://www.gnu.org/licenses/>.
 */

package rems.carpet.mixins.scheduledRandomTick;

import net.minecraft.class_2338;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rems.carpet.REMSSettings;

@Mixin(class_2523.class)
public abstract class SugarCaneBlockMixin {

    @Shadow
    public abstract void randomTick(class_2680 state, class_3218 world, class_2338 pos, class_5819 random);

    @Inject(
        method = "scheduledTick",
        at = @At(
            value = "INVOKE",
            shift = At.Shift.AFTER,
            target = "Lnet/minecraft/server/world/ServerWorld;breakBlock(Lnet/minecraft/util/math/BlockPos;Z)Z"
        ),
        cancellable = true
    )
    private void scheduleTickMixinInvoke(CallbackInfo ci) {
        if (REMSSettings.scheduledRandomTickPlants) {
            ci.cancel();
        }
    }

    @Inject(method = "scheduledTick", at = @At("TAIL"))
    private void scheduleTickMixinTail(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
        if (REMSSettings.scheduledRandomTickPlants) {
            this.randomTick(state, world, pos, random);
        }
    }
}
