/*
 * This file is part of the Carpet REMS Addition project, licensed under the
 * GNU Lesser General Public License v3.0
 *
 * Copyright (C) 2025 A Minecraft Server and contributors
 *
 * Carpet REMS Addition is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Carpet REMS Addition is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Carpet REMS Addition. If not, see <https://www.gnu.org/licenses/>.
 */

package rems.carpet.mixins.sharedVillagerDiscounts;

import rems.carpet.REMSSettings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_4136;
import net.minecraft.class_4139;

@Mixin(class_4136.class)
public abstract class VillagerGossipsMixin implements VillagerGossipsAccessor, VillagerGossips_ReputationInvoker {
    @Inject(method = "getReputationFor(Ljava/util/UUID;Ljava/util/function/Predicate;)I", at = @At("HEAD"), cancellable = true)
    private void getReputation(UUID target, Predicate<class_4139> filter, CallbackInfoReturnable<Integer> cir) {
        if (REMSSettings.sharedVillagerDiscounts && filter.test(class_4139.field_18427)) {
            VillagerGossips_ReputationInvoker targetReputation = (VillagerGossips_ReputationInvoker) this.getEntityReputation().get(target);
            int otherRep = 0;
            if (targetReputation != null) {
                otherRep = targetReputation.invokeGetValueFor(vgt -> filter.test(vgt) && !vgt.equals(class_4139.field_18427));
            }
            int majorPositiveRep = 0;
            for (Object reputation : this.getEntityReputation().values()) {
                VillagerGossips_ReputationInvoker invoker = (VillagerGossips_ReputationInvoker) reputation;
                majorPositiveRep += invoker.invokeGetValueFor(vgt -> vgt.equals(class_4139.field_18427));
            }
            int maxMajorPositiveRep = class_4139.field_18427.field_18432 * class_4139.field_18427.field_18431;
            cir.setReturnValue(otherRep + Math.min(majorPositiveRep, maxMajorPositiveRep));
        }
    }
}
