/*
 * This file is part of the Carpet REMS Addition project, licensed under the
 * GNU Lesser General Public License v3.0
 *
 * Copyright (C) 2025 A Minecraft Server and contributors
 *
 * Carpet REMS Addition is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Carpet REMS Addition is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Carpet REMS Addition. If not, see <https://www.gnu.org/licenses/>.
 */

package rems.carpet.utils;

import carpet.CarpetSettings;
import com.mojang.brigadier.CommandDispatcher;
import rems.carpet.REMSServer;

import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5251;

public class SignCommand {
    public static void executeCommand(class_3222 player, String command) {
        if (player == null || command == null || command.trim().isEmpty()) {
            throw new IllegalArgumentException("Player or command cannot be null or empty");
        }
// 若带有 / 则去掉
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        var server = player.method_5682();
        if (server == null) {
            throw new IllegalStateException("Player is not on a server");
        }

        class_2168 source = player.method_5671();
        CommandDispatcher<class_2168> dispatcher = server.method_3734().method_9235();

        try {
            // 解析和执行命令
            var parseResults = dispatcher.parse(command, source);
            dispatcher.execute(parseResults);
        } catch (Exception e) {
            class_2561 text = class_2561.method_43470(getTranslation("carpet.commandWentWrong"))
                    .method_10862(class_2583.field_24360.method_27703(class_5251.method_27718(class_124.field_1061))).method_10852(class_2561.method_43470(" /" + command + ": " + e.getMessage())
                            .method_10862(class_2583.field_24360.method_27703(class_5251.method_27718(class_124.field_1061)).method_30938(true)));
            player.method_7353(text, false);
            REMSServer.LOGGER.debug("Failed to execute command: " + command + e.getMessage());
        }
    }

    public static String getTranslation(String key) {
        Map<String, String> lang = ComponentTranslate.getTranslationFromResourcePath(CarpetSettings.language);
        String translationText = lang.get(key);
        REMSServer.LOGGER.debug("Translation with key" + key + ": " + translationText);
        return lang.get(key);
    }
}
