/*
 * Decompiled with CFR 0.152.
 */
package rems.carpet.mixins.EnderPearlChunkLoader;

import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1684;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_3194;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3857;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rems.carpet.REMSSettings;

@Mixin(value={class_1684.class})
public abstract class EnderPearlEntityMixin
extends class_3857 {
    private boolean sync = true;
    private class_243 realPos = null;
    private class_243 realVelocity = null;
    private int tick = 1;
    private static final class_3230<class_1923> ENDER_PEARL_TICKET = class_3230.method_20628((String)"ender_pearl", Comparator.comparingLong(class_1923::method_8324), (int)2);
    private static final class_3230<class_1923> ENDER_PEARL_TICKETS = class_3230.method_20628((String)"ender_pearl", Comparator.comparingLong(class_1923::method_8324), (int)10);

    @Shadow
    public abstract void method_5773();

    protected EnderPearlEntityMixin(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    private static boolean isEntityTickingChunk(class_2818 chunk) {
        return chunk != null && chunk.method_12225() == class_3194.field_13877;
    }

    private static int getHighestMotionBlockingY(class_2487 nbtCompound) {
        int highestY = Integer.MIN_VALUE;
        if (REMSSettings.pearlTickets && nbtCompound != null) {
            for (long element : nbtCompound.method_10562("Heightmaps").method_10565("MOTION_BLOCKING")) {
                for (int i = 0; i < 7; ++i) {
                    int y = (int)(element & 0x1FFL);
                    if (y > highestY) {
                        highestY = y;
                    }
                    element >>= 9;
                }
            }
        }
        return highestY;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void skippyChunkLoading(CallbackInfo ci) {
        class_1937 world = this.method_5770();
        if (REMSSettings.pearlTickets && world instanceof class_3218) {
            class_243 currPos = this.method_19538().method_1019(class_243.field_1353);
            class_243 currVelocity = this.method_18798().method_1019(class_243.field_1353);
            if (this.sync) {
                this.realPos = currPos;
                this.realVelocity = currVelocity;
            }
            class_243 nextVelocity = this.realVelocity.method_1021((double)0.99f).method_1023(0.0, 0.0297, 0.0);
            class_243 nextPos = this.realPos.method_1019(nextVelocity);
            class_1923 currChunkPos = new class_1923(new class_2338((int)currPos.field_1352, (int)currPos.field_1351, (int)currPos.field_1350));
            class_1923 nextChunkPos = new class_1923(new class_2338((int)nextPos.field_1352, (int)nextPos.field_1351, (int)nextPos.field_1350));
            class_3215 serverChunkManager = ((class_3218)world).method_14178();
            if (!this.sync || !EnderPearlEntityMixin.isEntityTickingChunk(serverChunkManager.method_21730(nextChunkPos.field_9181, nextChunkPos.field_9180))) {
                class_2487 nbtCompound2;
                class_2487 nbtCompound1;
                try {
                    nbtCompound1 = ((Optional)serverChunkManager.field_17254.method_23696(currChunkPos).get()).orElse(null);
                    nbtCompound2 = ((Optional)serverChunkManager.field_17254.method_23696(nextChunkPos).get()).orElse(null);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("NbtCompound exception");
                }
                int highestMotionBlockingY = Integer.max(EnderPearlEntityMixin.getHighestMotionBlockingY(nbtCompound1), EnderPearlEntityMixin.getHighestMotionBlockingY(nbtCompound2));
                class_2874 worldDimension = world.method_8597();
                highestMotionBlockingY += worldDimension.comp_651();
                class_1657 owner = (class_1657)this.method_24921();
                if (this.tick == 1) {
                    serverChunkManager.method_17297(ENDER_PEARL_TICKETS, nextChunkPos, 2, (Object)currChunkPos);
                    serverChunkManager.method_17297(ENDER_PEARL_TICKETS, currChunkPos, 2, (Object)currChunkPos);
                    this.tick = 2;
                }
                if (this.realPos.field_1351 > (double)highestMotionBlockingY && nextPos.field_1351 > (double)highestMotionBlockingY && nextPos.field_1351 + nextVelocity.field_1351 > (double)highestMotionBlockingY) {
                    serverChunkManager.method_17297(ENDER_PEARL_TICKETS, currChunkPos, 2, (Object)currChunkPos);
                    this.method_18799(class_243.field_1353);
                    this.method_33574(currPos);
                    this.sync = false;
                    if (REMSSettings.pearlPosVelocity) {
                        owner.method_7353(class_2561.method_30163((String)("EnderPearlY" + String.valueOf(this.realPos))), false);
                        owner.method_7353(class_2561.method_30163((String)("EnderPearlV" + String.valueOf(this.realVelocity))), false);
                    }
                } else {
                    serverChunkManager.method_17297(ENDER_PEARL_TICKET, nextChunkPos, 2, (Object)nextChunkPos);
                    this.method_18799(this.realVelocity);
                    this.method_33574(this.realPos);
                    this.sync = true;
                    this.tick = 1;
                }
                this.realPos = nextPos;
                this.realVelocity = nextVelocity;
            }
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;handleThrownEnderPearl(Lnet/minecraft/entity/projectile/thrown/EnderPearlEntity;)J"))
    private long load(class_3222 instance, class_1684 enderPearl) {
        if (REMSSettings.pearlTickets) {
            int pearlBlockX = (int)Math.floor(enderPearl.method_23317());
            int pearlBlockZ = (int)Math.floor(enderPearl.method_23321());
            double pearlX = enderPearl.method_23317();
            double pearlZ = enderPearl.method_23321();
            double blockMinX = pearlBlockX;
            double blockMaxX = blockMinX + 1.0;
            double blockMinZ = pearlBlockZ;
            double blockMaxZ = blockMinZ + 1.0;
            if (pearlX >= blockMinX && pearlX < blockMaxX && pearlZ >= blockMinZ && pearlZ < blockMaxZ) {
                return instance.method_64133(enderPearl);
            }
            return 0L;
        }
        return instance.method_64133(enderPearl);
    }

    protected class_1792 method_16942() {
        return class_1802.field_8634;
    }
}

