/*
 * Decompiled with CFR 0.152.
 */
package rems.carpet.mixins.SignCommand;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2478;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_8242;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import rems.carpet.REMSSettings;

@Mixin(value={class_2478.class})
public class AbstractSignBlockMixin {
    @Unique
    private static final Set<String> ALLOWED_COMMANDS = new HashSet<String>(Arrays.asList("say", "player", "tick"));

    @Inject(method={"onUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit, CallbackInfoReturnable<class_1269> ci) {
        class_2586 class_25862;
        if (REMSSettings.SignCommand && (class_25862 = world.method_8321(pos)) instanceof class_2625) {
            class_2625 signBlockEntity = (class_2625)class_25862;
            boolean filtered = player.method_33793();
            boolean isFront = signBlockEntity.method_49834(player);
            class_8242 signText = isFront ? signBlockEntity.method_49853() : signBlockEntity.method_49854();
            String fullCommand = this.processSignText(signText, filtered);
            if (!fullCommand.startsWith("/")) {
                return;
            }
            String actualCommand = fullCommand.substring(1);
            if (!this.isCommandAllowed(actualCommand)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u8be5\u6307\u4ee4\u672a\u88ab\u5141\u8bb8\u901a\u8fc7\u544a\u793a\u724c\u6267\u884c"), false);
                ci.setReturnValue((Object)class_1269.field_5812);
                return;
            }
            if (player.method_6047().method_31574(class_1802.field_8162) && !player.method_5715()) {
                ci.setReturnValue((Object)class_1269.field_5812);
                this.executeValidatedCommand(player, actualCommand);
            }
        }
    }

    @Unique
    private String processSignText(class_8242 signText, boolean filtered) {
        StringBuilder commandBuilder = new StringBuilder();
        List<class_2561> textLines = List.of(signText.method_49877(filtered));
        for (int i = 0; i < textLines.size(); ++i) {
            String line = textLines.get(i).getString().replaceAll("\u00a7.", "").replaceAll("[\\x00-\\x1F]", "").trim();
            if (line.isEmpty()) continue;
            if (line.endsWith("\\")) {
                commandBuilder.append(line, 0, line.length() - 1);
                continue;
            }
            commandBuilder.append(line);
            if (i == textLines.size() - 1) continue;
            commandBuilder.append(" ");
        }
        return commandBuilder.toString().replaceAll("\\s+", " ").trim();
    }

    @Unique
    private boolean isCommandAllowed(String rawCommand) {
        String[] parts = rawCommand.split(" ", 2);
        String baseCommand = parts[0].toLowerCase();
        int colonIndex = baseCommand.indexOf(58);
        if (colonIndex != -1) {
            baseCommand = baseCommand.substring(colonIndex + 1);
        }
        return ALLOWED_COMMANDS.contains(baseCommand);
    }

    @Unique
    private void executeValidatedCommand(class_1657 player, String command) {
        class_3218 world = Objects.requireNonNull(player.method_5682()).method_30002();
        class_2168 commandSource = new class_2168(class_2165.field_17395, player.method_19538(), player.method_5802(), world, 4, player.method_5477().getString(), player.method_5476(), world.method_8503(), (class_1297)player);
        player.method_5682().execute(() -> {
            try {
                CommandDispatcher dispatcher = commandSource.method_9211().method_3734().method_9235();
                ParseResults results = dispatcher.parse(command, (Object)commandSource);
                if (results.getExceptions().isEmpty()) {
                    dispatcher.execute(results);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u6307\u4ee4\u8bed\u6cd5\u9519\u8bef"), false);
                }
            }
            catch (CommandSyntaxException e) {
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c\u6267\u884c\u5931\u8d25: " + e.getMessage())), false);
            }
        });
    }
}

