/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyisnoob.railgunsounds.client.sounds;

import io.github.hyisnoob.railgunsounds.registry.OrbitalRailgunSoundsRegistry;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_746;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class OrbitalRailgunSoundsSounds {
    private static final class_2960 ORBITAL_RAILGUN_ITEM_ID = new class_2960("orbital_railgun", "orbital_railgun");
    private static final float DEFAULT_VOLUME = 1.0f;
    private static final float DEFAULT_PITCH = 1.0f;
    private boolean wasUsing = false;
    private int lastSelectedSlot = -1;
    private boolean lastCooldownActive = false;
    private class_1792 railgunItem;
    private class_1109 scopeSoundInstance;

    public void initializeClient() {
        this.railgunItem = (class_1792)class_7923.field_41178.method_10223(ORBITAL_RAILGUN_ITEM_ID);
        ClientTickEvents.END_CLIENT_TICK.register(this::onEndTick);
    }

    private void onEndTick(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null || client.field_1687 == null) {
            return;
        }
        boolean focused = client.method_1569();
        float volume = focused ? 1.0f : 0.0f;
        this.handleRailgunUsage(client, player, volume);
        this.handleRailgunCooldown(player, volume);
        this.handleHotbarSwitch(player, volume);
    }

    private void handleRailgunUsage(class_310 client, class_746 player, float volume) {
        boolean isUsingRailgun;
        class_1792 currentItem = player.method_6030().method_7909();
        boolean bl = isUsingRailgun = !player.method_6030().method_7960() && currentItem == this.railgunItem;
        if (isUsingRailgun) {
            if (!this.wasUsing) {
                this.scopeSoundInstance = class_1109.method_4757((class_3414)OrbitalRailgunSoundsRegistry.SCOPE_ON, (float)volume, (float)1.0f);
                client.method_1483().method_4873((class_1113)this.scopeSoundInstance);
            }
        } else if (this.wasUsing && this.scopeSoundInstance != null) {
            client.method_1483().method_4870((class_1113)this.scopeSoundInstance);
            this.scopeSoundInstance = null;
        }
        this.wasUsing = isUsingRailgun;
    }

    private void handleRailgunCooldown(class_746 player, float volume) {
        if (this.railgunItem != null) {
            boolean cooldownNow = player.method_7357().method_7904(this.railgunItem);
            if (!this.lastCooldownActive && cooldownNow) {
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.method_10812(class_7923.field_41172.method_10221((Object)OrbitalRailgunSoundsRegistry.RAILGUN_SHOOT));
                buf.method_10807(player.method_24515());
                buf.writeFloat(volume);
                buf.writeFloat(1.0f);
                ClientPlayNetworking.send((class_2960)OrbitalRailgunSoundsRegistry.PLAY_SOUND_PACKET_ID, (class_2540)buf);
            }
            this.lastCooldownActive = cooldownNow;
        }
    }

    private void handleHotbarSwitch(class_746 player, float volume) {
        int selected = player.method_31548().field_7545;
        if (this.lastSelectedSlot != selected) {
            class_1792 heldItem = player.method_6047().method_7909();
            if (heldItem == this.railgunItem) {
                player.method_5783(OrbitalRailgunSoundsRegistry.EQUIP, volume, 1.0f);
            }
            this.lastSelectedSlot = selected;
        }
    }
}

