/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyisnoob.railgunsounds;

import io.github.hyisnoob.railgunsounds.config.ServerConfig;
import io.github.hyisnoob.railgunsounds.listener.PlayerAreaListener;
import io.github.hyisnoob.railgunsounds.logger.SoundLogger;
import io.github.hyisnoob.railgunsounds.registry.CommandRegistry;
import io.github.hyisnoob.railgunsounds.registry.SoundsRegistry;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitalRailgunSounds
implements ModInitializer {
    public static final String MOD_ID = "orbital_railgun_sounds";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"orbital_railgun_sounds");
    public static final class_2960 PLAY_SOUND_PACKET_ID = new class_2960("orbital_railgun_sounds", "play_sound");
    public static final class_2960 SHOOT_PACKET_ID = new class_2960("orbital_railgun", "shoot_packet");
    public static final class_2960 STOP_AREA_SOUND_PACKET_ID = new class_2960("orbital_railgun_sounds", "stop_area_sound");
    public static final long RAILGUN_SOUND_DURATION_MS = 52992L;

    public void onInitialize() {
        ServerConfig.INSTANCE.loadConfig();
        SoundsRegistry.initialize();
        CommandRegistry.registerCommands();
        LOGGER.info("=================================================");
        LOGGER.info("Orbital Railgun Sounds Addon initialized");
        LOGGER.info("Debug mode: {}", (Object)ServerConfig.INSTANCE.isDebugMode());
        LOGGER.info("Sound range: {}", (Object)ServerConfig.INSTANCE.getSoundRange());
        LOGGER.info("=================================================");
        PlayerAreaListener.setAreaChangeCallback(event -> OrbitalRailgunSounds.handleAreaStateChange(event.player(), event.result(), event.laserX(), event.laserZ()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            PlayerAreaListener.clearPlayerState(handler.method_32311().method_5667());
            if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("Cleared area state for disconnected player: {}", (Object)handler.method_32311().method_5477().getString());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PLAY_SOUND_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            class_2960 soundId = buf.method_10810();
            class_3414 sound = (class_3414)class_7923.field_41172.method_10223(soundId);
            class_2338 blockPos = buf.method_10811();
            float volumeShoot = buf.readFloat();
            float pitchShoot = buf.readFloat();
            long fireTimestamp = System.currentTimeMillis();
            server.execute(() -> {
                if (sound == null) {
                    LOGGER.warn("Received unknown sound id: {}", (Object)soundId.toString());
                    return;
                }
                double range = ServerConfig.INSTANCE.getSoundRange();
                double rangeSquared = range * range;
                double laserX = (double)blockPos.method_10263() + 0.5;
                double laserZ = (double)blockPos.method_10260() + 0.5;
                if (ServerConfig.INSTANCE.isDebugMode()) {
                    LOGGER.info("Playing sound {} at BlockPos: {} with range: {} at time {}", new Object[]{soundId, blockPos, range, fireTimestamp});
                }
                server.method_3760().method_14571().forEach(nearbyPlayer -> {
                    double distanceSquared = nearbyPlayer.method_5649((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5);
                    PlayerAreaListener.AreaCheckResult result = PlayerAreaListener.handlePlayerAreaCheck(nearbyPlayer, laserX, laserZ, fireTimestamp);
                    if (distanceSquared <= rangeSquared) {
                        if (result.isInside) {
                            nearbyPlayer.method_17356(sound, class_3419.field_15248, volumeShoot, pitchShoot);
                            SoundLogger.logSoundEvent(soundId.toString(), blockPos, range);
                            if (ServerConfig.INSTANCE.isDebugMode()) {
                                LOGGER.info("Playing sound to player {} (distance: {})", (Object)nearbyPlayer.method_5477().getString(), (Object)Math.sqrt(distanceSquared));
                            }
                        }
                        OrbitalRailgunSounds.handleAreaStateChange(nearbyPlayer, result, laserX, laserZ);
                    } else if (result.hasLeft()) {
                        OrbitalRailgunSounds.handleAreaStateChange(nearbyPlayer, result, laserX, laserZ);
                    }
                });
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SHOOT_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            class_2338 blockPos = buf.method_10811();
            if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("========================================");
                LOGGER.info("SHOOT_PACKET received from player: {}", (Object)player.method_5477().getString());
                LOGGER.info("Impact location: {}", (Object)blockPos);
            }
            server.execute(() -> {
                double laserX = (double)blockPos.method_10263() + 0.5;
                double laserZ = (double)blockPos.method_10260() + 0.5;
                int totalPlayers = server.method_3760().method_14571().size();
                if (ServerConfig.INSTANCE.isDebugMode()) {
                    LOGGER.info("Checking {} players on server for range", (Object)totalPlayers);
                }
                server.method_3760().method_14571().forEach(serverPlayer -> {
                    PlayerAreaListener.AreaCheckResult result = PlayerAreaListener.handlePlayerAreaCheck(serverPlayer, laserX, laserZ);
                    OrbitalRailgunSounds.handleAreaStateChange(serverPlayer, result, laserX, laserZ);
                });
                if (ServerConfig.INSTANCE.isDebugMode()) {
                    LOGGER.info("========================================");
                }
            });
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % 20 == 0) {
                server.method_3760().method_14571().forEach(PlayerAreaListener::checkPlayerPosition);
            }
        });
    }

    private static void handleAreaStateChange(class_3222 player, PlayerAreaListener.AreaCheckResult result, double laserX, double laserZ) {
        if (result.hasEntered()) {
            long currentTime = System.currentTimeMillis();
            long elapsedMs = currentTime - result.fireTimestamp;
            if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("Player {} entered sound range at ({}, {}) - elapsed: {}ms, duration: {}ms", new Object[]{player.method_5477().getString(), laserX, laserZ, elapsedMs, 52992L});
            }
            if (elapsedMs < 52992L) {
                OrbitalRailgunSounds.playRailgunSoundToPlayer(player, laserX, laserZ, elapsedMs);
            } else if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("Sound already ended ({}ms > {}ms) - not playing for player {}", new Object[]{elapsedMs, 52992L, player.method_5477().getString()});
            }
        } else if (result.hasLeft()) {
            if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("Player {} left sound range at ({}, {}) - stopping sounds", new Object[]{player.method_5477().getString(), laserX, laserZ});
            }
            OrbitalRailgunSounds.stopAreaSoundsForPlayer(player);
        } else if (result.isInside && ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.debug("Player {} remains in sound range at ({}, {})", new Object[]{player.method_5477().getString(), laserX, laserZ});
        }
    }

    private static void playRailgunSoundToPlayer(class_3222 player, double laserX, double laserZ, long elapsedMs) {
        class_3414 shootSound = SoundsRegistry.RAILGUN_SHOOT;
        if (shootSound != null) {
            player.method_17356(shootSound, class_3419.field_15248, 1.0f, 1.0f);
            if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("Playing railgun shoot sound to player {} at ({}, {}) with {}ms offset", new Object[]{player.method_5477().getString(), laserX, laserZ, elapsedMs});
            }
        } else {
            LOGGER.warn("Railgun shoot sound not found in registry");
        }
    }

    private static void stopAreaSoundsForPlayer(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(SoundsRegistry.RAILGUN_SHOOT_ID);
        ServerPlayNetworking.send((class_3222)player, (class_2960)STOP_AREA_SOUND_PACKET_ID, (class_2540)buf);
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.info("Sent stop sound packet to player {}", (Object)player.method_5477().getString());
        }
    }
}

