/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity;

import com.starshootercity.APITarget;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsAddon;
import com.starshootercity.Translator;
import com.starshootercity.abilities.types.Ability;
import com.starshootercity.abilities.types.MultiAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.AbilityRegister;
import com.starshootercity.util.config.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@APITarget
public class Origin {
    private final ItemStack icon;
    private final int position;
    private final char impact;
    private final String name;
    @NotNull
    private final String displayName;
    private final int priority;
    private final String unchoosable;
    private final OriginsAddon addon;
    private final List<Key> abilityKeys;
    private List<Ability> abilities = null;
    private final String description;
    private final String permission;
    private final Integer cost;
    private final int max;
    private final String layer;
    private final Team team;

    public Integer getCost() {
        return this.cost;
    }

    public boolean isUnchoosable(Player player) {
        return this.isUnchoosable(player, false);
    }

    public boolean isUnchoosable(Player player, boolean random) {
        if (this.unchoosable.equals("true")) {
            return true;
        }
        if (!random && this.unchoosable.equals("random")) {
            return true;
        }
        String mode = ConfigManager.getConfigValue(ConfigManager.Option.REUSING_ORIGINS);
        boolean same = ConfigManager.getConfigValue(ConfigManager.Option.PREVENT_SAME_ORIGINS);
        if (this.max != -1) {
            int num = 0;
            for (String p : OriginSwapper.getOriginFileConfiguration().getKeys(false)) {
                if (!OriginSwapper.getOriginFileConfiguration().getString(p + "." + this.layer, "").equals(this.getName().toLowerCase())) continue;
                ++num;
            }
            if (num >= this.max) {
                return true;
            }
        }
        if (same) {
            for (String p : OriginSwapper.getOriginFileConfiguration().getKeys(false)) {
                if (!OriginSwapper.getOriginFileConfiguration().getString(p + "." + this.layer, "").equals(this.getName().toLowerCase())) continue;
                return true;
            }
        }
        if (mode.equals("PERPLAYER")) {
            return OriginSwapper.getUsedOriginFileConfiguration().getStringList(player.getUniqueId().toString()).contains(this.getName().toLowerCase());
        }
        if (mode.equals("ALL")) {
            for (String p : OriginSwapper.getUsedOriginFileConfiguration().getKeys(false)) {
                if (!OriginSwapper.getUsedOriginFileConfiguration().getStringList(p).contains(this.getName().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public int getPriority() {
        return this.priority;
    }

    public Team getTeam() {
        return this.team;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean hasPermission() {
        return this.permission != null;
    }

    public String getLayer() {
        return this.layer;
    }

    public String getNameForDisplay() {
        return this.displayName;
    }

    public Origin(String name, ItemStack icon, int position, @Range(from=0L, to=3L) int impact, @NotNull String displayName, List<Key> abilities, String description, OriginsAddon addon, String unchoosable, int priority, String permission, Integer cost, int max, String layer) {
        this.displayName = displayName;
        this.description = description;
        this.name = name;
        this.permission = permission;
        this.cost = cost;
        this.max = max;
        this.layer = layer;
        if (ConfigManager.getConfigValue(ConfigManager.Option.DISPLAY_ENABLE_PREFIXES).booleanValue()) {
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            Team oldTeam = scoreboard.getTeam(name);
            if (oldTeam != null) {
                oldTeam.unregister();
            }
            this.team = scoreboard.registerNewTeam(name);
            this.team.displayName((Component)Component.text(Translator.translate("team_format").formatted(name)));
        } else {
            this.team = null;
        }
        this.abilityKeys = abilities;
        this.icon = icon;
        this.position = position;
        this.unchoosable = unchoosable;
        this.impact = (char)(switch (impact) {
            case 0 -> 57346;
            case 1 -> 57347;
            case 2 -> 57348;
            default -> 57349;
        });
        this.addon = addon;
        this.priority = priority;
    }

    public List<VisibleAbility> getVisibleAbilities() {
        ArrayList<VisibleAbility> result = new ArrayList<VisibleAbility>();
        for (Ability ability : this.getAbilities()) {
            if (!(ability instanceof VisibleAbility)) continue;
            VisibleAbility visibleAbility = (VisibleAbility)ability;
            result.add(visibleAbility);
        }
        return result;
    }

    public OriginsAddon getAddon() {
        return this.addon;
    }

    public List<Ability> getAbilities() {
        if (this.abilities == null) {
            this.abilities = this.abilityKeys.stream().map(AbilityRegister.abilityMap::get).flatMap(ability -> {
                if (ability instanceof MultiAbility) {
                    MultiAbility multiAbility = (MultiAbility)ability;
                    return Stream.concat(Stream.of(ability), multiAbility.getAbilities().stream());
                }
                return Stream.of(ability);
            }).toList();
        }
        return this.abilities;
    }

    public boolean hasAbility(Ability ability) {
        return this.getAbilities().contains(ability);
    }

    public char getImpact() {
        return this.impact;
    }

    public int getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public String getResourceURL() {
        String key = this.icon.getType().getKey().value();
        return "https://assets.mcasset.cloud/1.21.4/assets/minecraft/textures/%s/%s.png".formatted(this.icon.getType().isBlock() ? "block" : "item", key);
    }

    static {
        Translator.registerTranslation("team_format", "\u00a77[\u00a7r%s\u00a77] ");
    }
}

