/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity;

import com.starshootercity.AddonLoader;
import com.starshootercity.OrbOfOrigin;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsAddon;
import com.starshootercity.PackApplier;
import com.starshootercity.Translator;
import com.starshootercity.abilities.AerialCombatant;
import com.starshootercity.abilities.AirFromPotions;
import com.starshootercity.abilities.AquaAffinity;
import com.starshootercity.abilities.Aquatic;
import com.starshootercity.abilities.Arthropod;
import com.starshootercity.abilities.BurnInDaylight;
import com.starshootercity.abilities.BurningWrath;
import com.starshootercity.abilities.Carnivore;
import com.starshootercity.abilities.CatVision;
import com.starshootercity.abilities.Claustrophobia;
import com.starshootercity.abilities.Climbing;
import com.starshootercity.abilities.ConduitPowerOnLand;
import com.starshootercity.abilities.DamageFromPotions;
import com.starshootercity.abilities.DamageFromSnowballs;
import com.starshootercity.abilities.Elytra;
import com.starshootercity.abilities.EnderParticles;
import com.starshootercity.abilities.ExtraReach;
import com.starshootercity.abilities.FallImmunity;
import com.starshootercity.abilities.FireImmunity;
import com.starshootercity.abilities.FlameParticles;
import com.starshootercity.abilities.Fragile;
import com.starshootercity.abilities.FreshAir;
import com.starshootercity.abilities.Grayscale;
import com.starshootercity.abilities.Hotblooded;
import com.starshootercity.abilities.HungerOverTime;
import com.starshootercity.abilities.Invisibility;
import com.starshootercity.abilities.LaunchIntoAir;
import com.starshootercity.abilities.LayEggs;
import com.starshootercity.abilities.LightArmor;
import com.starshootercity.abilities.LikeWater;
import com.starshootercity.abilities.MasterOfWebs;
import com.starshootercity.abilities.MoreExhaustion;
import com.starshootercity.abilities.MoreKineticDamage;
import com.starshootercity.abilities.NaturalArmor;
import com.starshootercity.abilities.NetherSpawn;
import com.starshootercity.abilities.NineLives;
import com.starshootercity.abilities.NoShield;
import com.starshootercity.abilities.Phantomize;
import com.starshootercity.abilities.PhantomizeOverlay;
import com.starshootercity.abilities.Phasing;
import com.starshootercity.abilities.PumpkinHate;
import com.starshootercity.abilities.ScareCreepers;
import com.starshootercity.abilities.ShulkerInventory;
import com.starshootercity.abilities.SlowFalling;
import com.starshootercity.abilities.SprintJump;
import com.starshootercity.abilities.StrongArms;
import com.starshootercity.abilities.SwimSpeed;
import com.starshootercity.abilities.Tailwind;
import com.starshootercity.abilities.ThrowEnderPearl;
import com.starshootercity.abilities.Vegetarian;
import com.starshootercity.abilities.VelvetPaws;
import com.starshootercity.abilities.WaterBreathing;
import com.starshootercity.abilities.WaterVision;
import com.starshootercity.abilities.WaterVulnerability;
import com.starshootercity.abilities.WeakArms;
import com.starshootercity.abilities.types.Ability;
import com.starshootercity.abilities.types.BreakSpeedModifierAbility;
import com.starshootercity.abilities.types.ParticleAbility;
import com.starshootercity.commands.DiscordCommand;
import com.starshootercity.commands.FlightToggleCommand;
import com.starshootercity.commands.OriginCommand;
import com.starshootercity.cooldowns.Cooldowns;
import com.starshootercity.events.PlayerLeftClickEvent;
import com.starshootercity.geysermc.OREventRegistrar;
import com.starshootercity.packetsenders.NMSInvoker;
import com.starshootercity.skript.SkriptInitializer;
import com.starshootercity.util.AbilityRegister;
import com.starshootercity.util.Metrics;
import com.starshootercity.util.SkinManager;
import com.starshootercity.util.TriggerManager;
import com.starshootercity.util.VaultHook;
import com.starshootercity.util.WorldGuardHook;
import com.starshootercity.util.config.ConfigManager;
import com.starshootercity.util.hooks.GSitHook;
import com.starshootercity.version.MVAccessor;
import com.starshootercity.version.MVAttribute;
import com.starshootercity.version.MultiVersionExecutor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OriginsReborn
extends OriginsAddon {
    private static OriginsReborn instance;
    public static FreshAir freshAir;
    private static Cooldowns cooldowns;
    private boolean vaultEnabled;
    private static boolean worldGuardHookInitialized;
    public static boolean usesSkriptAbilities;

    public static OriginsReborn getInstance() {
        return instance;
    }

    public static Cooldowns getCooldowns() {
        return cooldowns;
    }

    public static MultiVersionExecutor getMVE() {
        return MVAccessor.get();
    }

    @Deprecated(forRemoval=true)
    public static NMSInvoker getNMSInvoker() {
        return OriginsReborn.getMVE();
    }

    private static void initializeMVE(OriginsReborn instance) {
        MVAccessor.startInitialize(Bukkit.getBukkitVersion().split("-")[0]);
        Bukkit.getPluginManager().registerEvents((Listener)MVAccessor.get(), (Plugin)instance);
        OriginsReborn.getMVE().initialize();
    }

    public boolean isVaultEnabled() {
        return this.vaultEnabled;
    }

    public void setComments(String path, List<String> comments) {
        OriginsReborn.getMVE().setComments(this.getConfig(), path, comments);
    }

    public static boolean isWorldGuardHookInitialized() {
        return worldGuardHookInitialized;
    }

    public void onLoad() {
        try {
            worldGuardHookInitialized = WorldGuardHook.tryInitialize();
        }
        catch (Throwable t) {
            worldGuardHookInitialized = false;
        }
    }

    public void onDisable() {
        if (!AbilityRegister.isSkinManagerEnabled()) {
            return;
        }
        SkinManager.unload();
    }

    @Override
    public void onRegister() {
        PluginCommand command;
        File imports;
        File export;
        instance = this;
        if (Bukkit.getPluginManager().isPluginEnabled("Geyser-Spigot")) {
            OREventRegistrar.initialize(this);
        }
        if (Bukkit.getPluginManager().isPluginEnabled("GSit")) {
            GSitHook.Setup(this);
        }
        AbilityRegister.setupAbilityConfig(this);
        int pluginId = 25114;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("addon_count", () -> String.valueOf(Math.max(0, AddonLoader.registeredAddons.size() - 1))));
        metrics.addCustomChart(new Metrics.AdvancedPie("addons", () -> {
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            for (OriginsAddon addon : AddonLoader.registeredAddons) {
                if (addon == this) continue;
                data.put(addon.getName(), 1);
            }
            return data;
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("origins", () -> {
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            for (String layer : AddonLoader.layers) {
                for (Origin origin : AddonLoader.getOrigins(layer)) {
                    String info = "%s - %s".formatted(origin.getNameForDisplay(), layer);
                    data.put(info, 1);
                }
            }
            return data;
        }));
        freshAir = new FreshAir();
        OriginsReborn.initializeMVE(this);
        this.saveDefaultConfig();
        ConfigManager.Option.initialize();
        if (ConfigManager.getConfigValue(ConfigManager.Option.SKINSRESTORER_HOOK_ENABLED).booleanValue()) {
            if (Bukkit.getPluginManager().isPluginEnabled("SkinsRestorer")) {
                AbilityRegister.setSkinManagerEnabled();
                Bukkit.getPluginManager().registerEvents((Listener)new SkinManager(), (Plugin)this);
            } else {
                this.getLogger().warning("The SkinsRestorer hook is enabled in the config, however SkinsRestorer is not installed.");
            }
        }
        metrics.addCustomChart(new Metrics.SimplePie("skinsrestorer_hook_enabled", () -> String.valueOf(AbilityRegister.isSkinManagerEnabled())));
        if (worldGuardHookInitialized) {
            WorldGuardHook.completeInitialize();
        }
        Translator.initialize(this);
        if (ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_VAULT_ENABLED).booleanValue()) {
            this.vaultEnabled = VaultHook.setupEconomy(this.getServer());
            if (!this.vaultEnabled) {
                this.getLogger().warning("Vault is missing, origin swaps will not cost currency");
            }
        } else {
            this.vaultEnabled = false;
        }
        metrics.addCustomChart(new Metrics.SimplePie("vault_hook_enabled", () -> String.valueOf(this.vaultEnabled)));
        metrics.addCustomChart(new Metrics.SimplePie("uses_skript_abilities", () -> String.valueOf(usesSkriptAbilities)));
        metrics.addCustomChart(new Metrics.SimplePie("worldguard_hook_enabled", () -> String.valueOf(worldGuardHookInitialized)));
        cooldowns = new Cooldowns();
        if (!ConfigManager.getConfigValue(ConfigManager.Option.DISABLE_ALL_COOLDOWNS).booleanValue() && ConfigManager.getConfigValue(ConfigManager.Option.SHOW_COOLDOWN_ICONS).booleanValue()) {
            Bukkit.getPluginManager().registerEvents((Listener)cooldowns, (Plugin)this);
        }
        SkriptInitializer.initialize(this);
        Bukkit.getPluginManager().registerEvents((Listener)TriggerManager.getInstance(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OriginSwapper(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OrbOfOrigin(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PackApplier(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerLeftClickEvent.PlayerLeftClickEventListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ParticleAbility.ParticleAbilityListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BreakSpeedModifierAbility.BreakSpeedModifierAbilityListener(), (Plugin)this);
        PluginCommand flightCommand = this.retrieveCommand("fly");
        if (flightCommand != null) {
            flightCommand.setExecutor((CommandExecutor)new FlightToggleCommand());
        }
        if (!(export = new File(this.getDataFolder(), "export")).exists()) {
            boolean bl = export.mkdir();
        }
        if (!(imports = new File(this.getDataFolder(), "import")).exists()) {
            boolean bl = imports.mkdir();
        }
        if ((command = this.retrieveCommand("origin")) != null) {
            command.setExecutor((CommandExecutor)new OriginCommand());
        }
        OriginCommand.initialize();
        PluginCommand discord = this.retrieveCommand("origindiscord");
        if (discord != null) {
            discord.setExecutor((CommandExecutor)new DiscordCommand());
        }
        AbilityRegister.initialize(this);
    }

    @Nullable
    public PluginCommand retrieveCommand(String command) {
        try {
            return this.getCommand(command);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getNamespace() {
        return "origins";
    }

    @Override
    @NotNull
    public List<Ability> getRegisteredAbilities() {
        ArrayList<Ability> abilities = new ArrayList<Ability>(List.of(new PumpkinHate(), new FallImmunity(), new WeakArms(), new Fragile(), new SlowFalling(), freshAir, new Vegetarian(), new LayEggs(), new NoShield(), new MasterOfWebs(), new Tailwind(), new Arthropod(), new Climbing(), new Carnivore(), new WaterBreathing(), new WaterVision(), new CatVision(), new NineLives(), new BurnInDaylight(), new WaterVulnerability(), new Phantomize(), new Invisibility(), new ThrowEnderPearl(), new PhantomizeOverlay(), new FireImmunity(), new AirFromPotions(), new SwimSpeed(), new LikeWater(), new LightArmor(), new MoreKineticDamage(), new DamageFromPotions(), new DamageFromSnowballs(), new Hotblooded(), new BurningWrath(), new SprintJump(), new AerialCombatant(), new Elytra(), new LaunchIntoAir(), new HungerOverTime(), new MoreExhaustion(), new Aquatic(), new NetherSpawn(), new Claustrophobia(), new VelvetPaws(), new AquaAffinity(), new FlameParticles(), new EnderParticles(), new Phasing(), new ScareCreepers(), new StrongArms(), StrongArms.StrongArmsBreakSpeed.strongArmsBreakSpeed, StrongArms.StrongArmsDrops.strongArmsDrops, new ShulkerInventory(), new NaturalArmor(), new ConduitPowerOnLand(), new Grayscale()));
        Attribute blockInteractionRange = MVAttribute.BLOCK_INTERACTION_RANGE.get();
        Attribute entityInteractionRange = MVAttribute.ENTITY_INTERACTION_RANGE.get();
        if (blockInteractionRange != null && entityInteractionRange != null) {
            abilities.add(new ExtraReach(blockInteractionRange, entityInteractionRange));
            abilities.add(ExtraReach.ExtraReachBlocks.extraReachBlocks);
            abilities.add(ExtraReach.ExtraReachEntities.extraReachEntities);
        }
        return abilities;
    }

    static {
        usesSkriptAbilities = false;
    }
}

