/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity;

import com.starshootercity.APITarget;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

@APITarget
public class Translator {
    private static File file;
    private static FileConfiguration fileConfig;
    private static final Map<String, String> cache;

    public static int getWidth(char character) {
        if (character == '\uf00a') {
            return 2;
        }
        if (character == ' ') {
            return 4;
        }
        for (int i = 2; i < 17; ++i) {
            if (!fileConfig.getString("character-widths.%s".formatted(i), "").contains(Translator.toUnicode(character))) continue;
            return i;
        }
        return 0;
    }

    private static String toUnicode(char ch) {
        return String.format("\\u%04x", ch);
    }

    public static void registerTranslation(String key, String def) {
        if (!fileConfig.contains((String)(key = "translations." + (String)key))) {
            fileConfig.set((String)key, (Object)def);
            try {
                fileConfig.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String translate(String key) {
        return cache.computeIfAbsent(key, s -> fileConfig.getString("translations." + key));
    }

    public static void reloadTranslations() {
        cache.clear();
        try {
            fileConfig.load(file);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void initialize(JavaPlugin plugin) {
        file = new File(plugin.getDataFolder(), "translations.yml");
        if (!file.exists()) {
            boolean ignored = file.getParentFile().mkdirs();
            plugin.saveResource("translations.yml", false);
        }
        fileConfig = new YamlConfiguration();
        Translator.reloadTranslations();
    }

    static {
        cache = new HashMap<String, String>();
    }
}

