/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class AerialCombatant
implements VisibleAbility,
Listener {
    private float damageMultiplier;

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        this.runForAbility(event.getDamager(), player -> {
            if (player.isGliding()) {
                event.setDamage(event.getDamage() * (double)this.damageMultiplier);
            }
        });
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:aerial_combatant");
    }

    @Override
    public String description() {
        return "You deal substantially more damage while in Elytra flight.";
    }

    @Override
    public String title() {
        return "Aerial Combatant";
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.damageMultiplier = this.registerConfigOption(plugin, "damage_multiplier", Collections.singletonList("Amount to multiply the damage by when gliding"), ConfigManager.SettingType.FLOAT, Float.valueOf(2.0f)).floatValue();
    }
}

