/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.MaterialTags;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.abilities.types.DependantAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.config.ConfigManager;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BurnInDaylight
implements DependantAbility,
Listener,
VisibleAbility {
    private boolean burnWithHelmet;

    @Override
    public DependantAbility.DependencyType getDependencyType() {
        return DependantAbility.DependencyType.INVERSE;
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        if (event.getTickNumber() % 20 != 0) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                ItemStack helm;
                Block block = player.getWorld().getHighestBlockAt(player.getLocation());
                while (MaterialTags.GLASS.isTagged(block) || MaterialTags.GLASS_PANES.isTagged(block) && (double)block.getY() >= player.getLocation().getY()) {
                    block = block.getRelative(BlockFace.DOWN);
                }
                boolean height = (double)block.getY() < player.getLocation().getY();
                boolean isInOverworld = player.getWorld().getEnvironment() == World.Environment.NORMAL;
                boolean day = player.getWorld().isDayTime();
                if (!this.burnWithHelmet && (helm = player.getInventory().getHelmet()) != null && !helm.getType().isAir()) {
                    return;
                }
                if (height && isInOverworld && day && !player.isInWaterOrRainOrBubbleColumn()) {
                    player.setFireTicks(Math.max(player.getFireTicks(), 60));
                }
            });
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:burn_in_daylight");
    }

    @Override
    public String description() {
        return "You begin to burn in daylight if you are not invisible.";
    }

    @Override
    public String title() {
        return "Photoallergic";
    }

    @Override
    @NotNull
    public Key getDependencyKey() {
        return Key.key("origins:phantomize");
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.burnWithHelmet = this.registerConfigOption(plugin, "burn_with_helmet", List.of("Whether the player should burn even when wearing a helmet"), ConfigManager.SettingType.BOOLEAN, Boolean.valueOf(true));
    }
}

