/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.abilities.types.FlightAllowingAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.commands.FlightToggleCommand;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Elytra
implements FlightAllowingAbility,
Listener,
VisibleAbility {
    private boolean disableDisengage;

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:elytra");
    }

    @Override
    public String description() {
        return "You have Elytra wings without needing to equip any.";
    }

    @Override
    public String title() {
        return "Winged";
    }

    @EventHandler
    public void onEntityToggleGlide(EntityToggleGlideEvent event) {
        this.runForAbility(event.getEntity(), player -> {
            if (!player.isOnGround() && !event.isGliding()) {
                event.setCancelled(true);
            }
        });
    }

    @Override
    public boolean canFly(Player player) {
        return true;
    }

    @Override
    public float getFlightSpeed(Player player) {
        return player.getFlySpeed();
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        if (FlightToggleCommand.canFly(event.getPlayer())) {
            return;
        }
        this.runForAbility((Entity)event.getPlayer(), player -> {
            if (event.isFlying()) {
                event.setCancelled(true);
                if (player.isGliding() && this.disableDisengage) {
                    return;
                }
                player.setGliding(!player.isGliding());
            }
        });
    }

    @Override
    @NotNull
    public TriState getFlyingFallDamage(Player player) {
        return TriState.TRUE;
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.disableDisengage = this.registerConfigOption(plugin, "disable_disengage_trigger", Collections.singletonList("Disable the ability to disengage the elytra by double tapping again"), ConfigManager.SettingType.BOOLEAN, Boolean.valueOf(true));
    }
}

