/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class FreshAir
implements Listener,
VisibleAbility {
    public static int minHeight;

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        if (!event.getAction().isRightClick()) {
            return;
        }
        if (event.getPlayer().isSneaking() && event.getPlayer().getInventory().getItemInOffHand().getType() != Material.AIR && event.getPlayer().getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        if (Tag.BEDS.isTagged((Keyed)event.getClickedBlock().getType())) {
            this.runForAbility((Entity)event.getPlayer(), player -> {
                if (event.getClickedBlock().getY() < minHeight) {
                    boolean isInOverworld;
                    String overworld = OriginsReborn.getInstance().getConfig().getString("worlds.world");
                    if (overworld == null) {
                        overworld = "world";
                        OriginsReborn.getInstance().getConfig().set("worlds.world", (Object)"world");
                        OriginsReborn.getInstance().saveConfig();
                    }
                    boolean bl = isInOverworld = player.getWorld() == Bukkit.getWorld((String)overworld);
                    if (!isInOverworld) {
                        return;
                    }
                    if (event.getClickedBlock().getWorld().isDayTime() && event.getClickedBlock().getWorld().isClearWeather()) {
                        return;
                    }
                    event.setCancelled(true);
                    player.swingMainHand();
                    player.sendActionBar((Component)Component.text(this.translate("avian_sleep_fail")));
                }
            });
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:fresh_air");
    }

    @Override
    public String description() {
        return "When sleeping, your bed needs to be at an altitude of at least %s blocks, so you can breathe fresh air.";
    }

    @Override
    public String modifyDescription(String description) {
        return description.formatted(minHeight);
    }

    @Override
    public String title() {
        return "Fresh Air";
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.registerTranslation("avian_sleep_fail", "You need fresh air to sleep");
        minHeight = (Integer)this.registerConfigOption(plugin, "minimum_altitude", Collections.singletonList("Minimum altitude the player can sleep at"), ConfigManager.SettingType.INTEGER, 86);
    }
}

