/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.abilities.types.DependantAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class HungerOverTime
implements DependantAbility,
Listener,
VisibleAbility {
    private float metabolismIncrease;

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:hunger_over_time");
    }

    @Override
    public String description() {
        return "Being phantomized causes you to become hungry.";
    }

    @Override
    public String title() {
        return "Fast Metabolism";
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        if (event.getTickNumber() % 20 != 0) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> player.setExhaustion(player.getExhaustion() + this.metabolismIncrease));
        }
    }

    @Override
    @NotNull
    public Key getDependencyKey() {
        return Key.key("origins:phantomize");
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.metabolismIncrease = this.registerConfigOption(plugin, "metabolism_increase", Collections.singletonList("The amount to add to the player's exhaustion each second"), ConfigManager.SettingType.FLOAT, Float.valueOf(0.812f)).floatValue();
    }
}

