/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.abilities.types.FlightAllowingAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import net.kyori.adventure.key.Key;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.jetbrains.annotations.NotNull;

public class LikeWater
implements FlightAllowingAbility,
Listener,
VisibleAbility {
    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:like_water");
    }

    @Override
    public boolean canFly(Player player) {
        return player.isInWater() && !player.isInBubbleColumn();
    }

    @Override
    public float getFlightSpeed(Player player) {
        return 0.06f;
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        this.runForAbility((Entity)event.getPlayer(), player -> {
            if (player.isInWater()) {
                player.setFlying(false);
            }
        });
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getPlayer().isSwimming()) {
            return;
        }
        if (event.getPlayer().isSprinting()) {
            return;
        }
        if (event.getPlayer().isFlying()) {
            return;
        }
        if (!event.getPlayer().isInWater()) {
            return;
        }
        this.runForAbility((Entity)event.getPlayer(), player -> {
            boolean fly = event.getTo().getY() > event.getFrom().getY() && !player.isInBubbleColumn();
            player.setAllowFlight(fly);
            player.setFlying(fly);
        });
    }

    @EventHandler
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        if (!event.getPlayer().isFlying()) {
            return;
        }
        this.runForAbility((Entity)event.getPlayer(), player -> {
            if (player.isInWater()) {
                player.setFlying(false);
            }
        });
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        this.runForAbility((Entity)event.getPlayer(), player -> {
            if (player.isInWater()) {
                event.setCancelled(true);
            }
        });
    }

    @Override
    public String description() {
        return "When underwater, you do not sink to the ground unless you want to.";
    }

    @Override
    public String title() {
        return "Like Water";
    }
}

