/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.CooldownAbility;
import com.starshootercity.abilities.types.FlightAllowingAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.cooldowns.Cooldowns;
import com.starshootercity.util.AbilityRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MasterOfWebs
implements CooldownAbility,
FlightAllowingAbility,
Listener,
VisibleAbility {
    private final Map<Player, List<Entity>> glowingEntities = new HashMap<Player, List<Entity>>();
    private final List<Location> temporaryCobwebs = new ArrayList<Location>();
    private final Map<Location, BlockState> replacedBlocks = new HashMap<Location, BlockState>();
    private final Map<UUID, Integer> lastKnockback = new HashMap<UUID, Integer>();
    private final Map<Player, Boolean> canFly = new HashMap<Player, Boolean>();

    @EventHandler
    public void onBlockDropItem(BlockDropItemEvent event) {
        if (this.temporaryCobwebs.contains(event.getBlock().getLocation())) {
            event.setCancelled(true);
            this.temporaryCobwebs.remove(event.getBlock().getLocation());
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        if (this.temporaryCobwebs.contains(event.getToBlock().getLocation())) {
            event.setCancelled(true);
            event.getToBlock().setType(Material.AIR);
            this.temporaryCobwebs.remove(event.getToBlock().getLocation());
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        this.runForAbility(event.getDamager(), player -> {
            if (this.hasCooldown(player)) {
                return;
            }
            if (!event.getEntity().getLocation().getBlock().isSolid()) {
                this.setCooldown(player);
                Location location = event.getEntity().getLocation().getBlock().getLocation();
                this.temporaryCobwebs.add(location);
                Block block = location.getBlock();
                BlockState originalState = block.getState();
                this.replacedBlocks.put(location, originalState);
                block.setType(Material.COBWEB);
                int tick = Bukkit.getCurrentTick();
                UUID uuid = event.getEntity().getUniqueId();
                this.lastKnockback.put(uuid, tick);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> {
                    if (location.getBlock().getType() == Material.COBWEB && this.temporaryCobwebs.contains(location)) {
                        this.temporaryCobwebs.remove(location);
                        if (this.replacedBlocks.containsKey(location)) {
                            BlockState state = this.replacedBlocks.remove(location);
                            state.update(true, false);
                        }
                        if (this.lastKnockback.getOrDefault(uuid, 0) == tick) {
                            this.lastKnockback.remove(uuid);
                        }
                    }
                }, 60L);
            }
        });
    }

    @EventHandler
    public void onEntityKnockbackByEntity(EntityKnockbackByEntityEvent event) {
        if (this.lastKnockback.getOrDefault(event.getEntity().getUniqueId(), 0) == Bukkit.getCurrentTick()) {
            event.setCancelled(true);
        }
    }

    private void setCanFly(Player player, boolean setFly) {
        this.canFly.put(player, setFly);
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)player, webMaster -> {
                this.setCanFly(webMaster, this.isInCobweb((Entity)webMaster));
                List<Entity> entities = webMaster.getNearbyEntities(16.0, 16.0, 16.0);
                entities.removeIf(entity -> !(entity instanceof LivingEntity));
                if (entities.size() > 16) {
                    entities = entities.subList(0, 16);
                }
                entities.addAll(Bukkit.getOnlinePlayers());
                entities.removeIf(entity -> entity.getWorld() != webMaster.getWorld());
                entities.removeIf(entity -> entity.getLocation().distance(webMaster.getLocation()) > 16.0);
                for (Entity entity2 : entities) {
                    this.runForAbility(entity2, null, () -> {
                        if (entity2 != webMaster) {
                            if (!this.glowingEntities.containsKey(webMaster)) {
                                this.glowingEntities.put(webMaster, new ArrayList());
                            }
                            if (this.isInCobweb(entity2)) {
                                if (!this.glowingEntities.get(webMaster).contains(entity2)) {
                                    this.glowingEntities.get(webMaster).add(entity2);
                                }
                                byte data = MasterOfWebs.getData(entity2);
                                OriginsReborn.getMVE().sendEntityData(webMaster, entity2, data);
                            } else {
                                this.glowingEntities.get(webMaster).remove(entity2);
                                AbilityRegister.updateEntity(webMaster, entity2);
                            }
                        }
                    });
                }
            });
        }
    }

    private static byte getData(Entity entity) {
        LivingEntity livingEntity;
        byte data = 0;
        data = (byte)(data | 0x40);
        if (entity.getFireTicks() > 0) {
            data = (byte)(data | 1);
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isInvisible()) {
            data = (byte)(data + 32);
        }
        if (entity instanceof Player) {
            Player stuckPlayer = (Player)entity;
            if (stuckPlayer.isSneaking()) {
                data = (byte)(data | 2);
            }
            if (stuckPlayer.isSprinting()) {
                data = (byte)(data | 8);
            }
            if (stuckPlayer.isSwimming()) {
                data = (byte)(data | 0x10);
            }
            if (stuckPlayer.isGliding()) {
                data = (byte)(data | 0xFFFFFF80);
            }
        }
        return data;
    }

    public MasterOfWebs() {
        NamespacedKey recipeKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "web-recipe");
        ShapelessRecipe webRecipe = new ShapelessRecipe(recipeKey, new ItemStack(Material.COBWEB));
        if (Bukkit.getRecipe((NamespacedKey)recipeKey) == null) {
            webRecipe.addIngredient(Material.STRING);
            webRecipe.addIngredient(Material.STRING);
            Bukkit.addRecipe((Recipe)webRecipe);
        }
    }

    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        if (event.getRecipe() != null && event.getRecipe().getResult().getType() == Material.COBWEB) {
            for (HumanEntity entity : event.getInventory().getViewers()) {
                this.runForAbility((Entity)entity, null, (Player player) -> event.getInventory().setResult(null));
            }
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:master_of_webs");
    }

    @Override
    public String description() {
        return "You navigate cobweb perfectly, and are able to climb in them. When you hit an enemy in melee, they get stuck in cobweb for a while. Non-arthropods stuck in cobweb will be sensed by you. You are able to craft cobweb from string.";
    }

    @Override
    public String title() {
        return "Master of Webs";
    }

    public boolean isInCobweb(Entity entity) {
        for (Block start : Set.of(entity.getLocation().getBlock().getRelative(BlockFace.UP), entity.getLocation().getBlock())) {
            if (start.getType() == Material.COBWEB) {
                return true;
            }
            for (BlockFace face : BlockFace.values()) {
                Block block = start.getRelative(face);
                if (block.getType() != Material.COBWEB || !entity.getBoundingBox().overlaps(block.getBoundingBox())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canFly(Player player) {
        return this.canFly.getOrDefault(player, false);
    }

    @Override
    public boolean forceFly(Player player) {
        return this.canFly.getOrDefault(player, false);
    }

    @Override
    public float getFlightSpeed(Player player) {
        return 0.04f;
    }

    @Override
    public Cooldowns.CooldownInfo getCooldownInfo() {
        return new Cooldowns.CooldownInfo(120, "web");
    }

    @Override
    public int getPriority() {
        return 2;
    }
}

