/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.abilities.types.DependencyAbility;
import com.starshootercity.abilities.types.TriggerableAbility;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Phantomize
implements DependencyAbility,
Listener,
TriggerableAbility {
    private int foodLevel;
    private boolean disableOnDamage;
    private final Map<UUID, Boolean> phantomizedPlayers = new HashMap<UUID, Boolean>();

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.isEnabled(player) || player.getFoodLevel() > this.foodLevel) continue;
            this.phantomizedPlayers.put(player.getUniqueId(), false);
            PhantomizeToggleEvent phantomizeToggleEvent = new PhantomizeToggleEvent(player, false);
            phantomizeToggleEvent.callEvent();
        }
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.foodLevel = this.registerConfigOption(plugin, "minimum_food_level", Collections.singletonList("The food level at which you can no longer enter Phantom Form"), ConfigManager.SettingType.INTEGER, Integer.valueOf(6));
        this.disableOnDamage = this.registerConfigOption(plugin, "disable_on_damage", Collections.singletonList("Whether to disable Phantom Form when taking damage"), ConfigManager.SettingType.BOOLEAN, Boolean.valueOf(false));
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (!this.disableOnDamage) {
            return;
        }
        if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.SUFFOCATION)) {
            return;
        }
        this.runForAbility(event.getEntity(), player -> {
            if (this.phantomizedPlayers.getOrDefault(player.getUniqueId(), false).booleanValue()) {
                this.setPhasing(player, false);
            }
        });
    }

    private void setPhasing(Player player, boolean enabling) {
        this.phantomizedPlayers.put(player.getUniqueId(), enabling);
        PhantomizeToggleEvent phantomizeToggleEvent = new PhantomizeToggleEvent(player, enabling);
        phantomizeToggleEvent.callEvent();
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:phantomize");
    }

    @Override
    public boolean isEnabled(Player player) {
        return this.phantomizedPlayers.getOrDefault(player.getUniqueId(), false);
    }

    @Override
    @NotNull
    public TriggerableAbility.Trigger getTrigger() {
        return TriggerableAbility.Trigger.builder(TriggerableAbility.TriggerType.LEFT_CLICK, this).addConditions(TriggerableAbility.Condition.EMPTY_HAND, TriggerableAbility.Condition.NO_BLOCK).build(event -> {
            Player player = event.player();
            if (player.getFoodLevel() <= 6) {
                return;
            }
            boolean enabling = this.phantomizedPlayers.getOrDefault(player.getUniqueId(), false) == false;
            this.setPhasing(player, enabling);
        });
    }

    public static class PhantomizeToggleEvent
    extends PlayerEvent {
        private final boolean enabling;
        private static final HandlerList HANDLERS = new HandlerList();

        public PhantomizeToggleEvent(Player who, boolean enabling) {
            super(who);
            this.enabling = enabling;
        }

        public boolean isEnabling() {
            return this.enabling;
        }

        @NotNull
        public HandlerList getHandlers() {
            return HANDLERS;
        }

        public static HandlerList getHandlerList() {
            return HANDLERS;
        }
    }
}

