/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.Phantomize;
import com.starshootercity.abilities.types.DependantAbility;
import net.kyori.adventure.key.Key;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;

public class PhantomizeOverlay
implements DependantAbility,
Listener {
    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:phantomize_overlay");
    }

    @Override
    @NotNull
    public Key getDependencyKey() {
        return Key.key("origins:phantomize");
    }

    @EventHandler
    public void onPhantomizeToggle(Phantomize.PhantomizeToggleEvent event) {
        this.updatePhantomizeOverlay(event.getPlayer());
    }

    @EventHandler
    public void onPlayerPostRespawn(PlayerPostRespawnEvent event) {
        this.updatePhantomizeOverlay(event.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.updatePhantomizeOverlay(event.getPlayer());
    }

    private void updatePhantomizeOverlay(Player player) {
        OriginsReborn.getMVE().setWorldBorderOverlay(player, this.getDependency().isEnabled(player));
    }
}

