/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.BreakSpeedModifierAbility;
import com.starshootercity.abilities.types.DependantAbility;
import com.starshootercity.abilities.types.FlightAllowingAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.ShortcutUtils;
import com.starshootercity.util.config.ConfigManager;
import com.starshootercity.version.MVEnchantment;
import com.starshootercity.version.MVPotionEffectType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Phasing
implements DependantAbility,
FlightAllowingAbility,
BreakSpeedModifierAbility,
Listener,
VisibleAbility {
    private boolean giveBlindness;
    private float phasingSpeed;
    private List<Material> impassable;
    private final Map<Player, Boolean> isPhasing = new HashMap<Player, Boolean>();

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:phasing");
    }

    @Override
    @NotNull
    public Key getDependencyKey() {
        return Key.key("origins:phantomize");
    }

    @Override
    public String description() {
        return "While phantomized, you can walk through solid material, except Obsidian.";
    }

    @Override
    public String title() {
        return "Phasing";
    }

    @EventHandler
    public void onServerTick(ServerTickEndEvent event) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, (Player player) -> {
                boolean begins = player.isSneaking() && player.isOnGround() && !this.impassable.contains(player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType());
                this.setPhasing(player, begins || this.isInBlock((Entity)player), begins);
                OriginsReborn.getMVE().setNoPhysics(player, player.getGameMode() == GameMode.SPECTATOR || this.isPhasing.computeIfAbsent(player, pl -> false) != false);
                if (this.isPhasing.computeIfAbsent(player, pl -> false).booleanValue()) {
                    player.setFallDistance(0.0f);
                    if (player.getAllowFlight()) {
                        player.setFlying(true);
                    }
                }
            }, (Player player) -> {
                if (this.isPhasing.computeIfAbsent(player, pl -> false).booleanValue()) {
                    this.setPhasing(player, false, false);
                }
            });
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.isPhasing.computeIfAbsent(event.getPlayer(), pl -> false).booleanValue() && this.isInBlock(event.getTo(), block -> this.impassable.contains(block.getType()))) {
            event.setCancelled(true);
        }
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.impassable = this.registerConfigOption(plugin, "impassable_blocks", Collections.singletonList("Blocks you cannot pass through when phasing"), ConfigManager.SettingType.MATERIAL_LIST, List.of(Material.OBSIDIAN, Material.CRYING_OBSIDIAN, Material.BEDROCK));
        this.giveBlindness = this.registerConfigOption(plugin, "give_blindness", Collections.singletonList("Apply Blindness when Phasing"), ConfigManager.SettingType.BOOLEAN, Boolean.valueOf(true));
        this.phasingSpeed = this.registerConfigOption(plugin, "phasing_speed", Collections.singletonList("Speed at which the player should move when phasing"), ConfigManager.SettingType.FLOAT, Float.valueOf(0.1f)).floatValue();
    }

    public boolean isInBlock(Entity entity) {
        return this.isInBlock(entity.getLocation(), block -> block.getType().isSolid() && !this.impassable.contains(block.getType()));
    }

    public boolean isInBlock(Location location, Predicate<Block> predicate) {
        boolean isInsideBlock = false;
        for (Location currentLocation : List.of(location.clone().add(0.0, 1.0, 0.0), location.clone())) {
            List<Double> values = List.of(Double.valueOf(0.4), Double.valueOf(-0.4));
            for (double x : values) {
                for (double z : values) {
                    if (!predicate.test(currentLocation.clone().add(x, 0.0, z).getBlock())) continue;
                    isInsideBlock = true;
                    break;
                }
                if (!isInsideBlock) continue;
                break;
            }
            if (!isInsideBlock) continue;
            break;
        }
        return isInsideBlock;
    }

    @Override
    public boolean canFly(Player player) {
        return this.getDependency().isEnabled(player) && this.isPhasing.computeIfAbsent(player, pl -> false) != false;
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        this.runForAbility(event.getEntity(), player -> {
            if (!this.isPhasing.getOrDefault(player, false).booleanValue()) {
                return;
            }
            if (event.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION) {
                event.setCancelled(true);
            }
        });
    }

    @Override
    public float getFlightSpeed(Player player) {
        return this.phasingSpeed;
    }

    @Override
    public BreakSpeedModifierAbility.BlockMiningContext getMiningContext(Player player) {
        ItemStack helmet = player.getInventory().getHelmet();
        boolean aquaAffinity = false;
        if (helmet != null) {
            aquaAffinity = helmet.containsEnchantment(MVEnchantment.AQUA_AFFINITY.get());
        }
        return new BreakSpeedModifierAbility.BlockMiningContext(player.getInventory().getItemInMainHand(), player.getPotionEffect(MVPotionEffectType.HASTE.get()), player.getPotionEffect(MVPotionEffectType.MINING_FATIGUE.get()), player.getPotionEffect(MVPotionEffectType.CONDUIT_POWER.get()), OriginsReborn.getMVE().isUnderWater((LivingEntity)player), aquaAffinity, true);
    }

    @Override
    public boolean shouldActivate(Player player) {
        return this.getDependency().isEnabled(player) && this.isPhasing.computeIfAbsent(player, pl -> false) != false;
    }

    private void setPhasing(Player player, boolean enabled, boolean begins) {
        GameMode gameMode;
        enabled = this.hasAbility(player) && enabled;
        Block block = player.getEyeLocation().getBlock();
        if (block.getType().isCollidable() && enabled) {
            if (this.giveBlindness) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, ShortcutUtils.infiniteDuration(), 0, false, false));
            }
        } else {
            PotionEffect pot = player.getPotionEffect(PotionEffectType.BLINDNESS);
            if (pot != null && ShortcutUtils.isInfinite(pot)) {
                player.removePotionEffect(PotionEffectType.BLINDNESS);
            }
        }
        if (this.isPhasing.computeIfAbsent(player, pl -> false) == enabled) {
            return;
        }
        Vector vector = player.getVelocity();
        GameMode gameMode2 = gameMode = enabled ? GameMode.SPECTATOR : player.getGameMode();
        if (ShortcutUtils.isBedrockPlayer(player.getUniqueId())) {
            if (begins) {
                player.teleport(player.getLocation().subtract(0.0, 1.0, 0.0));
            }
            OriginsReborn.getMVE().sendGamemodeUpdate(player, gameMode, true);
        } else {
            OriginsReborn.getMVE().sendGamemodeUpdate(player, gameMode, false);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> player.setVelocity(vector));
        this.isPhasing.put(player, enabled);
    }
}

