/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.util.AbilityRegister;
import com.starshootercity.util.config.ConfigManager;
import com.starshootercity.version.MVPotionEffectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

public class PumpkinHate
implements Listener,
VisibleAbility {
    private final Map<Player, List<Player>> ignoringPlayers = new HashMap<Player, List<Player>>();
    private final Set<Player> pumpkinHaters = new HashSet<Player>();
    private boolean poison;

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.runForAbility((Entity)event.getPlayer(), this.pumpkinHaters::add);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.pumpkinHaters.remove(event.getPlayer());
    }

    @EventHandler
    public void onPlayerSwapOrigin(PlayerSwapOriginEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> this.runForAbility((Entity)event.getPlayer(), this.pumpkinHaters::add, this.pumpkinHaters::remove));
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player pumpkinHater : this.pumpkinHaters) {
            for (Player pumpkinWearer : pumpkinHater.getLocation().getNearbyPlayers(64.0)) {
                if (pumpkinWearer == pumpkinHater) continue;
                List ignoring = this.ignoringPlayers.computeIfAbsent(pumpkinHater, p -> new ArrayList());
                ItemStack helmet = pumpkinWearer.getInventory().getHelmet();
                if (helmet != null && helmet.getType() == Material.CARVED_PUMPKIN) {
                    if (ignoring.contains(pumpkinWearer)) continue;
                    ignoring.add(pumpkinWearer);
                    byte data = PumpkinHate.getData(pumpkinWearer);
                    OriginsReborn.getMVE().sendEntityData(pumpkinHater, (Entity)pumpkinWearer, data);
                    for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                        pumpkinHater.sendEquipmentChange((LivingEntity)pumpkinWearer, equipmentSlot, new ItemStack(Material.AIR));
                    }
                    continue;
                }
                if (!ignoring.contains(pumpkinWearer)) continue;
                ignoring.remove(pumpkinWearer);
                AbilityRegister.updateEntity(pumpkinHater, (Entity)pumpkinWearer);
            }
        }
    }

    private static byte getData(Player pumpkinWearer) {
        byte data = 32;
        if (pumpkinWearer.getFireTicks() > 0) {
            data = (byte)(data + 1);
        }
        if (pumpkinWearer.isSneaking()) {
            data = (byte)(data + 2);
        }
        if (pumpkinWearer.isSprinting()) {
            data = (byte)(data + 8);
        }
        if (pumpkinWearer.isSwimming()) {
            data = (byte)(data + 16);
        }
        if (pumpkinWearer.isGlowing()) {
            data = (byte)(data + 64);
        }
        if (pumpkinWearer.isGliding()) {
            data = (byte)(data - 128);
        }
        return data;
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.poison = (Boolean)this.registerConfigOption(plugin, "consume_and_poison", Collections.singletonList("Poison the player when consuming pumpkin pie rather than preventing them from eating it"), ConfigManager.SettingType.BOOLEAN, false);
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        this.runForAbility((Entity)event.getPlayer(), player -> {
            if (event.getItem().getType() == Material.PUMPKIN_PIE) {
                event.setCancelled(true);
                event.getItem().setAmount(event.getItem().getAmount() - 1);
                if (this.poison) {
                    player.addPotionEffect(new PotionEffect(MVPotionEffectType.HUNGER.get(), 300, 2, false, true));
                    player.addPotionEffect(new PotionEffect(MVPotionEffectType.NAUSEA.get(), 300, 1, false, true));
                    player.addPotionEffect(new PotionEffect(MVPotionEffectType.POISON.get(), 1200, 1, false, true));
                }
            }
        });
    }

    @Override
    public String description() {
        return "You are afraid of pumpkins. For a good reason.";
    }

    @Override
    public String title() {
        return "Scared of Gourds";
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:pumpkin_hate");
    }
}

