/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.VisibleAbility;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class ScareCreepers
implements Listener,
VisibleAbility {
    private final NamespacedKey hitByPlayerKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "hit-by-player");

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:scare_creepers");
    }

    @Override
    public String description() {
        return "Creepers are scared of you and will only explode if you attack them first.";
    }

    @Override
    public String title() {
        return "Catlike Appearance";
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            this.fixCreeper(creeper);
        }
    }

    @EventHandler
    public void onEntitiesLoad(EntitiesLoadEvent event) {
        for (Entity entity : event.getEntities()) {
            if (!(entity instanceof Creeper)) continue;
            Creeper creeper = (Creeper)entity;
            this.fixCreeper(creeper);
        }
    }

    public void fixCreeper(Creeper creeper) {
        Bukkit.getMobGoals().addGoal((Mob)creeper, 0, OriginsReborn.getMVE().getCreeperAfraidGoal((LivingEntity)creeper, (entity, player) -> {
            if (this.hasAbility((Player)player)) {
                String data = (String)entity.getPersistentDataContainer().get(this.hitByPlayerKey, PersistentDataType.STRING);
                if (data == null) {
                    return true;
                }
                return !data.equals(player.getUniqueId().toString());
            }
            return false;
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getEntity().getType() != EntityType.CREEPER) return;
        Entity entity = event.getDamager();
        if (entity instanceof Projectile) {
            Player shooter;
            Projectile projectile = (Projectile)entity;
            ProjectileSource projectileSource = projectile.getShooter();
            if (!(projectileSource instanceof Player)) return;
            player = shooter = (Player)projectileSource;
        } else {
            Player damager;
            entity = event.getDamager();
            if (!(entity instanceof Player)) return;
            player = damager = (Player)entity;
        }
        this.runForAbility((Entity)player, p -> event.getEntity().getPersistentDataContainer().set(this.hitByPlayerKey, PersistentDataType.STRING, (Object)p.getUniqueId().toString()));
    }

    @EventHandler
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent event) {
        if (event.getEntity().getType() == EntityType.CREEPER) {
            this.runForAbility((Entity)event.getTarget(), player -> {
                String data = (String)event.getEntity().getPersistentDataContainer().get(this.hitByPlayerKey, PersistentDataType.STRING);
                if (data == null) {
                    event.setCancelled(true);
                    return;
                }
                if (!data.equals(player.getUniqueId().toString())) {
                    event.setCancelled(true);
                }
            });
        }
    }
}

