/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.config.ConfigManager;
import com.starshootercity.version.MVPotionEffectType;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

public class SprintJump
implements Listener,
VisibleAbility {
    private int jumpStrength;

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                if (player.isSprinting()) {
                    player.addPotionEffect(new PotionEffect(MVPotionEffectType.JUMP_BOOST.get(), 5, this.jumpStrength, false, false));
                }
            });
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:sprint_jump");
    }

    @Override
    public String description() {
        return "You are able to jump higher by jumping while sprinting.";
    }

    @Override
    public String title() {
        return "Strong Ankles";
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.jumpStrength = (Integer)this.registerConfigOption(plugin, "jump_strength", Collections.singletonList("Strength of the Jump Boost effect to give"), ConfigManager.SettingType.INTEGER, 1);
    }
}

