/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class Vegetarian
implements Listener,
VisibleAbility {
    private List<Material> meat;
    private boolean poison;

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (event.getItem().getType() == Material.POTION) {
            return;
        }
        this.runForAbility((Entity)event.getPlayer(), player -> {
            if (this.meat.contains(event.getItem().getType())) {
                event.setCancelled(true);
                if (this.poison) {
                    event.getItem().setAmount(event.getItem().getAmount() - 1);
                    player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 300, 1, false, true));
                }
            }
        });
    }

    @Override
    public String description() {
        return "You can't digest any meat.";
    }

    @Override
    public String title() {
        return "Vegetarian";
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:vegetarian");
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.poison = (Boolean)this.registerConfigOption(plugin, "consume_and_poison", Collections.singletonList("Poison the player when consuming meat rather than preventing them from eating it"), ConfigManager.SettingType.BOOLEAN, false);
        String meatContents = "meat";
        this.meat = (List)this.registerConfigOption(plugin, meatContents, Collections.singletonList("Items that count as meat"), ConfigManager.SettingType.MATERIAL_LIST, List.of(Material.PORKCHOP, Material.COOKED_PORKCHOP, Material.BEEF, Material.COOKED_BEEF, Material.CHICKEN, Material.COOKED_CHICKEN, Material.RABBIT, Material.COOKED_RABBIT, Material.MUTTON, Material.COOKED_MUTTON, Material.RABBIT_STEW, Material.COD, Material.COOKED_COD, Material.TROPICAL_FISH, Material.SALMON, Material.COOKED_SALMON, Material.PUFFERFISH, Material.ROTTEN_FLESH, Material.SPIDER_EYE));
    }
}

