/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.version.MVEnchantment;
import java.util.Random;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class WaterBreathing
implements Listener,
VisibleAbility {
    private String deathMessage;
    NamespacedKey airKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "fullair");
    NamespacedKey dehydrationKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "dehydrating");
    NamespacedKey damageKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "ignore-item-damage");
    private final Random random = new Random();

    @EventHandler
    public void onEntityAirChange(EntityAirChangeEvent event) {
        this.runForAbility(event.getEntity(), player -> {
            if (Boolean.TRUE.equals(player.getPersistentDataContainer().get(this.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getPersistentDataContainer().get(this.dehydrationKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN))) {
                return;
            }
            if (player.getRemainingAir() - event.getAmount() > 0 ? !OriginsReborn.getMVE().isUnderWater((LivingEntity)player) && !this.hasWaterBreathing(player) : OriginsReborn.getMVE().isUnderWater((LivingEntity)player) || this.hasWaterBreathing(player)) {
                return;
            }
            event.setCancelled(true);
        });
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        String deathMessageKey = "death-message";
        this.registerTranslation(deathMessageKey, "%player% didn't manage to keep wet");
        this.deathMessage = this.translate(deathMessageKey);
    }

    @EventHandler
    public void onEntityPotionEffect(EntityPotionEffectEvent event) {
        if (event.getCause() != EntityPotionEffectEvent.Cause.TURTLE_HELMET) {
            return;
        }
        this.runForAbility(event.getEntity(), player -> event.setCancelled(true));
    }

    public boolean hasWaterBreathing(Player player) {
        return player.hasPotionEffect(PotionEffectType.CONDUIT_POWER) || player.hasPotionEffect(PotionEffectType.WATER_BREATHING);
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent ignored) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                if (OriginsReborn.getMVE().isUnderWater((LivingEntity)player) || this.hasWaterBreathing(player) || player.isInRain()) {
                    ItemStack helmet = player.getInventory().getHelmet();
                    if (helmet != null && OriginsReborn.getMVE().isUnderWater((LivingEntity)player) && helmet.getType() == Material.TURTLE_HELMET) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, 200, 0, false, false, true));
                    }
                    if (Boolean.TRUE.equals(player.getPersistentDataContainer().get(this.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN))) {
                        player.setRemainingAir(player.getMaximumAir());
                        return;
                    }
                    player.setRemainingAir(Math.min(Math.max(player.getRemainingAir() + 4, 4), player.getMaximumAir()));
                    if (player.getRemainingAir() == player.getMaximumAir()) {
                        player.setRemainingAir(player.getMaximumAir());
                        player.getPersistentDataContainer().set(this.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN, (Object)true);
                    }
                } else {
                    if (Boolean.TRUE.equals(player.getPersistentDataContainer().get(this.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN))) {
                        player.setRemainingAir(player.getMaximumAir());
                        player.getPersistentDataContainer().set(this.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN, (Object)false);
                    }
                    this.decreaseAir(player);
                    if (player.getRemainingAir() < -25) {
                        player.getPersistentDataContainer().set(this.dehydrationKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN, (Object)true);
                        player.setRemainingAir(-5);
                        player.getPersistentDataContainer().set(this.dehydrationKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN, (Object)false);
                        player.getPersistentDataContainer().set(this.damageKey, PersistentDataType.INTEGER, (Object)Bukkit.getCurrentTick());
                        OriginsReborn.getMVE().dealDrowningDamage((LivingEntity)player, 2);
                    }
                }
            }, player -> {
                if (player.getPersistentDataContainer().has(this.airKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN)) {
                    player.setRemainingAir(player.getMaximumAir());
                    player.getPersistentDataContainer().remove(this.airKey);
                }
            });
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if ((Integer)event.getPlayer().getPersistentDataContainer().getOrDefault(this.damageKey, PersistentDataType.INTEGER, (Object)0) >= Bukkit.getCurrentTick()) {
            event.deathMessage((Component)Component.text(this.deathMessage.replaceFirst("%player%", event.getPlayer().getName())));
        }
    }

    public void decreaseAir(Player player) {
        int respirationLevel;
        ItemStack helmet = player.getInventory().getHelmet();
        if (helmet != null && helmet.getItemMeta() != null && (respirationLevel = helmet.getItemMeta().getEnchantLevel(MVEnchantment.RESPIRATION.get())) > 0 && this.random.nextInt(respirationLevel + 1) > 0) {
            return;
        }
        player.setRemainingAir(player.getRemainingAir() - 1);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        event.getPlayer().getPersistentDataContainer().set(this.damageKey, PersistentDataType.INTEGER, (Object)-1);
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:water_breathing");
    }

    @Override
    public String description() {
        return "You can breathe underwater, but not on land.";
    }

    @Override
    public String title() {
        return "Gills";
    }
}

