/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities.types;

import com.starshootercity.APITarget;
import com.starshootercity.abilities.types.Ability;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import java.util.List;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@APITarget
public interface AttributeModifierAbility
extends Ability {
    public static final String OPERATION = "attribute-modifier.operation";
    public static final String EXP = "attribute-modifier.expression";

    @NotNull
    public Attribute getAttribute();

    public double getAmount(Player var1);

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeModifier.Operation getOperation();

    default public double getTotalAmount(Player player) {
        double total = this.getAmount(player);
        if (this.disallowConfiguration()) {
            return total;
        }
        if (total != 0.0) {
            String modifiedValue = this.getConfigOption(EXP, ConfigManager.SettingType.STRING);
            if (modifiedValue.equals("x")) {
                return total;
            }
            try {
                return new ExpressionBuilder(modifiedValue).variables("x").build().setVariable("x", total).evaluate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return total;
    }

    default public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeModifier.Operation getActualOperation() {
        String op;
        if (this.disallowConfiguration()) {
            return this.getOperation();
        }
        return switch (op = this.getConfigOption(OPERATION, ConfigManager.SettingType.STRING).toLowerCase()) {
            case "add_scalar" -> AttributeModifier.Operation.ADD_SCALAR;
            case "add_number" -> AttributeModifier.Operation.ADD_NUMBER;
            case "multiply_scalar_1" -> AttributeModifier.Operation.MULTIPLY_SCALAR_1;
            default -> this.getOperation();
        };
    }

    default public void setupAttributeConfig() {
        if (this.disallowConfiguration()) {
            return;
        }
        this.registerConfigOption(OPERATION, Collections.singletonList("The operation to use ('ADD_SCALAR', 'ADD_NUMBER' or 'MULTIPLY_SCALAR_1')"), ConfigManager.SettingType.STRING, this.getOperation().toString());
        this.registerConfigOption(EXP, List.of("A mathematical expression used to modify the attribute, where 'x' is a variable representing the default modifier.", "Example: 'x * 3' will triple the value used in the modifier."), ConfigManager.SettingType.STRING, "x");
    }

    default public boolean disallowConfiguration() {
        return false;
    }
}

