/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities.types;

import com.starshootercity.APITarget;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.Ability;
import com.starshootercity.util.TriggerManager;
import com.starshootercity.util.config.ConfigManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

@APITarget
public interface TriggerableAbility
extends Ability {
    public static final char PRIMARY_KEYBIND = 'G';
    public static final Set<Material> SWORDS = Set.of(Material.WOODEN_SWORD, Material.STONE_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.DIAMOND_SWORD, Material.NETHERITE_SWORD);

    default public char getDefaultKeybind() {
        return 'G';
    }

    @NotNull
    public Trigger getTrigger();

    public static class Trigger {
        private final TriggerType type;
        private final Set<Condition> conditions;
        private final TriggerRunner runner;
        private final Ability ability;

        private Trigger(TriggerType defaultType, Set<Condition> defaultConditions, TriggerRunner runner, Ability ability) {
            this.type = defaultType;
            this.conditions = defaultConditions;
            this.runner = runner;
            this.ability = ability;
        }

        public TriggerType getType() {
            return this.type;
        }

        public static TriggerBuilder builder(TriggerType type, Ability ability) {
            return new TriggerBuilder(type, ability);
        }

        public void run(TriggerManager.TriggerEvent event) {
            for (Condition condition : this.conditions) {
                if (condition.predicate.test(event)) continue;
                return;
            }
            this.ability.runForAbility((Entity)event.player(), player -> this.runner.run(event));
        }
    }

    public static class TriggerBuilder {
        private final TriggerType type;
        private final Set<Condition> conditions;
        private final Ability ability;

        public Trigger build(TriggerRunner runner) {
            String typePath = "trigger.type";
            String conditionPath = "trigger.conditions";
            this.ability.registerConfigOption(typePath, List.of("The action (e.g. LEFT_CLICK, RIGHT_CLICK) that triggers this ability", "You can see a full list of actions at https://starshooter.gitbook.io/origins-reborn/configuration#triggerable-ability-configuration"), ConfigManager.SettingType.STRING, this.type.toString());
            ArrayList<String> conditionList = new ArrayList<String>();
            for (Condition condition : this.conditions) {
                conditionList.add(condition.toString());
            }
            this.ability.registerConfigOption(conditionPath, List.of("The conditions (e.g. EMPTY_HAND, NO_BLOCK) that are required to trigger this ability", "You can see a full list of conditions at https://starshooter.gitbook.io/origins-reborn/configuration#triggerable-ability-configuration"), ConfigManager.SettingType.STRING_LIST, conditionList);
            TriggerType usedType = this.type;
            try {
                usedType = TriggerType.valueOf(this.ability.getConfigOption(typePath, ConfigManager.SettingType.STRING));
            }
            catch (IllegalArgumentException e) {
                OriginsReborn.getInstance().getLogger().warning("Malformed trigger configuration for ability %s, using default values".formatted(this.ability.getRegisteredKey()));
            }
            Set<Condition> usedConditions = this.conditions;
            try {
                HashSet<Condition> newConds = new HashSet<Condition>();
                for (String s : this.ability.getConfigOption(conditionPath, ConfigManager.SettingType.STRING_LIST)) {
                    newConds.add(Condition.valueOf(s));
                }
                usedConditions = newConds;
            }
            catch (IllegalArgumentException e) {
                OriginsReborn.getInstance().getLogger().warning("Malformed trigger configuration for ability %s, using default values".formatted(this.ability.getRegisteredKey()));
            }
            return new Trigger(usedType, usedConditions, runner, this.ability);
        }

        public TriggerBuilder addConditions(Condition ... conditions) {
            this.conditions.addAll(Arrays.stream(conditions).toList());
            return this;
        }

        private TriggerBuilder(TriggerType type, Ability ability) {
            this.type = type;
            this.ability = ability;
            this.conditions = new HashSet<Condition>();
        }
    }

    public static interface TriggerRunner {
        public void run(TriggerManager.TriggerEvent var1);
    }

    public static enum Condition {
        EMPTY_HAND(event -> event.itemType(Material::isAir)),
        NO_BLOCK(event -> !event.hasBlock()),
        GLIDING(event -> event.player().isGliding()),
        CROUCHING(event -> event.player().isSneaking()),
        DUMMY(event -> true),
        HOLDING_SWORD(event -> event.itemType(SWORDS::contains));

        private final Predicate<TriggerManager.TriggerEvent> predicate;

        private Condition(Predicate<TriggerManager.TriggerEvent> predicate) {
            this.predicate = predicate;
        }
    }

    public static enum TriggerType {
        LEFT_CLICK,
        RIGHT_CLICK,
        OFFHAND_SWAP,
        JUMP,
        SPRINT_ON,
        SPRINT_OFF,
        SPRINT_TOGGLE,
        SNEAK_ON,
        SNEAK_OFF,
        SNEAK_TOGGLE,
        DOUBLE_TAP_SNEAK,
        RIGHT_CLICK_CHESTPLATE;

    }
}

