/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.cooldowns;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.util.ShortcutUtils;
import com.starshootercity.util.config.ConfigManager;
import com.starshootercity.version.MVAttribute;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class Cooldowns
implements Listener {
    private final Map<NamespacedKey, CooldownInfo> registeredCooldowns = new HashMap<NamespacedKey, CooldownInfo>();
    private final NamespacedKey cooldownKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "cooldowns");
    private final NamespacedKey hasCooldownKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "has_cooldown");
    public static List<Component> emptyBarPieces;
    public final Map<String, CooldownIconData> iconDataMap = new HashMap<String, CooldownIconData>();

    @EventHandler
    public void onPlayerSwapOrigin(PlayerSwapOriginEvent event) {
        event.getPlayer().getPersistentDataContainer().remove(this.cooldownKey);
    }

    @Nullable
    private static String getTime(int cooldownTime) {
        if (cooldownTime <= 0) {
            return null;
        }
        String time = Math.floorDiv(cooldownTime, 60) == 0 ? "%ss".formatted(cooldownTime) : "%sm %ss".formatted(Math.floorDiv(cooldownTime, 60), cooldownTime % 60);
        return time;
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            LivingEntity entity;
            AttributeInstance instance;
            if (ShortcutUtils.isBedrockPlayer(player.getUniqueId())) {
                StringBuilder s = new StringBuilder();
                for (NamespacedKey key : this.getCooldowns(player)) {
                    CooldownInfo info = this.registeredCooldowns.get(key);
                    if (info.getIcon() == null) continue;
                    int amount = (int)(this.getCooldown(player, key) / 50L);
                    s.append(Cooldowns.getTime(amount)).append(" ");
                }
                player.sendActionBar((Component)Component.text(s.toString()));
                continue;
            }
            Component message = Component.empty();
            int num = 0;
            Entity vehicle = player.getVehicle();
            if (vehicle != null && vehicle instanceof LivingEntity && (instance = (entity = (LivingEntity)vehicle).getAttribute(MVAttribute.MAX_HEALTH.get())) != null) {
                num += (int)(Math.floor((instance.getValue() - 1.0) / 10.0) - 1.0);
            }
            if (player.getRemainingAir() < player.getMaximumAir() || OriginsReborn.getMVE().isUnderWater((LivingEntity)player)) {
                ++num;
            }
            int i = 0;
            for (NamespacedKey key : this.getCooldowns(player)) {
                CooldownInfo info = this.registeredCooldowns.get(key);
                if (info.getIcon() == null) continue;
                ++i;
                float amount = (float)this.getCooldown(player, key) / ((float)info.getCooldownTime() * 50.0f);
                if (!info.isReversed()) {
                    amount = 1.0f - amount;
                }
                message = message.append(Component.text("\uf004")).append(this.formCooldownBar(amount, info, num));
                ++num;
            }
            if (i == 0) {
                if (!player.getPersistentDataContainer().has(this.hasCooldownKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN)) continue;
                player.getPersistentDataContainer().remove(this.hasCooldownKey);
            }
            player.getPersistentDataContainer().set(this.hasCooldownKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN, (Object)true);
            player.sendActionBar(OriginsReborn.getMVE().applyFont(Component.text("\uf003"), Key.key("minecraft:cooldown_bar/height_0")).append(message));
        }
    }

    public Component formCooldownBar(float percentage, CooldownInfo info, int height) {
        return this.iconDataMap.get(info.getIcon()).assemble(percentage, height);
    }

    public long getCooldown(Player player, NamespacedKey key) {
        PersistentDataContainer pdc = (PersistentDataContainer)player.getPersistentDataContainer().getOrDefault(this.cooldownKey, PersistentDataType.TAG_CONTAINER, (Object)player.getPersistentDataContainer().getAdapterContext().newPersistentDataContainer());
        CooldownInfo info = this.registeredCooldowns.get(key);
        if (info == null) {
            return 0L;
        }
        return Math.max(0L, (Long)pdc.getOrDefault(key, PersistentDataType.LONG, (Object)0L) - (info.isStatic() ? 0L : Instant.now().toEpochMilli()));
    }

    public List<NamespacedKey> getCooldowns(Player player) {
        PersistentDataContainer pdc = (PersistentDataContainer)player.getPersistentDataContainer().getOrDefault(this.cooldownKey, PersistentDataType.TAG_CONTAINER, (Object)player.getPersistentDataContainer().getAdapterContext().newPersistentDataContainer());
        ArrayList<NamespacedKey> keys = new ArrayList<NamespacedKey>(pdc.getKeys());
        keys.removeIf(key -> !this.registeredCooldowns.containsKey(key) || !this.hasCooldown(player, (NamespacedKey)key) && !this.registeredCooldowns.get(key).isStatic());
        return keys;
    }

    public void resetCooldowns(Player player) {
        player.getPersistentDataContainer().remove(this.cooldownKey);
    }

    public boolean hasCooldown(Player player, NamespacedKey key) {
        return this.getCooldown(player, key) > 0L;
    }

    public void setCooldown(Player player, NamespacedKey key, int cooldown) {
        if (cooldown == -1) {
            return;
        }
        CooldownInfo info = this.registeredCooldowns.get(key);
        PersistentDataContainer pdc = (PersistentDataContainer)player.getPersistentDataContainer().getOrDefault(this.cooldownKey, PersistentDataType.TAG_CONTAINER, (Object)player.getPersistentDataContainer().getAdapterContext().newPersistentDataContainer());
        pdc.set(key, PersistentDataType.LONG, (Object)(info.isStatic ? (long)cooldown * 50L : Instant.now().toEpochMilli() + (long)cooldown * 50L));
        player.getPersistentDataContainer().set(this.cooldownKey, PersistentDataType.TAG_CONTAINER, (Object)pdc);
    }

    public void setCooldown(Player player, NamespacedKey key) {
        CooldownInfo info = this.registeredCooldowns.get(key);
        this.setCooldown(player, key, info.getCooldownTime());
    }

    public CooldownIconData makeCID(File file) {
        BufferedImage image;
        try {
            image = ImageIO.read(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new CooldownIconData(this.makeBarPieces(image), this.makeIcon(image));
    }

    public Component makeIcon(BufferedImage image) {
        BufferedImage iconImage = image.getSubimage(73, 0, 8, 8);
        Component icon = Component.empty();
        String pixels = "\ue000\ue001\ue002\ue003\ue004\ue005\ue006\ue007";
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                int col = iconImage.getRGB(x, y);
                icon = col == 0 ? icon.append(Component.text("\uf002")) : icon.append(Component.text(pixels.charAt(y)).color(TextColor.color(col)));
                icon = icon.append(Component.text(y == 7 ? "\uf001" : "\uf000"));
            }
        }
        return icon;
    }

    public List<Component> makeBarPieces(BufferedImage image) {
        BufferedImage barImage = image.getSubimage(0, 2, 71, 5);
        String pixels = "\ue002\ue003\ue004\ue005\ue006";
        ArrayList<Component> result = new ArrayList<Component>();
        for (int x = 0; x < 71; ++x) {
            Component c = Component.empty();
            for (int y = 0; y < 5; ++y) {
                int col = barImage.getRGB(x, y);
                c = col == 0 ? c.append(Component.text("\uf002")) : c.append(Component.text(pixels.charAt(y)).color(TextColor.color(col)));
                if (y == 4) continue;
                c = c.append(Component.text("\uf000"));
            }
            result.add(c);
        }
        return result;
    }

    public NamespacedKey registerCooldown(JavaPlugin instance, NamespacedKey key, CooldownInfo info) {
        if (ConfigManager.getConfigValue(ConfigManager.Option.DISABLE_ALL_COOLDOWNS).booleanValue()) {
            return key;
        }
        if (info.getIcon() != null && ConfigManager.getConfigValue(ConfigManager.Option.SHOW_COOLDOWN_ICONS).booleanValue()) {
            File icon = new File(instance.getDataFolder(), "icons/%s.png".formatted(info.getIcon()));
            if (!icon.exists()) {
                boolean ignored = icon.getParentFile().mkdirs();
                instance.saveResource("icons/%s.png".formatted(info.getIcon()), false);
            }
            CooldownIconData iconData = this.makeCID(icon);
            this.iconDataMap.put(info.getIcon(), iconData);
        }
        this.registeredCooldowns.put(key, info);
        return key;
    }

    public Cooldowns() {
        BufferedImage image;
        File icon = new File(OriginsReborn.getInstance().getDataFolder(), "icons/empty_bar.png");
        if (!icon.exists()) {
            boolean ignored = icon.getParentFile().mkdirs();
            OriginsReborn.getInstance().saveResource("icons/empty_bar.png", false);
        }
        try {
            image = ImageIO.read(icon);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        emptyBarPieces = this.makeBarPieces(image);
    }

    @EventHandler
    public void onPlayerDeepSleep(PlayerDeepSleepEvent event) {
        if (ConfigManager.getConfigValue(ConfigManager.Option.SLEEPING_RESETS_COOLDOWNS).booleanValue()) {
            for (NamespacedKey key : this.getCooldowns(event.getPlayer())) {
                if (this.registeredCooldowns.get((Object)key).isStatic) continue;
                this.setCooldown(event.getPlayer(), key, 0);
            }
        }
    }

    public static class CooldownInfo {
        private int cooldownTime;
        private final boolean reversed;
        @Nullable
        private final String icon;
        private final boolean isStatic;

        public CooldownInfo(int cooldownTime, @Nullable String icon, boolean reversed, boolean isStatic) {
            this.cooldownTime = cooldownTime;
            this.icon = icon;
            this.reversed = reversed;
            this.isStatic = isStatic;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public CooldownInfo(int cooldownTime, @Nullable String icon, boolean reversed) {
            this(cooldownTime, icon, reversed, false);
        }

        public CooldownInfo(int cooldownTime, @Nullable String icon) {
            this(cooldownTime, icon, false, false);
        }

        public CooldownInfo(int cooldownTime, boolean reversed) {
            this(cooldownTime, null, reversed, false);
        }

        public CooldownInfo(int cooldownTime) {
            this(cooldownTime, null, false, false);
        }

        @Nullable
        public String getIcon() {
            return this.icon;
        }

        public void setCooldownTime(int cooldownTime) {
            this.cooldownTime = cooldownTime;
        }

        public int getCooldownTime() {
            return this.cooldownTime;
        }
    }

    public record CooldownIconData(List<Component> barPieces, Component icon) {
        public Component assemble(float completion, int height) {
            int num = (int)Math.floor((float)this.barPieces.size() * completion);
            Component result = this.icon.append(Component.text("\uf002"));
            for (int i = 0; i < this.barPieces.size(); ++i) {
                result = result.append((i <= num ? this.barPieces : emptyBarPieces).get(i));
                result = result.append(Component.text("\uf001"));
            }
            String formatted = "minecraft:cooldown_bar/height_%s".formatted(height);
            return OriginsReborn.getMVE().applyFont(result, Key.key(formatted));
        }
    }
}

