/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.util;

import com.starshootercity.OriginsReborn;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.geysermc.api.Geyser;
import org.geysermc.floodgate.api.FloodgateApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShortcutUtils {
    private static final Map<UUID, Boolean> isBedrock = new HashMap<UUID, Boolean>();

    public static void giveItemWithDrops(Player player, ItemStack ... itemStacks) {
        for (ItemStack i : player.getInventory().addItem(itemStacks).values()) {
            player.getWorld().dropItemNaturally(player.getLocation(), i);
        }
    }

    @Nullable
    public static LivingEntity getLivingDamageSource(@NotNull EntityDamageByEntityEvent event) {
        Projectile projectile;
        Entity entity = event.getDamager();
        if (entity instanceof Projectile && (entity = (projectile = (Projectile)entity).getShooter()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            return entity2;
        }
        entity = event.getDamager();
        if (entity instanceof LivingEntity) {
            LivingEntity entity3 = (LivingEntity)entity;
            return entity3;
        }
        return null;
    }

    public static boolean isBedrockPlayer(UUID uuid) {
        return isBedrock.computeIfAbsent(uuid, ShortcutUtils::checkBedrock);
    }

    private static boolean checkBedrock(UUID uuid) {
        try {
            return FloodgateApi.getInstance().isFloodgatePlayer(uuid);
        }
        catch (NoClassDefFoundError e) {
            try {
                return Geyser.api().isBedrockPlayer(uuid);
            }
            catch (NoClassDefFoundError ex) {
                return false;
            }
        }
    }

    public static Component getColored(String f) {
        Component component = Component.empty();
        Iterator<String> iterator = ShortcutUtils.substringsBetween(f, "<", ">").iterator();
        for (String s : f.split("<#\\w{6}>")) {
            if (s.isEmpty()) continue;
            component = component.append(iterator.hasNext() ? Component.text(s).color(TextColor.fromHexString(iterator.next())) : Component.text(s));
        }
        return component;
    }

    public static List<String> substringsBetween(String s, String start, String end) {
        int starti = s.indexOf(start);
        if (starti == -1) {
            return List.of();
        }
        String startPart = s.substring(starti);
        int endi = startPart.indexOf(end);
        if (endi == -1) {
            return List.of();
        }
        ArrayList<String> data = new ArrayList<String>();
        data.add(startPart.substring(0, endi));
        data.addAll(ShortcutUtils.substringsBetween(startPart.substring(endi), start, end));
        return data;
    }

    public static boolean isInfinite(PotionEffect effect) {
        if (OriginsReborn.getMVE().supportsInfiniteDuration()) {
            return effect.getDuration() == -1;
        }
        return effect.getDuration() >= 20000;
    }

    public static int infiniteDuration() {
        if (OriginsReborn.getMVE().supportsInfiniteDuration()) {
            return -1;
        }
        return 50000;
    }

    public static Inventory getTopInventory(HumanEntity player) {
        try {
            InventoryView view = player.getOpenInventory();
            Method getTopInventory = view.getClass().getMethod("getTopInventory", new Class[0]);
            getTopInventory.setAccessible(true);
            return (Inventory)getTopInventory.invoke((Object)view, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

