/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.util;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.starshootercity.abilities.types.TriggerableAbility;
import com.starshootercity.events.PlayerLeftClickEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TriggerManager
implements Listener {
    private static final TriggerManager instance = new TriggerManager();
    private final Map<TriggerableAbility.TriggerType, Set<TriggerableAbility.Trigger>> triggerableAbilities = new HashMap<TriggerableAbility.TriggerType, Set<TriggerableAbility.Trigger>>();
    private final Map<Player, Integer> lastInteractionTickMap = new HashMap<Player, Integer>();

    public static TriggerManager getInstance() {
        return instance;
    }

    public void register(TriggerableAbility ability) {
        this.triggerableAbilities.computeIfAbsent(ability.getTrigger().getType(), k -> new HashSet()).add(ability.getTrigger());
    }

    public void callTriggerEvent(TriggerEvent event, TriggerableAbility.TriggerType type, @Nullable Cancellable cancellable) {
        for (TriggerableAbility.Trigger trigger : this.triggerableAbilities.getOrDefault((Object)type, Collections.emptySet())) {
            trigger.run(event);
        }
        if (cancellable != null && event.isCancelled()) {
            cancellable.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerLeftClick(PlayerLeftClickEvent event) {
        TriggerEvent triggerEvent = new TriggerEvent(event.getPlayer(), event.getItem(), event.getClickedBlock());
        this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.LEFT_CLICK, null);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.getAction().isRightClick()) {
            return;
        }
        TriggerEvent triggerEvent = new TriggerEvent(event.getPlayer(), event.getItem(), event.getClickedBlock());
        this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.RIGHT_CLICK, (Cancellable)event);
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        TriggerEvent triggerEvent = new TriggerEvent(event.getPlayer(), event.getMainHandItem(), null);
        this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.OFFHAND_SWAP, (Cancellable)event);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player p = (Player)humanEntity;
            if (event.isRightClick() && event.getSlotType() == InventoryType.SlotType.ARMOR && event.getSlot() == 38) {
                TriggerEvent triggerEvent = new TriggerEvent(p, event.getCurrentItem(), null);
                this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.RIGHT_CLICK_CHESTPLATE, (Cancellable)event);
            }
        }
    }

    @EventHandler
    public void onPlayerJump(PlayerJumpEvent event) {
        TriggerEvent triggerEvent = new TriggerEvent(event.getPlayer(), null, null);
        this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.JUMP, (Cancellable)event);
    }

    @EventHandler
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        TriggerEvent triggerEvent = new TriggerEvent(event.getPlayer(), null, null);
        if (event.isSprinting()) {
            this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.SPRINT_ON, (Cancellable)event);
        } else {
            this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.SPRINT_OFF, (Cancellable)event);
        }
        this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.SPRINT_TOGGLE, (Cancellable)event);
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        TriggerEvent triggerEvent = new TriggerEvent(event.getPlayer(), null, null);
        this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.SNEAK_TOGGLE, (Cancellable)event);
        if (!event.isSneaking()) {
            this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.SNEAK_OFF, (Cancellable)event);
            return;
        }
        this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.SNEAK_ON, (Cancellable)event);
        if (this.lastInteractionTickMap.getOrDefault(event.getPlayer(), 0) - Bukkit.getCurrentTick() > 0) {
            this.callTriggerEvent(triggerEvent, TriggerableAbility.TriggerType.DOUBLE_TAP_SNEAK, (Cancellable)event);
            this.lastInteractionTickMap.remove(event.getPlayer());
            return;
        }
        this.lastInteractionTickMap.put(event.getPlayer(), Bukkit.getCurrentTick() + 5);
    }

    public static final class TriggerEvent {
        private final Player player;
        @Nullable
        private final ItemStack item;
        @Nullable
        private final Block block;
        private boolean cancelled;

        public TriggerEvent(Player player, @Nullable ItemStack item, @Nullable Block block) {
            this.player = player;
            this.item = item;
            this.block = block;
            this.cancelled = false;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public boolean hasBlock() {
            return this.block != null;
        }

        public boolean itemType(Predicate<Material> predicate) {
            if (this.item != null) {
                return predicate.test(this.item.getType());
            }
            return predicate.test(this.player.getInventory().getItemInMainHand().getType());
        }

        public Player player() {
            return this.player;
        }

        @Nullable
        public ItemStack item() {
            return this.item;
        }

        @Nullable
        public Block block() {
            return this.block;
        }
    }
}

