/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.util.config;

import com.starshootercity.OriginsReborn;
import com.starshootercity.util.config.LegacyConfigUpdater;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.ApiStatus;

public class ConfigManager {
    public static String VERSION = "2.6.0";

    private static ConfigurationSection getConfig() {
        return OriginsReborn.getInstance().getConfig();
    }

    private static void saveConfig() {
        OriginsReborn.getInstance().saveConfig();
    }

    private static void setComments(String path, List<String> comments) {
        OriginsReborn.getInstance().setComments(path, comments);
    }

    public static <T> T getConfigValue(Option<T> option) {
        return option.getValue();
    }

    public static class Option<T> {
        private static boolean hasUpdated = false;
        private static final Map<String, Option<?>> options = new HashMap();
        public static Option<String> OVERWORLD_DIMENSION;
        public static Option<String> NETHER_DIMENSION;
        public static Option<String> END_DIMENSION;
        public static Option<List<String>> DISABLED_WORLDS;
        public static Option<Map<String, List<String>>> COMMANDS_ON_ORIGIN;
        public static Option<Map<String, List<String>>> ABILITY_BLOCKING_REGIONS;
        public static Option<Boolean> WORLDGUARD_HOOK;
        public static Option<Boolean> DISABLE_ALL_COOLDOWNS;
        public static Option<Boolean> SHOW_COOLDOWN_ICONS;
        public static Option<Boolean> SLEEPING_RESETS_COOLDOWNS;
        public static Option<Boolean> DISABLE_FLIGHT_STUFF;
        public static Option<Boolean> SWAP_COMMAND_ENABLED;
        public static Option<String> SWAP_COMMAND_PERMISSION;
        public static Option<Boolean> SWAP_COMMAND_RESETS_PLAYER;
        public static Option<Integer> SWAP_COMMAND_COOLDOWN;
        public static Option<Boolean> SWAP_COMMAND_VAULT_ENABLED;
        public static Option<String> SWAP_COMMAND_VAULT_BYPASS_PERMISSION;
        public static Option<Integer> SWAP_COMMAND_VAULT_DEFAULT_COST;
        public static Option<Boolean> SWAP_COMMAND_VAULT_PERMANENT_PURCHASES;
        public static Option<String> SWAP_COMMAND_VAULT_CURRENCY_SYMBOL;
        public static Option<Boolean> ORIGIN_SELECTION_CONFIRM_SELECTION;
        public static Option<Integer> ORIGIN_SELECTION_DELAY_BEFORE_REQUIRED;
        public static Option<Map<String, Integer>> ORIGIN_SELECTION_LAYER_ORDERS;
        public static Option<Map<String, String>> ORIGIN_SELECTION_DEFAULT_ORIGINS;
        public static Option<String> ORIGIN_SELECTION_INVULNERABLE_MODE;
        public static Option<Boolean> ORIGIN_SELECTION_AUTO_SPAWN_TELEPORT;
        public static Option<Map<String, Boolean>> ORIGIN_SELECTION_RANDOMISE;
        public static Option<Boolean> ORIGIN_SELECTION_DEATH_ORIGIN_CHANGE;
        public static Option<Integer> ORIGIN_SELECTION_SCROLL_AMOUNT;
        public static Option<Boolean> ORIGIN_SELECTION_RANDOM_OPTION_ENABLED;
        public static Option<List<String>> ORIGIN_SELECTION_RANDOM_OPTION_EXCLUDE;
        public static Option<String> ORIGIN_SELECTION_SCREEN_TITLE_PREFIX;
        public static Option<String> ORIGIN_SELECTION_SCREEN_TITLE_BACKGROUND;
        public static Option<String> ORIGIN_SELECTION_SCREEN_TITLE_SUFFIX;
        public static Option<Boolean> ORB_OF_ORIGIN_RESET_PLAYER;
        public static Option<Boolean> ORB_OF_ORIGIN_CONSUME;
        public static Option<Map<String, Boolean>> ORB_OF_ORIGIN_RANDOM;
        public static Option<Boolean> ORB_OF_ORIGIN_ENABLE_RECIPE;
        public static Option<List<List<Material>>> ORB_OF_ORIGIN_RECIPE;
        public static Option<Boolean> RESOURCE_PACK_ENABLED;
        public static Option<Boolean> DISPLAY_ENABLE_PREFIXES;
        public static Option<Integer> MAX_SAME_ORIGIN;
        public static Option<String> REUSING_ORIGINS;
        public static Option<Boolean> PREVENT_SAME_ORIGINS;
        public static Option<Integer> GEYSER_JOIN_FORM_DELAY;
        public static Option<Boolean> SKINSRESTORER_HOOK_ENABLED;
        public static Option<String> SKINSRESTORER_HOOK_IP;
        public static Option<Integer> SKINSRESTORER_HOOK_PORT;
        public static Option<Integer> REFRESH_RATE;
        public static Option<String> CONFIG_VERSION;
        private final SettingType<T> type;
        private final String path;
        private final T defaultValue;
        private final List<String> comments;

        public static Map<String, Option<?>> getOptions() {
            return options;
        }

        public static void initialize() {
            OVERWORLD_DIMENSION = new Option<String>(SettingType.STRING, "worlds.world", "Overworld dimension", "world");
            NETHER_DIMENSION = new Option<String>(SettingType.STRING, "worlds.world_nether", "Nether dimension", "world_nether");
            END_DIMENSION = new Option<String>(SettingType.STRING, "worlds.world_the_end", "End dimension", "world_the_end");
            DISABLED_WORLDS = new Option<List<String>>(SettingType.STRING_LIST, "worlds.disabled_worlds", "Worlds to disable origins in", List.of("example_world"));
            COMMANDS_ON_ORIGIN = new Option<Map<String, List<String>>>(SettingType.MAP_STRING_TO_STRING_LIST, "commands-on-origin", List.of("Runs commands when the player switches to an origin", "Origins should be formatted as they are in the file names, but without the extension, e.g. \"human\"", "%player% is replaced with the player's username and %uuid% is replaced with their UUID", "Use \"default\" for commands that should be run regardless of origin"), Map.of("example", List.of("example %player%", "example %uuid%")));
            ABILITY_BLOCKING_REGIONS = new Option<Map<String, List<String>>>(SettingType.MAP_STRING_TO_STRING_LIST, "prevent-abilities-in", Collections.singletonList("A list of WorldGuard regions in which to prevent the use of certain abilities, use 'all' for all abilities"), Map.of("no_water_breathing", Collections.singletonList("origins:water_breathing"), "no_abilities", Collections.singletonList("all")));
            WORLDGUARD_HOOK = new Option<Boolean>(SettingType.BOOLEAN, "enable-worldguard-hook", Collections.singletonList("Whether to enable the WorldGuard hook automatically (can be disabled to improve performance if the hook is not used)"), Boolean.valueOf(true));
            DISABLE_ALL_COOLDOWNS = new Option<Boolean>(SettingType.BOOLEAN, "cooldowns.disable-all-cooldowns", Collections.singletonList("Disables every cooldown"), Boolean.valueOf(false));
            SHOW_COOLDOWN_ICONS = new Option<Boolean>(SettingType.BOOLEAN, "cooldowns.show-cooldown-icons", List.of("Use the actionbar to show cooldown icons", "You may want to disable this if using another plugin that requires the actionbar"), Boolean.valueOf(true));
            SLEEPING_RESETS_COOLDOWNS = new Option<Boolean>(SettingType.BOOLEAN, "cooldowns.sleeping-resets-cooldowns", "Sleeping will reset all the cooldowns", Boolean.valueOf(false));
            DISABLE_FLIGHT_STUFF = new Option<Boolean>(SettingType.BOOLEAN, "misc-settings.disable-flight-stuff", "Disable all flight-related features. This does not hide the abilities themselves, they must be removed from the .yml files in the ~/plugins/Origins-Reborn/origins/ folder", Boolean.valueOf(false));
            SWAP_COMMAND_ENABLED = new Option<Boolean>(SettingType.BOOLEAN, "swap-command.enabled", "Enable the swap command", Boolean.valueOf(true));
            SWAP_COMMAND_PERMISSION = new Option<String>(SettingType.STRING, "swap-command.permission", "Permission required for origin swap command", "originsreborn.admin");
            SWAP_COMMAND_RESETS_PLAYER = new Option<Boolean>(SettingType.BOOLEAN, "swap-command.reset-player", "Reset player data like inventory and spawn point when switching origins using the /origin swap command", Boolean.valueOf(false));
            SWAP_COMMAND_COOLDOWN = new Option<Integer>(SettingType.INTEGER, "swap-command.cooldown", "Cooldown for the command (in ticks), -1 means no cooldown", Integer.valueOf(-1));
            SWAP_COMMAND_VAULT_ENABLED = new Option<Boolean>(SettingType.BOOLEAN, "swap-command.vault.enabled", "Enable charging players with Vault", Boolean.valueOf(false));
            SWAP_COMMAND_VAULT_BYPASS_PERMISSION = new Option<String>(SettingType.STRING, "swap-command.vault.bypass-permission", "Permission to bypass the cost of the swap command", "originsreborn.costbypass");
            SWAP_COMMAND_VAULT_DEFAULT_COST = new Option<Integer>(SettingType.INTEGER, "swap-command.vault.default-cost", "Default cost of switching origin, if it hasn't been overriden in the origin file", Integer.valueOf(1000));
            SWAP_COMMAND_VAULT_PERMANENT_PURCHASES = new Option<Boolean>(SettingType.BOOLEAN, "swap-command.vault.permanent-purchases", "Allows the player to switch back to origins for free if they already had the origin before", Boolean.valueOf(false));
            SWAP_COMMAND_VAULT_CURRENCY_SYMBOL = new Option<String>(SettingType.STRING, "swap-command.vault.currency-symbol", "Currency symbol for the economy", "$");
            ORIGIN_SELECTION_CONFIRM_SELECTION = new Option<Boolean>(SettingType.BOOLEAN, "origin-selection.confirm-selection", "Confirm the origin selection by double clicking the button", Boolean.valueOf(false));
            ORIGIN_SELECTION_DELAY_BEFORE_REQUIRED = new Option<Integer>(SettingType.INTEGER, "origin-selection.delay-before-required", "The amount of time (in ticks, a tick is a 20th of a second) to wait between a player joining and when the GUI should open", Integer.valueOf(0));
            ORIGIN_SELECTION_LAYER_ORDERS = new Option<Map<String, Integer>>(SettingType.MAP_STRING_TO_INTEGER, "origin-selection.layer-orders", "Priorities for different origin 'layers' to be selected in, higher priority layers are selected first.", Map.of("origin", 1));
            ORIGIN_SELECTION_DEFAULT_ORIGINS = new Option<Map<String, String>>(SettingType.MAP_STRING_TO_STRING, "origin-selection.default-origin", List.of("Default origin, automatically gives players this origin rather than opening the GUI when the player has no origin", "Should be the name of the origin file without the ending, e.g. for 'origin_name.json' the value should be 'origin_name'", "Disabled if set to an invalid name such as \"NONE\""), Map.of("origin", "NONE"));
            ORIGIN_SELECTION_INVULNERABLE_MODE = new Option<String>(SettingType.STRING, "origin-selection.invulnerable-mode", List.of("OFF - you can take damage with the origin selection GUI open", "ON - you cannot take damage with the origin selection GUI open", "INITIAL - you cannot take damage if you do not have an origin (and therefore cannot close the screen)"), "OFF");
            ORIGIN_SELECTION_AUTO_SPAWN_TELEPORT = new Option<Boolean>(SettingType.BOOLEAN, "origin-selection.auto-spawn-teleport", "Automatically teleport players to the world spawn when first selecting an origin", Boolean.valueOf(true));
            ORIGIN_SELECTION_RANDOMISE = new Option<Map<String, Boolean>>(SettingType.MAP_STRING_TO_BOOLEAN, "origin-selection.randomise", "Randomise origins instead of letting players pick", Map.of("origin", false));
            ORIGIN_SELECTION_DEATH_ORIGIN_CHANGE = new Option<Boolean>(SettingType.BOOLEAN, "origin-selection.death-origin-change", List.of("Allows players to choose a new origin when they die", "If randomise is enabled this will reroll their origin to something random"), Boolean.valueOf(false));
            ORIGIN_SELECTION_SCROLL_AMOUNT = new Option<Integer>(SettingType.INTEGER, "origin-selection.scroll-amount", "Amount to scroll per scroll button click", Integer.valueOf(1));
            ORIGIN_SELECTION_RANDOM_OPTION_ENABLED = new Option<Boolean>(SettingType.BOOLEAN, "origin-selection.random-option.enabled", "Enable the random option choice - does nothing if randomise is enabled", Boolean.valueOf(true));
            ORIGIN_SELECTION_RANDOM_OPTION_EXCLUDE = new Option<List<String>>(SettingType.STRING_LIST, "origin-selection.random-option.exclude", "Origins to exclude from random options", List.of("human"));
            ORIGIN_SELECTION_SCREEN_TITLE_PREFIX = new Option<String>(SettingType.STRING, "origin-selection.screen-title.prefix", "Prefix of GUI title", "");
            ORIGIN_SELECTION_SCREEN_TITLE_BACKGROUND = new Option<String>(SettingType.STRING, "origin-selection.screen-title.background", "Background, between Origins-Reborn background and things like text", "");
            ORIGIN_SELECTION_SCREEN_TITLE_SUFFIX = new Option<String>(SettingType.STRING, "origin-selection.screen-title.suffix", "Suffix of GUI title", "");
            ORB_OF_ORIGIN_RESET_PLAYER = new Option<Boolean>(SettingType.BOOLEAN, "orb-of-origin.reset-player", "Reset player data like inventory and spawn point when switching origins using the Orb of Origin", Boolean.valueOf(false));
            ORB_OF_ORIGIN_CONSUME = new Option<Boolean>(SettingType.BOOLEAN, "orb-of-origin.consume", "Consume the Orb of Origin upon use", Boolean.valueOf(true));
            ORB_OF_ORIGIN_RANDOM = new Option<Map<String, Boolean>>(SettingType.MAP_STRING_TO_BOOLEAN, "orb-of-origin.random", "Randomise origin instead of opening the selector upon using the orb", Map.of("origin", false));
            ORB_OF_ORIGIN_ENABLE_RECIPE = new Option<Boolean>(SettingType.BOOLEAN, "orb-of-origin.enable-recipe", "Enable recipe for crafting the Orb of Origin", Boolean.valueOf(false));
            ORB_OF_ORIGIN_RECIPE = new Option<List<List<Material>>>(SettingType.MATERIAL_LIST_LIST, "orb-of-origin.recipe", "Crafting recipe for the Orb of Origin", List.of(List.of(Material.AIR, Material.DIAMOND, Material.AIR), List.of(Material.DIAMOND, Material.NETHER_STAR, Material.DIAMOND), List.of(Material.AIR, Material.DIAMOND, Material.AIR)));
            RESOURCE_PACK_ENABLED = new Option<Boolean>(SettingType.BOOLEAN, "resource-pack.enabled", List.of("Whether to enable the Java resource pack", "If this is set to false you should send the pack to players either in server.properties or in another plugin", "You can find the pack on the GitHub at https://github.com/cometcake575/Origins-Reborn/raw/refs/heads/main/OriginsPack.zip"), Boolean.valueOf(true));
            DISPLAY_ENABLE_PREFIXES = new Option<Boolean>(SettingType.BOOLEAN, "display.enable-prefixes", "Enable prefixes in tab and on display names with the names of origins", Boolean.valueOf(false));
            MAX_SAME_ORIGIN = new Option<Integer>(SettingType.INTEGER, "restrictions.max_same_origin", List.of("The maximum number of players who can have the same origin at once (-1 means no limit)", "This can be overridden by the 'max' setting in individual origins"), Integer.valueOf(-1));
            REUSING_ORIGINS = new Option<String>(SettingType.STRING, "restrictions.reusing-origins", List.of("\"NONE\" allows origins to be reused", "\"PERPLAYER\" means individual players can only use an origin once", "\"ALL\" means no players can use an origin again after one has selected it"), "NONE");
            PREVENT_SAME_ORIGINS = new Option<Boolean>(SettingType.BOOLEAN, "restrictions.prevent-same-origins", "Prevent players from having the same origins as other players, this is locked on if reusing-origins is set to ALL", Boolean.valueOf(false));
            GEYSER_JOIN_FORM_DELAY = new Option<Integer>(SettingType.INTEGER, "geyser.join-form-delay", "The delay in ticks to wait before showing a new Bedrock player the selection GUI", Integer.valueOf(20));
            SKINSRESTORER_HOOK_ENABLED = new Option<Boolean>(SettingType.BOOLEAN, "skinsrestorer-hook.enabled", "Whether to enable the SkinsRestorer hook", Boolean.valueOf(false));
            SKINSRESTORER_HOOK_IP = new Option<String>(SettingType.STRING, "skinsrestorer-hook.ip", "The IP of your server, set this to your server's public IP (without the port)", "UNSET");
            SKINSRESTORER_HOOK_PORT = new Option<Integer>(SettingType.INTEGER, "skinsrestorer-hook.port", "Set this to any other open port on the server, this is used to host the image of the skin, so it can be used by SkinsRestorer", Integer.valueOf(80));
            REFRESH_RATE = new Option<Integer>(SettingType.INTEGER, "refresh-rate", "How many ticks apart should the plugin refresh be, increasing this number will improve performance but will cause issues if too high", Integer.valueOf(4));
            CONFIG_VERSION = new Option<String>(SettingType.STRING, "config-version", "Config version - do not touch this!", VERSION);
            LegacyConfigUpdater.updateConfig();
            Option.makeOptionHeader("worlds", Collections.singletonList("Worlds used for some abilities"));
            Option.makeOptionHeader("cooldowns", "Configuration for cooldowns");
            Option.makeOptionHeader("misc-settings", "Miscellaneous settings");
            Option.makeOptionHeader("swap-command", "The /origin swap command, allowing players to switch origin at will");
            Option.makeOptionHeader("swap-command.vault", "Charge players using Vault to switch their origins");
            Option.makeOptionHeader("origin-selection", "Settings for origin selection");
            Option.makeOptionHeader("origin-selection.random-option", "Allows the player to pick a 'Random' option");
            Option.makeOptionHeader("origin-selection.screen-title", "Prefixes and suffixes for the selection screen title");
            Option.makeOptionHeader("orb-of-origin", "Settings for the Orb of Origin");
            Option.makeOptionHeader("resource-pack", "Settings for the resource pack");
            Option.makeOptionHeader("display", "Miscellaneous display options");
            Option.makeOptionHeader("restrictions", List.of("Restrictions placed on origin selection", "These are designed for use with addon plugins that add many new origins", "If you run out of origins that fit the restrictions you may experience issues"));
            Option.makeOptionHeader("geyser", "Settings for using GeyserMC");
            Option.makeOptionHeader("skinsrestorer-hook", "Enables abilities that change the player's skin (requires SkinsRestorer to work)");
            if (hasUpdated) {
                ConfigManager.saveConfig();
            }
        }

        Option(SettingType<T> settingType, String path, List<String> comments, T defaultValue) {
            options.put(path, this);
            this.type = settingType;
            this.path = path;
            this.comments = comments;
            this.defaultValue = defaultValue;
            if (!ConfigManager.getConfig().contains(path)) {
                hasUpdated = true;
                settingType.set(ConfigManager.getConfig(), path, defaultValue);
                ConfigManager.setComments(path, comments);
            }
        }

        Option(SettingType<T> settingType, String path, String comment, T defaultValue) {
            this(settingType, path, Collections.singletonList(comment), defaultValue);
        }

        public T getValue() {
            return this.type.get(ConfigManager.getConfig(), this.path);
        }

        public String getPath() {
            return this.path;
        }

        @ApiStatus.Internal
        public void setValue(Object value) {
            hasUpdated = true;
            this.type.set(ConfigManager.getConfig(), this.path, value);
            ConfigManager.setComments(this.path, this.comments);
        }

        public void resetValue() {
            hasUpdated = true;
            this.type.set(ConfigManager.getConfig(), this.path, this.defaultValue);
            ConfigManager.setComments(this.path, this.comments);
        }

        private static void makeOptionHeader(String path, List<String> comments) {
            if (!ConfigManager.getConfig().contains(path)) {
                ConfigManager.getConfig().set(path, (Object)"[Placeholder]");
                hasUpdated = true;
            }
            ConfigManager.setComments(path, comments);
        }

        private static void makeOptionHeader(String path, String comment) {
            Option.makeOptionHeader(path, Collections.singletonList(comment));
        }
    }

    public static interface SettingType<T> {
        public static final SettingType<String> STRING = ConfigurationSection::getString;
        public static final SettingType<List<String>> STRING_LIST = ConfigurationSection::getStringList;
        public static final SettingType<Map<String, List<String>>> MAP_STRING_TO_STRING_LIST = new SettingType<Map<String, List<String>>>(){

            @Override
            public Map<String, List<String>> get(ConfigurationSection config, String path) {
                HashMap<String, List<String>> result = new HashMap<String, List<String>>();
                ConfigurationSection section = config.getConfigurationSection(path);
                if (section == null) {
                    return Map.of();
                }
                for (String s : section.getKeys(false)) {
                    result.put(s, section.getStringList(s));
                }
                return result;
            }

            @Override
            public void set(ConfigurationSection config, String path, Map<String, List<String>> value) {
                for (String s : value.keySet()) {
                    config.set(path + "." + s, value.get(s));
                }
            }
        };
        public static final SettingType<Map<String, String>> MAP_STRING_TO_STRING = new SettingType<Map<String, String>>(){

            @Override
            public Map<String, String> get(ConfigurationSection config, String path) {
                HashMap<String, String> result = new HashMap<String, String>();
                ConfigurationSection section = config.getConfigurationSection(path);
                if (section == null) {
                    return Map.of();
                }
                for (String s : section.getKeys(false)) {
                    result.put(s, section.getString(s));
                }
                return result;
            }

            @Override
            public void set(ConfigurationSection config, String path, Map<String, String> value) {
                for (String s : value.keySet()) {
                    config.set(path + "." + s, (Object)value.get(s));
                }
            }
        };
        public static final SettingType<Map<String, Integer>> MAP_STRING_TO_INTEGER = new SettingType<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> get(ConfigurationSection config, String path) {
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                ConfigurationSection section = config.getConfigurationSection(path);
                if (section == null) {
                    return Map.of();
                }
                for (String s : section.getKeys(false)) {
                    result.put(s, section.getInt(s));
                }
                return result;
            }

            @Override
            public void set(ConfigurationSection config, String path, Map<String, Integer> value) {
                for (String s : value.keySet()) {
                    config.set(path + "." + s, (Object)value.get(s));
                }
            }
        };
        public static final SettingType<Map<String, Boolean>> MAP_STRING_TO_BOOLEAN = new SettingType<Map<String, Boolean>>(){

            @Override
            public Map<String, Boolean> get(ConfigurationSection config, String path) {
                HashMap<String, Boolean> result = new HashMap<String, Boolean>();
                ConfigurationSection section = config.getConfigurationSection(path);
                if (section == null) {
                    return Map.of();
                }
                for (String s : section.getKeys(false)) {
                    result.put(s, section.getBoolean(s));
                }
                return result;
            }

            @Override
            public void set(ConfigurationSection config, String path, Map<String, Boolean> value) {
                for (String s : value.keySet()) {
                    config.set(path + "." + s, (Object)value.get(s));
                }
            }
        };
        public static final SettingType<List<List<Material>>> MATERIAL_LIST_LIST = new SettingType<List<List<Material>>>(){

            @Override
            public List<List<Material>> get(ConfigurationSection config, String path) {
                ArrayList<List<Material>> result = new ArrayList<List<Material>>();
                List list = config.getList(path);
                if (list == null) {
                    return List.of();
                }
                for (Object s : list) {
                    ArrayList<Material> la = new ArrayList<Material>();
                    for (String str : (List)s) {
                        la.add(Material.matchMaterial((String)str));
                    }
                    result.add(la);
                }
                return result;
            }

            @Override
            public void set(ConfigurationSection config, String path, List<List<Material>> value) {
                ArrayList stringValues = new ArrayList();
                for (List<Material> materials : value) {
                    ArrayList<CallSite> strings = new ArrayList<CallSite>();
                    for (Material material : materials) {
                        strings.add((CallSite)((Object)("minecraft:" + material.toString().toLowerCase())));
                    }
                    stringValues.add(strings);
                }
                config.set(path, stringValues);
            }
        };
        public static final SettingType<List<Material>> MATERIAL_LIST = new SettingType<List<Material>>(){

            @Override
            public List<Material> get(ConfigurationSection config, String path) {
                ArrayList<Material> result = new ArrayList<Material>();
                for (String s : config.getStringList(path)) {
                    result.add(Material.matchMaterial((String)s));
                }
                return result;
            }

            @Override
            public void set(ConfigurationSection config, String path, List<Material> value) {
                ArrayList<CallSite> stringValues = new ArrayList<CallSite>();
                for (Material material : value) {
                    stringValues.add((CallSite)((Object)("minecraft:" + material.toString().toLowerCase())));
                }
                config.set(path, stringValues);
            }
        };
        public static final SettingType<Integer> INTEGER = ConfigurationSection::getInt;
        public static final SettingType<Float> FLOAT = (config, path) -> Float.valueOf((float)config.getDouble(path));
        public static final SettingType<Double> DOUBLE = ConfigurationSection::getDouble;
        public static final SettingType<Boolean> BOOLEAN = ConfigurationSection::getBoolean;

        public T get(ConfigurationSection var1, String var2);

        default public void set(ConfigurationSection config, String path, T value) {
            config.set(path, value);
        }
    }
}

