/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.util.config;

import com.starshootercity.OriginsReborn;
import com.starshootercity.util.AbilityRegister;
import com.starshootercity.util.config.ConfigManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class LegacyConfigUpdater {
    public static void updateConfig() {
        String version = LegacyConfigUpdater.getConfig().getString("config-version", "1.0.0");
        if (version.equals("1.0.0")) {
            File configFile = new File(OriginsReborn.getInstance().getDataFolder(), "config.yml");
            boolean ignored = configFile.delete();
            OriginsReborn.getInstance().saveDefaultConfig();
        }
        if (version.equals("2.0.0")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.0.3");
            LegacyConfigUpdater.getConfig().set("display.enable-prefixes", (Object)false);
            LegacyConfigUpdater.setComments("display", List.of("Miscellaneous display options"));
            LegacyConfigUpdater.setComments("display.enable-prefixes", List.of("Enable prefixes in tab and on display names with the names of origins"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.0.3")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.1.7");
            LegacyConfigUpdater.getConfig().set("restrictions.reusing-origins", (Object)"NONE");
            LegacyConfigUpdater.getConfig().set("restrictions.prevent-same-origins", (Object)false);
            LegacyConfigUpdater.setComments("restrictions", List.of("Restrictions placed on origin selection", "These are designed for use with addon plugins that add many new origins", "If you run out of origins that fit the restrictions you may experience issues"));
            LegacyConfigUpdater.setComments("restrictions.reusing-origins", List.of("Rule for reusing origins", "\"NONE\" allows origins to be reused", "\"PERPLAYER\" means individual players can only use an origin once", "\"ALL\" means no players can use an origin again after one has selected it"));
            LegacyConfigUpdater.setComments("restrictions.prevent-same-origins", List.of("Prevent players from having the same origins as other players", "This is locked on if reusing-origins is set to ALL"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.1.7") || version.equals("2.1.10")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.1.11");
            LegacyConfigUpdater.getConfig().set("worlds.disabled-worlds", List.of("example_world"));
            LegacyConfigUpdater.setComments("worlds.disabled-worlds", List.of("Worlds to disable origins in"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.1.14")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.1.11");
            LegacyConfigUpdater.setComments("origin-selection.show-initial-gui", null);
            LegacyConfigUpdater.getConfig().set("origin-selection.show-initial-gui", null);
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.1.11")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.1.16");
            LegacyConfigUpdater.getConfig().set("origin-selection.auto-spawn-teleport", (Object)true);
            LegacyConfigUpdater.setComments("origin-selection.auto-spawn-teleport", List.of("Automatically teleport players to the world spawn when first selecting an origin"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.1.16")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.1.17");
            LegacyConfigUpdater.getConfig().set("origin-selection.invulnerable-mode", (Object)"OFF");
            LegacyConfigUpdater.setComments("origin-selection.invulnerable-mode", List.of("OFF - you can take damage with the origin selection GUI open", "ON - you cannot take damage with the origin selection GUI open", "INITIAL - you cannot take damage if you do not have an origin (and therefore cannot close the screen)"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.1.17")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.1.18");
            LegacyConfigUpdater.getConfig().set("origin-selection.screen-title.prefix", (Object)"");
            LegacyConfigUpdater.getConfig().set("origin-selection.screen-title.suffix", (Object)"");
            LegacyConfigUpdater.setComments("origin-selection.screen-title.prefix", List.of("Prefix of GUI title"));
            LegacyConfigUpdater.setComments("origin-selection.screen-title.suffix", List.of("Suffix of GUI title"));
            LegacyConfigUpdater.setComments("origin-selection.screen-title", List.of("Prefixes and suffixes for the selection screen title", "This is an advanced setting - only use it if you know how"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.1.18")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.1.19");
            LegacyConfigUpdater.getConfig().set("origin-selection.screen-title.background", (Object)"");
            LegacyConfigUpdater.setComments("origin-selection.screen-title.background", List.of("Background, between Origins-Reborn background and things like text"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.1.19") || version.equals("2.1.20")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.2.3");
            LegacyConfigUpdater.getConfig().set("misc-settings.disable-flight-stuff", (Object)false);
            LegacyConfigUpdater.setComments("misc-settings", List.of("Miscellaneous settings"));
            LegacyConfigUpdater.setComments("misc-settings.disable-flight-stuff", List.of("Disable all flight-related features. This does not hide the abilities themselves, they must be removed from the .yml files in the ~/plugins/Origins-Reborn/origins/ folder"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.2.3")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.2.5");
            LegacyConfigUpdater.getConfig().set("geyser.join-form-delay", (Object)20);
            LegacyConfigUpdater.setComments("geyser", List.of("Settings for using GeyserMC"));
            LegacyConfigUpdater.setComments("geyser.join-form-delay", List.of("The delay in ticks to wait before showing a new Bedrock player the selection GUI"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.2.5")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.2.18");
            LegacyConfigUpdater.getConfig().set("swap-command.vault.default-cost", (Object)LegacyConfigUpdater.getConfig().getInt("swap-command.vault.cost", 1000));
            LegacyConfigUpdater.setComments("swap-command.vault.cost", null);
            LegacyConfigUpdater.getConfig().set("swap-command.vault.cost", null);
            LegacyConfigUpdater.setComments("swap-command.vault.default-cost", List.of("Default cost of switching origin, if it hasn't been overriden in the origin file"));
            LegacyConfigUpdater.getConfig().set("origin-selection.default-origin", (Object)"NONE");
            LegacyConfigUpdater.setComments("origin-selection.default-origin", List.of("Default origin, automatically gives players this origin rather than opening the GUI when the player has no origin", "Should be the name of the origin file without the ending, e.g. for 'origin_name.json' the value should be 'origin_name'", "Disabled if set to an invalid name such as \"NONE\""));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.2.18")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.2.20");
            LegacyConfigUpdater.getConfig().set("swap-command.vault.permanent-purchases", (Object)false);
            LegacyConfigUpdater.setComments("swap-command.vault.permanent-purchases", List.of("Allows the player to switch back to origins for free if they already had the origin before"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.2.20")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.3.0");
            LegacyConfigUpdater.getConfig().set("cooldowns.disable-all-cooldowns", (Object)false);
            LegacyConfigUpdater.getConfig().set("cooldowns.show-cooldown-icons", (Object)true);
            LegacyConfigUpdater.setComments("cooldowns", List.of("Configuration for cooldowns"));
            LegacyConfigUpdater.setComments("cooldowns.disable-all-cooldowns", List.of("Disables every cooldown", " To modify specific cooldowns, edit the cooldown-config.yml file"));
            LegacyConfigUpdater.setComments("cooldowns.show-cooldown-icons", List.of("Use the actionbar to show cooldown icons", "You may want to disable this if using another plugin that requires the actionbar"));
            LegacyConfigUpdater.setComments("resource-pack.enabled", List.of("Whether to enable the resource pack", "If this is set to false you should send the pack to players either in server.properties or in another plugin", "You can find the packs for each version on the GitHub at https://github.com/cometcake575/Origins-Reborn/tree/main/packs/"));
            LegacyConfigUpdater.getConfig().set("resource-pack.link", null);
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.3.0")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.3.14");
            LegacyConfigUpdater.getConfig().set("commands-on-origin.example", List.of("example %player%", "example %uuid%"));
            LegacyConfigUpdater.setComments("commands-on-origin.example", List.of("Example configuration for a command on origin switch"));
            LegacyConfigUpdater.setComments("commands-on-origin", List.of("Runs commands when the player switches to an origin", "Origins should be formatted as they are in the file names, but without the extension, e.g. \"human\"", "%player% is replaced with the player's username and %uuid% is replaced with their UUID"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.3.14")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.3.17");
            LegacyConfigUpdater.setComments("commands-on-origin", List.of("Runs commands when the player switches to an origin", "Origins should be formatted as they are in the file names, but without the extension, e.g. \"human\"", "%player% is replaced with the player's username and %uuid% is replaced with their UUID", "Use \"default\" for commands that should be run regardless of origin"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.3.15") || version.equals("2.3.17")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.3.18");
            LegacyConfigUpdater.getConfig().set("prevent-abilities-in.no_water_breathing", List.of("origins:water_breathing"));
            LegacyConfigUpdater.getConfig().set("prevent-abilities-in.no_abilities", List.of("all"));
            LegacyConfigUpdater.setComments("prevent-abilities-in.no_water_breathing", List.of("Example region in which the water breathing ability is disabled"));
            LegacyConfigUpdater.setComments("prevent-abilities-in.no_abilities", List.of("Example region where all abilities are disabled"));
            LegacyConfigUpdater.setComments("prevent-abilities-in", List.of("A list of WorldGuard regions in which to prevent the use of certain abilities, use 'all' for all abilities"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.3.18")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.3.20");
            LegacyConfigUpdater.getConfig().set("orb-of-origin.random", (Object)false);
            LegacyConfigUpdater.setComments("orb-of-origin.random", List.of("Randomise origin instead of opening the selector upon using the orb"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.3.20")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.4.0");
            LegacyConfigUpdater.getConfig().set("origin-selection.default-origin.origin", LegacyConfigUpdater.getConfig().get("origin-selection.default-origin"));
            LegacyConfigUpdater.getConfig().set("origin-selection.layer-orders.origin", (Object)1);
            LegacyConfigUpdater.setComments("origin-selection.default-origin", List.of("Default origin, automatically gives players this origin rather than opening the GUI when the player has no origin", "Should be the name of the origin file without the ending, e.g. for 'origin_name.json' the value should be 'origin_name'", "Disabled if set to an invalid name such as \"NONE\""));
            LegacyConfigUpdater.setComments("origin-section.layer-orders", List.of("Priorities for different origin 'layers' to be selected in, higher priority layers are selected first."));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.4.0")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.4.1");
            LegacyConfigUpdater.getConfig().set("orb-of-origin.random.origin", LegacyConfigUpdater.getConfig().get("orb-of-origin.random"));
            LegacyConfigUpdater.getConfig().set("origin-selection.randomise.origin", LegacyConfigUpdater.getConfig().get("origin-selection.randomise"));
            LegacyConfigUpdater.setComments("orb-of-origin.random", List.of("Randomise origin instead of opening the selector upon using the orb"));
            LegacyConfigUpdater.setComments("origin-selection.randomise", List.of("Randomise origins instead of letting players pick"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.4.1")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.4.2");
            LegacyConfigUpdater.getConfig().set("origin-selection.delay-before-required", (Object)0);
            LegacyConfigUpdater.setComments("origin-selection.delay-before-required", List.of("The amount of time (in ticks, a tick is a 20th of a second) to wait between a player joining and when the GUI should open"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.4.2")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.5.0");
            int i = LegacyConfigUpdater.getConfig().getInt("extra-settings.fresh-air-required-sleep-height", 86);
            AbilityRegister.registerConfigOption(OriginsReborn.getInstance(), OriginsReborn.freshAir, ConfigManager.SettingType.INTEGER, "minimum_altitude", Collections.singletonList("Minimum altitude the player can sleep at"), i);
            LegacyConfigUpdater.getConfig().set("extra-settings", null);
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.5.0")) {
            LegacyConfigUpdater.getConfig().set("config-version", (Object)"2.5.5");
            LegacyConfigUpdater.getConfig().set("skinsrestorer-hook.enabled", (Object)false);
            LegacyConfigUpdater.getConfig().set("skinsrestorer-hook.ip", (Object)"UNSET");
            LegacyConfigUpdater.getConfig().set("skinsrestorer-hook.port", (Object)80);
            LegacyConfigUpdater.setComments("skinsrestorer-hook", Collections.singletonList("Enables abilities that change the player's skin (requires SkinsRestorer to work)"));
            LegacyConfigUpdater.setComments("skinsrestorer-hook.enabled", Collections.singletonList("Whether to enable the SkinsRestorer hook"));
            LegacyConfigUpdater.setComments("skinsrestorer-hook.ip", Collections.singletonList("The IP of your server, set this to your server's public IP (without the port)"));
            LegacyConfigUpdater.setComments("skinsrestorer-hook.port", Collections.singletonList("Set this to any other open port on the server, this is used to host the image of the skin, so it can be used by SkinsRestorer"));
            LegacyConfigUpdater.saveConfig();
        }
        if (version.equals("2.5.5")) {
            try {
                File toggleable;
                File characters;
                File langFolder;
                int i;
                YamlConfiguration config;
                File usedOrigins;
                File selectedOrigins;
                File internals = new File(OriginsReborn.getInstance().getDataFolder(), "internals");
                boolean ignored2 = internals.mkdirs();
                File inventories = new File(OriginsReborn.getInstance().getDataFolder(), "inventories.yml");
                if (inventories.exists()) {
                    Files.move(inventories.toPath(), Path.of(OriginsReborn.getInstance().getDataFolder().getPath(), "internals/inventories.yml"), new CopyOption[0]);
                }
                if ((selectedOrigins = new File(OriginsReborn.getInstance().getDataFolder(), "selected-origins.yml")).exists()) {
                    Files.move(selectedOrigins.toPath(), Path.of(OriginsReborn.getInstance().getDataFolder().getPath(), "internals/selected-origins.yml"), new CopyOption[0]);
                }
                if ((usedOrigins = new File(OriginsReborn.getInstance().getDataFolder(), "used-origins.yml")).exists()) {
                    Files.move(usedOrigins.toPath(), Path.of(OriginsReborn.getInstance().getDataFolder().getPath(), "internals/used-origins.yml"), new CopyOption[0]);
                }
                File cooldownConfig = new File(OriginsReborn.getInstance().getDataFolder(), "cooldown-config.yml");
                File attributeModifierAbilityConfig = new File(OriginsReborn.getInstance().getDataFolder(), "attribute-modifier-ability-config.yml");
                if (cooldownConfig.exists()) {
                    config = new YamlConfiguration();
                    config.load(cooldownConfig);
                    i = config.getInt("origins-reborn:swap-command-cooldown", -1);
                    LegacyConfigUpdater.getConfig().set("swap-command.cooldown", (Object)i);
                    LegacyConfigUpdater.setComments("swap-command.cooldown", Collections.singletonList("Cooldown for the command (in ticks), -1 means no cooldown"));
                    config.set("origins-reborn:swap-command-cooldown", null);
                    LegacyConfigUpdater.saveConfig();
                    for (String s : config.getKeys(false)) {
                        int amount = config.getInt(s);
                        if (amount == -1) continue;
                        String data = s.split(":")[1];
                        String string = data.replaceFirst("-", ":");
                        Key key = Key.key(string);
                        AbilityRegister.runOnRegisters.computeIfAbsent(key, k -> new ArrayList()).add(ability -> ability.registerConfigOption("cooldown-duration", Collections.singletonList("The duration of the cooldown (in ticks)"), ConfigManager.SettingType.INTEGER, amount));
                    }
                    boolean bl = cooldownConfig.delete();
                }
                if (attributeModifierAbilityConfig.exists()) {
                    config = new YamlConfiguration();
                    config.load(attributeModifierAbilityConfig);
                    for (String s : config.getKeys(false)) {
                        String value = config.getString(s + ".value", "x");
                        String operation = config.getString(s + ".operation", "default");
                        Key key = Key.key(s);
                        AbilityRegister.runOnRegisters.computeIfAbsent(key, k -> new ArrayList()).add(ability -> {
                            if (!operation.equals("default")) {
                                ability.registerConfigOption("attribute-modifier.operation", Collections.singletonList("The operation to use ('ADD_SCALAR', 'ADD_NUMBER' or 'MULTIPLY_SCALAR_1')"), ConfigManager.SettingType.STRING, operation);
                            }
                            ability.registerConfigOption("attribute-modifier.expression", List.of("A mathematical expression used to modify the attribute, where 'x' is a variable representing the default modifier.", "Example: 'x * 3' will triple the value used in the modifier."), ConfigManager.SettingType.STRING, value);
                        });
                    }
                    i = attributeModifierAbilityConfig.delete() ? 1 : 0;
                }
                if ((langFolder = new File(OriginsReborn.getInstance().getDataFolder(), "lang")).exists()) {
                    i = langFolder.delete() ? 1 : 0;
                }
                if ((characters = new File(OriginsReborn.getInstance().getDataFolder(), "characters.yml")).exists()) {
                    boolean s = characters.delete();
                }
                if ((toggleable = new File(OriginsReborn.getInstance().getDataFolder(), "toggleable-abilities.yml")).exists()) {
                    boolean value = toggleable.delete();
                }
                HashMap configBackup = new HashMap();
                for (ConfigManager.Option<?> option : ConfigManager.Option.getOptions().values()) {
                    configBackup.put(option.getPath(), option.getValue());
                }
                for (String s : LegacyConfigUpdater.getConfig().getKeys(false)) {
                    LegacyConfigUpdater.getConfig().set(s, null);
                }
                configBackup.remove("config-version");
                for (String s : ConfigManager.Option.getOptions().keySet()) {
                    if (configBackup.containsKey(s)) {
                        ConfigManager.Option.getOptions().get(s).setValue(configBackup.get(s));
                        continue;
                    }
                    ConfigManager.Option.getOptions().get(s).resetValue();
                }
                LegacyConfigUpdater.saveConfig();
            }
            catch (IOException | InvalidConfigurationException throwable) {
                // empty catch block
            }
        }
    }

    private static ConfigurationSection getConfig() {
        return OriginsReborn.getInstance().getConfig();
    }

    private static void saveConfig() {
        OriginsReborn.getInstance().saveConfig();
    }

    private static void setComments(String path, List<String> comments) {
        OriginsReborn.getInstance().setComments(path, comments);
    }
}

