/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity;

import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsAddon;
import com.starshootercity.OriginsReborn;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.papi.LayerPlaceholderExpansion;
import com.starshootercity.util.config.ConfigManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AddonLoader {
    private static final List<Origin> origins = new ArrayList<Origin>();
    private static final Map<String, Origin> originNameMap = new HashMap<String, Origin>();
    private static final Map<String, Origin> originFileNameMap = new HashMap<String, Origin>();
    public static final List<OriginsAddon> registeredAddons = new ArrayList<OriginsAddon>();
    public static Map<String, List<File>> originFiles = new HashMap<String, List<File>>();
    public static List<String> layers = new ArrayList<String>();
    public static Map<String, NamespacedKey> layerKeys = new HashMap<String, NamespacedKey>();
    private static final Random random = new Random();
    public static final List<OriginsAddon.SwapStateGetter> allowOriginSwapChecks = new ArrayList<OriginsAddon.SwapStateGetter>();
    public static final List<OriginsAddon.SwapStateGetter> openSwapMenuChecks = new ArrayList<OriginsAddon.SwapStateGetter>();
    public static final List<OriginsAddon.KeyStateGetter> abilityOverrideChecks = new ArrayList<OriginsAddon.KeyStateGetter>();
    private static final int BUFFER_SIZE = 4096;

    @Nullable
    public static String getFirstUnselectedLayer(Player player) {
        for (String layer : layers) {
            if (OriginSwapper.getOrigin(player, layer) != null) continue;
            return layer;
        }
        return null;
    }

    public static Origin getOrigin(String name) {
        return originNameMap.get(name);
    }

    public static Origin getOriginByFilename(String name) {
        return originFileNameMap.get(name);
    }

    public static List<Origin> getOrigins(String layer) {
        ArrayList<Origin> o = new ArrayList<Origin>(origins);
        o.removeIf(or -> !or.getLayer().equals(layer));
        return o;
    }

    public static Origin getFirstOrigin(String layer) {
        return AddonLoader.getOrigins(layer).get(0);
    }

    public static Origin getRandomOrigin(String layer) {
        List<Origin> o = AddonLoader.getOrigins(layer);
        return o.get(random.nextInt(o.size()));
    }

    public static void register(OriginsAddon addon) {
        if (registeredAddons.contains((Object)addon)) {
            registeredAddons.remove((Object)addon);
            origins.removeIf(origin -> origin.getAddon().getNamespace().equals(addon.getNamespace()));
        }
        registeredAddons.add(addon);
        AddonLoader.loadOriginsFor(addon);
        if (addon.shouldAllowOriginSwapCommand() != null) {
            allowOriginSwapChecks.add(addon.shouldAllowOriginSwapCommand());
        }
        if (addon.shouldOpenSwapMenu() != null) {
            openSwapMenuChecks.add(addon.shouldOpenSwapMenu());
        }
        if (addon.getAbilityOverride() != null) {
            abilityOverrideChecks.add(addon.getAbilityOverride());
        }
        AddonLoader.sortOrigins();
    }

    public static boolean shouldOpenSwapMenu(Player player, PlayerSwapOriginEvent.SwapReason reason) {
        for (OriginsAddon.SwapStateGetter getter : openSwapMenuChecks) {
            OriginsAddon.State v = getter.get(player, reason);
            if (v != OriginsAddon.State.DENY) continue;
            return false;
        }
        return true;
    }

    public static boolean allowOriginSwapCommand(Player player) {
        boolean allowed = false;
        for (OriginsAddon.SwapStateGetter getter : allowOriginSwapChecks) {
            OriginsAddon.State v = getter.get(player, PlayerSwapOriginEvent.SwapReason.COMMAND);
            if (v == OriginsAddon.State.DENY) {
                return false;
            }
            if (v != OriginsAddon.State.ALLOW) continue;
            allowed = true;
        }
        return allowed || player.hasPermission(ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_PERMISSION));
    }

    public static void reloadAddons() {
        origins.clear();
        originNameMap.clear();
        originFiles.clear();
        for (OriginsAddon addon : registeredAddons) {
            AddonLoader.loadOriginsFor(addon);
        }
        AddonLoader.sortOrigins();
    }

    public static void sortOrigins() {
        origins.sort((o1, o2) -> {
            if (o1.getImpact() == o2.getImpact()) {
                if (o1.getPosition() == o2.getPosition()) {
                    return 0;
                }
                return o1.getPosition() > o2.getPosition() ? 1 : -1;
            }
            return o1.getImpact() > o2.getImpact() ? 1 : -1;
        });
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        int read;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    private static void loadOriginsFor(OriginsAddon addon) {
        File[] files;
        ArrayList<File> addonFiles = new ArrayList<File>();
        originFiles.put(addon.getNamespace(), addonFiles);
        File originFolder = new File(addon.getDataFolder(), "origins");
        if (!originFolder.exists()) {
            boolean ignored = originFolder.mkdirs();
            try (ZipInputStream inputStream = new ZipInputStream(new FileInputStream(addon.getFile()));){
                ZipEntry entry = inputStream.getNextEntry();
                while (entry != null) {
                    if (entry.getName().startsWith("origins/") && entry.getName().endsWith(".json")) {
                        AddonLoader.extractFile(inputStream, originFolder.getParentFile().getAbsolutePath() + "/" + entry.getName());
                    }
                    entry = inputStream.getNextEntry();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((files = originFolder.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".json")) continue;
            addonFiles.add(file);
            try {
                AddonLoader.loadOrigin(file, addon);
            }
            catch (Exception e) {
                addon.getLogger().severe("An error has occurred when loading the origin %s".formatted(file.getName()));
                addon.getLogger().severe("Check that the json file is formatted correctly, and has all required settings listed at https://starshooter.gitbook.io/origins-reborn/custom-origins");
                addon.getLogger().severe("Join the Discord server at /origin discord for more help");
            }
        }
    }

    private static void sortLayers() {
        Map<String, Integer> data = ConfigManager.getConfigValue(ConfigManager.Option.ORIGIN_SELECTION_LAYER_ORDERS);
        layers.sort((o1, o2) -> {
            int a1 = (Integer)data.get(o1);
            int a2 = (Integer)data.get(o2);
            return a1 - a2;
        });
    }

    public static void registerLayer(String layer, int priority, OriginsAddon addon) {
        if (layers.contains(layer)) {
            return;
        }
        layers.add(layer);
        layerKeys.put(layer, new NamespacedKey((Plugin)addon, layer.toLowerCase().replace(" ", "_")));
        if (!OriginsReborn.getInstance().getConfig().contains("origin-selection.default-origin.%s".formatted(layer))) {
            OriginsReborn.getInstance().getConfig().set("origin-selection.default-origin.%s".formatted(layer), (Object)"NONE");
            OriginsReborn.getInstance().setComments("origin-selection.default-origin", List.of("Default origin, automatically gives players this origin rather than opening the GUI when the player has no origin", "Should be the name of the origin file without the ending, e.g. for 'origin_name.json' the value should be 'origin_name'", "Disabled if set to an invalid name such as \"NONE\""));
            OriginsReborn.getInstance().saveConfig();
        }
        if (!OriginsReborn.getInstance().getConfig().contains("origin-selection.layer-orders.%s".formatted(layer))) {
            OriginsReborn.getInstance().getConfig().set("origin-selection.layer-orders.%s".formatted(layer), (Object)priority);
            OriginsReborn.getInstance().setComments("origin-section.layer-orders", List.of("Priorities for different origin 'layers' to be selected in, higher priority layers are selected first."));
            OriginsReborn.getInstance().saveConfig();
        }
        if (!OriginsReborn.getInstance().getConfig().contains("orb-of-origin.random.%s".formatted(layer))) {
            OriginsReborn.getInstance().getConfig().set("orb-of-origin.random.%s".formatted(layer), (Object)false);
            OriginsReborn.getInstance().setComments("orb-of-origin.random", List.of("Randomise origin instead of opening the selector upon using the orb"));
            OriginsReborn.getInstance().saveConfig();
        }
        AddonLoader.sortLayers();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new LayerPlaceholderExpansion(layer).register();
        }
    }

    private static JSONObject openJSONFile(File file) {
        JSONObject jSONObject;
        Scanner scanner = new Scanner(file);
        StringBuilder data = new StringBuilder();
        while (scanner.hasNextLine()) {
            data.append(scanner.nextLine());
        }
        try {
            jSONObject = new JSONObject(data.toString());
        }
        catch (JSONException e) {
            try {
                JSONObject jSONObject2 = new JSONObject();
                scanner.close();
                return jSONObject2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        scanner.close();
        return jSONObject;
    }

    public static void loadOrigin(File file, OriginsAddon addon) {
        Material material;
        String itemName;
        if (!file.getName().toLowerCase().equals(file.getName())) {
            File lowercaseFile = new File(file.getParentFile(), file.getName().toLowerCase());
            if (!file.renameTo(lowercaseFile)) {
                OriginsReborn.getInstance().getLogger().warning("Origin %s failed to load - make sure file name is lowercase".formatted(file.getName()));
                return;
            }
            file = lowercaseFile;
        }
        final JSONObject object = AddonLoader.openJSONFile(file);
        String unchoosable = "false";
        if (object.has("unchoosable")) {
            unchoosable = String.valueOf(object.get("unchoosable"));
        }
        int cmd = 0;
        Object object2 = object.get("icon");
        if (object2 instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object2;
            itemName = jsonObject.getString("item");
            if (jsonObject.has("custom_model_data")) {
                cmd = jsonObject.getInt("custom_model_data");
            }
        } else {
            itemName = object.getString("icon");
        }
        if ((material = Material.matchMaterial((String)itemName)) == null) {
            material = Material.AIR;
        }
        ItemStack icon = new ItemStack(material);
        ItemMeta meta = icon.getItemMeta();
        meta = OriginsReborn.getMVE().setCustomModelData(meta, cmd);
        icon.setItemMeta(meta);
        String name = file.getName().split("\\.")[0];
        StringBuilder formattedName = new StringBuilder();
        String[] parts = name.split("_");
        int num = 0;
        for (String part : parts) {
            formattedName.append(part.substring(0, 1).toUpperCase()).append(part.substring(1));
            if (++num >= parts.length) continue;
            formattedName.append(" ");
        }
        String permission = null;
        Integer cost = null;
        int max = object.has("max") ? object.getInt("max") : ConfigManager.getConfigValue(ConfigManager.Option.MAX_SAME_ORIGIN).intValue();
        String layer = object.has("layer") ? object.getString("layer") : "origin";
        if (object.has("permission")) {
            permission = object.getString("permission");
        }
        if (object.has("cost")) {
            cost = object.getInt("cost");
        }
        int extraLayerPriority = 0;
        ConfigurationSection cs = OriginsReborn.getInstance().getConfig().getConfigurationSection("origin-selection.layers");
        if (cs != null) {
            for (String s : cs.getValues(false).keySet()) {
                extraLayerPriority = Math.min(extraLayerPriority, cs.getInt(s) - 1);
            }
        }
        AddonLoader.registerLayer(layer, extraLayerPriority, addon);
        String displayName = object.has("name") ? object.getString("name") : formattedName.toString();
        Origin origin = new Origin(formattedName.toString(), icon, object.getInt("order"), object.getInt("impact"), displayName, (List<Key>)new ArrayList<Key>(){
            {
                if (object.has("powers")) {
                    JSONArray array = object.getJSONArray("powers");
                    for (Object o : array) {
                        this.add(Key.key((String)o));
                    }
                }
            }
        }, object.getString("description"), addon, unchoosable, object.has("priority") ? object.getInt("priority") : 1, permission, cost, max, layer);
        String actualName = origin.getName().toLowerCase();
        Origin previouslyRegisteredOrigin = originNameMap.get(name.replace("_", " "));
        if (previouslyRegisteredOrigin != null) {
            if (previouslyRegisteredOrigin.getPriority() > origin.getPriority()) {
                return;
            }
            origins.remove(previouslyRegisteredOrigin);
            originNameMap.remove(name.replace("_", " "));
            originFileNameMap.remove(actualName);
        }
        origins.add(origin);
        originNameMap.put(name.replace("_", " "), origin);
        originFileNameMap.put(actualName, origin);
    }

    @Nullable
    public static Origin getDefaultOrigin(String layer) {
        String originName = OriginsReborn.getInstance().getConfig().getString("origin-selection.default-origin.%s".formatted(layer), "NONE");
        return originFileNameMap.getOrDefault(originName.replace("_", " "), null);
    }
}

