/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity;

import com.starshootercity.AddonLoader;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.Translator;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.util.config.ConfigManager;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class OrbOfOrigin
implements Listener {
    public static NamespacedKey orbKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "orb-of-origin");
    public static NamespacedKey updatedKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "updated-orb");
    public static ItemStack orb;

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        ItemMeta meta = event.getCurrentItem().getItemMeta();
        if (meta.getPersistentDataContainer().has(orbKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN) && !meta.getPersistentDataContainer().has(updatedKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN)) {
            event.getCurrentItem().setItemMeta(orb.getItemMeta());
        }
    }

    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (recipe != null && recipe.getResult().getType() == Material.CONDUIT) {
            for (ItemStack itemStack : event.getInventory().getMatrix()) {
                if (itemStack == null || itemStack.getItemMeta() == null || !itemStack.getItemMeta().getPersistentDataContainer().has(orbKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN)) continue;
                event.getInventory().setResult(null);
            }
        }
    }

    public OrbOfOrigin() {
        orb = new ItemStack(Material.NAUTILUS_SHELL);
        String orbOfOrigin = "item.orb_of_origin";
        String orbOfOriginDesc = "item.orb_of_origin_description";
        Translator.registerTranslation(orbOfOrigin, "Orb of Origin");
        Translator.registerTranslation(orbOfOriginDesc, "");
        ItemMeta meta = orb.getItemMeta();
        meta.getPersistentDataContainer().set(orbKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN, (Object)true);
        meta.getPersistentDataContainer().set(updatedKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN, (Object)true);
        meta = OriginsReborn.getMVE().setCustomModelData(meta, 1);
        meta.displayName(((TextComponent)Component.text(Translator.translate(orbOfOrigin)).color(NamedTextColor.AQUA)).decoration(TextDecoration.ITALIC, false));
        String desc = Translator.translate(orbOfOriginDesc);
        if (!desc.isBlank()) {
            meta.lore(List.of(((TextComponent)Component.text(desc).color(NamedTextColor.AQUA)).decoration(TextDecoration.ITALIC, false)));
        }
        orb.setItemMeta(meta);
        Bukkit.removeRecipe((NamespacedKey)orbKey);
        FileConfiguration config = OriginsReborn.getInstance().getConfig();
        if (config.getBoolean("orb-of-origin.enable-recipe")) {
            ShapedRecipe shapedRecipe = new ShapedRecipe(orbKey, orb);
            shapedRecipe.shape(new String[]{"012", "345", "678"});
            int i = 0;
            List recipeData = config.getList("orb-of-origin.recipe");
            if (recipeData == null) {
                return;
            }
            for (Object line : recipeData) {
                for (String name : (List)line) {
                    Material material = Material.matchMaterial((String)name);
                    if (material == null) {
                        material = Material.AIR;
                    }
                    if (material == Material.AIR) {
                        ++i;
                        continue;
                    }
                    shapedRecipe.setIngredient(String.valueOf(i).charAt(0), material);
                    ++i;
                }
            }
            Bukkit.addRecipe((Recipe)shapedRecipe);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() != null && event.getClickedBlock().getType().isInteractable()) {
            return;
        }
        if (!event.getAction().isRightClick()) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.getPersistentDataContainer().has(orbKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN)) {
            if (OriginSwapper.orbCooldown.containsKey(event.getPlayer()) && System.currentTimeMillis() - OriginSwapper.orbCooldown.get(event.getPlayer()) < 500L) {
                return;
            }
            ItemMeta heldMeta = event.getPlayer().getInventory().getItemInMainHand().getItemMeta();
            EquipmentSlot hand = EquipmentSlot.OFF_HAND;
            if (heldMeta != null && heldMeta.getPersistentDataContainer().has(orbKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN)) {
                hand = EquipmentSlot.HAND;
            }
            if (hand == EquipmentSlot.HAND) {
                event.getPlayer().swingMainHand();
            } else {
                event.getPlayer().swingOffHand();
            }
            if (ConfigManager.getConfigValue(ConfigManager.Option.ORB_OF_ORIGIN_CONSUME).booleanValue()) {
                item.setAmount(item.getAmount() - 1);
                event.getPlayer().getInventory().setItemInMainHand(item);
            }
            boolean opened = false;
            for (String layer : AddonLoader.layers) {
                event.getPlayer().getPersistentDataContainer().set(OriginSwapper.awaitingOriginChangeKey, (PersistentDataType)OriginSwapper.BooleanPDT.BOOLEAN, (Object)true);
                OriginSwapper.setOrigin(event.getPlayer(), null, PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN, false, layer);
                if (opened) continue;
                if (OriginsReborn.getInstance().getConfig().getBoolean("orb-of-origin.random.%s".formatted(layer))) {
                    OriginSwapper.selectRandomOrigin(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN, layer);
                    OriginSwapper.openOriginSwapper(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN, AddonLoader.getOrigins(layer).indexOf(OriginSwapper.getOrigin(event.getPlayer(), layer)), 0, false, true, layer);
                } else {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> OriginSwapper.openOriginSwapper(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN, 0, 0, true, layer));
                }
                opened = true;
            }
        }
    }
}

