/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.AddonLoader;
import com.starshootercity.OrbOfOrigin;
import com.starshootercity.Origin;
import com.starshootercity.OriginsReborn;
import com.starshootercity.Translator;
import com.starshootercity.abilities.types.Ability;
import com.starshootercity.abilities.types.AttributeModifierAbility;
import com.starshootercity.abilities.types.DefaultSpawnAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.commands.OriginCommand;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.geysermc.GeyserSwapper;
import com.starshootercity.util.AbilityRegister;
import com.starshootercity.util.Pair;
import com.starshootercity.util.ShortcutUtils;
import com.starshootercity.util.VaultHook;
import com.starshootercity.util.config.ConfigManager;
import com.starshootercity.version.MVAccessor;
import com.starshootercity.version.MVAttribute;
import fr.xephi.authme.api.v3.AuthMeApi;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OriginSwapper
implements Listener {
    private static final NamespacedKey displayKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "displayed-item");
    private static final NamespacedKey layerKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "layer");
    private static final NamespacedKey confirmKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "confirm-select");
    private static final NamespacedKey costsCurrencyKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "costs-currency");
    private static final NamespacedKey originKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "origin-name");
    private static final NamespacedKey swapTypeKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "swap-type");
    private static final NamespacedKey pageSetKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "page-set");
    private static final NamespacedKey pageScrollKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "page-scroll");
    private static final NamespacedKey costKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "enable-cost");
    private static final NamespacedKey displayOnlyKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "display-only");
    private static final NamespacedKey closeKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "close");
    public static final NamespacedKey awaitingOriginChangeKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "awaiting_origin_change");
    private static final Random random = new Random();
    private static final Map<UUID, Map<String, Origin>> origins = new HashMap<UUID, Map<String, Origin>>();
    public static Map<Player, Long> orbCooldown = new HashMap<Player, Long>();
    private static final Map<Player, PlayerSwapOriginEvent.SwapReason> lastSwapReasons = new HashMap<Player, PlayerSwapOriginEvent.SwapReason>();
    private static final Map<Player, Integer> lastJoinedTick = new HashMap<Player, Integer>();
    private static final Map<Player, Boolean> invisible = new HashMap<Player, Boolean>();
    private final Map<Player, Set<PlayerRespawnEvent.RespawnFlag>> lastRespawnReasons = new HashMap<Player, Set<PlayerRespawnEvent.RespawnFlag>>();
    private static File originFile;
    private static FileConfiguration originFileConfiguration;
    private static File usedOriginFile;
    private static FileConfiguration usedOriginFileConfiguration;
    private final String invulnerableMode;
    private static final String randomName = "random-origin.name";
    private static final String randomDescription = "random-origin.description";
    private static final String nextGUI = "gui.next";
    private static final String prevGUI = "gui.previous";
    private static final String confirmGUI = "gui.confirm";
    private static final String upGUI = "gui.up";
    private static final String downGUI = "gui.down";
    private static final String confirmSwapGUI = "gui.confirm_swap";

    public static String getInverse(String string) {
        StringBuilder result = new StringBuilder();
        for (char c : string.toCharArray()) {
            result.append(OriginSwapper.getInverse(c));
        }
        return result.toString();
    }

    public static void openOriginSwapper(Player player, PlayerSwapOriginEvent.SwapReason reason, int slot, int scrollAmount, String layer) {
        OriginSwapper.openOriginSwapper(player, reason, slot, scrollAmount, false, false, layer);
    }

    public static void openOriginSwapper(Player player, PlayerSwapOriginEvent.SwapReason reason, int slot, int scrollAmount, boolean cost, String layer) {
        OriginSwapper.openOriginSwapper(player, reason, slot, scrollAmount, cost, false, layer);
    }

    /*
     * WARNING - void declaration
     */
    public static void openOriginSwapper(Player player, PlayerSwapOriginEvent.SwapReason reason, int slot, int scrollAmount, boolean cost, boolean displayOnly, String layer) {
        if (OriginSwapper.shouldDisallowSelection(player, reason)) {
            return;
        }
        lastSwapReasons.put(player, reason);
        boolean enableRandom = OriginsReborn.getInstance().getConfig().getBoolean("origin-selection.random-option.enabled");
        if (GeyserSwapper.checkBedrockSwap(player, reason, cost, displayOnly, layer)) {
            void var18_18;
            LineData data;
            char impact;
            String nameForDisplay;
            String name;
            ItemStack icon;
            Object excludedOriginNames;
            if (AddonLoader.getOrigins(layer).isEmpty()) {
                return;
            }
            ArrayList<Origin> origins = new ArrayList<Origin>(AddonLoader.getOrigins(layer));
            if (!displayOnly) {
                origins.removeIf(origin -> origin.isUnchoosable(player) || origin.hasPermission() && !player.hasPermission(origin.getPermission()));
            }
            while (slot > origins.size() || slot == origins.size() && !enableRandom) {
                slot -= origins.size() + (enableRandom ? 1 : 0);
            }
            while (slot < 0) {
                slot += origins.size() + (enableRandom ? 1 : 0);
            }
            int amount = ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_VAULT_DEFAULT_COST);
            if (slot == origins.size()) {
                List<String> excludedOrigins = ConfigManager.getConfigValue(ConfigManager.Option.ORIGIN_SELECTION_RANDOM_OPTION_EXCLUDE);
                excludedOriginNames = new ArrayList<String>();
                for (String string : excludedOrigins) {
                    Origin origin2 = AddonLoader.getOriginByFilename(string);
                    if (origin2 == null) continue;
                    excludedOriginNames.add(origin2.getName());
                }
                icon = OrbOfOrigin.orb.clone();
                name = "random";
                nameForDisplay = Translator.translate(randomName);
                impact = '\ue002';
                StringBuilder names = new StringBuilder("%s\n\n".formatted(Translator.translate(randomDescription)));
                for (Origin origin3 : AddonLoader.getOrigins(layer)) {
                    if (origin3.isUnchoosable(player, true) || excludedOriginNames.contains(origin3.getName())) continue;
                    names.append(origin3.getName()).append("\n");
                }
                data = new LineData(LineData.makeLineFor(names.toString(), LineData.LineComponent.LineType.DESCRIPTION));
            } else {
                Origin origin3 = (Origin)origins.get(slot);
                icon = origin3.getIcon();
                name = origin3.getName();
                nameForDisplay = origin3.getNameForDisplay();
                impact = origin3.getImpact();
                data = new LineData(origin3);
                if (origin3.getCost() != null) {
                    amount = origin3.getCost();
                }
            }
            StringBuilder compressedName = new StringBuilder("\uf001");
            excludedOriginNames = nameForDisplay.toCharArray();
            int names = ((Object)excludedOriginNames).length;
            boolean bl = false;
            while (var18_18 < names) {
                Object object = excludedOriginNames[var18_18];
                if (object == 32) {
                    object = 61439;
                }
                compressedName.append((char)object);
                compressedName.append('\uf000');
                ++var18_18;
            }
            Component background = OriginSwapper.applyFont(ShortcutUtils.getColored(ConfigManager.getConfigValue(ConfigManager.Option.ORIGIN_SELECTION_SCREEN_TITLE_BACKGROUND)), Key.key("minecraft:default"));
            Component component = OriginSwapper.applyFont(Component.text("\uf000\ue000\uf001\ue001\uf002" + impact), Key.key("minecraft:origin_selector")).color(NamedTextColor.WHITE).append(background).append(OriginSwapper.applyFont(Component.text(compressedName.toString()), Key.key("minecraft:origin_title_text")).color(NamedTextColor.WHITE)).append(OriginSwapper.applyFont(Component.text(OriginSwapper.getInverse(nameForDisplay) + "\uf000"), Key.key("minecraft:reverse_text")).color(NamedTextColor.WHITE));
            for (Component component2 : data.getLines(scrollAmount)) {
                component = component.append(component2);
            }
            Component component3 = OriginSwapper.applyFont(ShortcutUtils.getColored(ConfigManager.getConfigValue(ConfigManager.Option.ORIGIN_SELECTION_SCREEN_TITLE_PREFIX)), Key.key("minecraft:default"));
            Component component4 = OriginSwapper.applyFont(ShortcutUtils.getColored(ConfigManager.getConfigValue(ConfigManager.Option.ORIGIN_SELECTION_SCREEN_TITLE_SUFFIX)), Key.key("minecraft:default"));
            Inventory swapperInventory = Bukkit.createInventory(null, (int)54, (Component)component3.append(component).append(component4));
            ItemMeta meta = icon.getItemMeta();
            meta.getPersistentDataContainer().set(originKey, PersistentDataType.STRING, (Object)name.toLowerCase());
            if (meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                skullMeta.setOwningPlayer((OfflinePlayer)player);
            }
            meta.getPersistentDataContainer().set(displayKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)true);
            meta.getPersistentDataContainer().set(swapTypeKey, PersistentDataType.STRING, (Object)reason.getReason());
            meta.getPersistentDataContainer().set(layerKey, PersistentDataType.STRING, (Object)layer);
            icon.setItemMeta(meta);
            swapperInventory.setItem(1, icon);
            ItemStack confirm = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            ItemStack invisibleConfirm = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            ItemMeta confirmMeta = confirm.getItemMeta();
            ItemMeta invisibleConfirmMeta = invisibleConfirm.getItemMeta();
            confirmMeta.displayName(((TextComponent)Component.text(Translator.translate(confirmGUI)).color(NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
            confirmMeta = OriginsReborn.getMVE().setCustomModelData(confirmMeta, 5);
            if (!displayOnly) {
                confirmMeta.getPersistentDataContainer().set(confirmKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)true);
            } else {
                confirmMeta.getPersistentDataContainer().set(closeKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)true);
            }
            invisibleConfirmMeta.displayName(((TextComponent)Component.text(Translator.translate(confirmGUI)).color(NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
            invisibleConfirmMeta = OriginsReborn.getMVE().setCustomModelData(invisibleConfirmMeta, 6);
            if (!displayOnly) {
                invisibleConfirmMeta.getPersistentDataContainer().set(confirmKey, PersistentDataType.INTEGER, (Object)1);
            } else {
                invisibleConfirmMeta.getPersistentDataContainer().set(closeKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)true);
            }
            if (OriginsReborn.getInstance().isVaultEnabled() && amount != 0 && cost && !player.hasPermission(OriginsReborn.getInstance().getConfig().getString("swap-command.vault.bypass-permission", "originsreborn.costbypass"))) {
                boolean go = true;
                if (ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_VAULT_PERMANENT_PURCHASES).booleanValue()) {
                    boolean bl2 = go = !OriginSwapper.getUsedOriginFileConfiguration().getStringList(player.getUniqueId().toString()).contains(name.toLowerCase());
                }
                if (go) {
                    String symbol = OriginsReborn.getInstance().getConfig().getString("swap-command.vault.currency-symbol", "$");
                    List<TextComponent> costsCurrency = List.of(Component.text((VaultHook.has(player, amount) ? "This will cost %s%s of your balance!" : "You need at least %s%s in your balance to do this!").formatted(symbol, amount)));
                    confirmMeta.lore(costsCurrency);
                    invisibleConfirmMeta.lore(costsCurrency);
                    confirmMeta.getPersistentDataContainer().set(costsCurrencyKey, PersistentDataType.INTEGER, (Object)amount);
                    invisibleConfirmMeta.getPersistentDataContainer().set(costsCurrencyKey, PersistentDataType.INTEGER, (Object)amount);
                }
            }
            ItemStack up = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            ItemStack down = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            ItemMeta upMeta = up.getItemMeta();
            ItemMeta downMeta = down.getItemMeta();
            int scrollSize = OriginsReborn.getInstance().getConfig().getInt("origin-selection.scroll-amount", 1);
            upMeta.displayName(((TextComponent)Component.text(Translator.translate(upGUI)).color(NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
            if (scrollAmount != 0) {
                upMeta.getPersistentDataContainer().set(pageSetKey, PersistentDataType.INTEGER, (Object)slot);
                upMeta.getPersistentDataContainer().set(pageScrollKey, PersistentDataType.INTEGER, (Object)Math.max(scrollAmount - scrollSize, 0));
            }
            upMeta = OriginsReborn.getMVE().setCustomModelData(upMeta, 3 + (scrollAmount == 0 ? 6 : 0));
            upMeta.getPersistentDataContainer().set(costKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)cost);
            upMeta.getPersistentDataContainer().set(displayOnlyKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)displayOnly);
            int size = data.lines.size() - scrollAmount - 6;
            boolean canGoDown = size > 0;
            downMeta.displayName(((TextComponent)Component.text(Translator.translate(downGUI)).color(NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
            if (canGoDown) {
                downMeta.getPersistentDataContainer().set(pageSetKey, PersistentDataType.INTEGER, (Object)slot);
                downMeta.getPersistentDataContainer().set(pageScrollKey, PersistentDataType.INTEGER, (Object)Math.min(scrollAmount + scrollSize, scrollAmount + size));
            }
            downMeta = OriginsReborn.getMVE().setCustomModelData(downMeta, 4 + (!canGoDown ? 6 : 0));
            downMeta.getPersistentDataContainer().set(costKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)cost);
            downMeta.getPersistentDataContainer().set(displayOnlyKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)displayOnly);
            up.setItemMeta(upMeta);
            down.setItemMeta(downMeta);
            swapperInventory.setItem(52, up);
            swapperInventory.setItem(53, down);
            if (!displayOnly) {
                ItemStack left = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
                ItemStack right = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
                ItemMeta leftMeta = left.getItemMeta();
                ItemMeta rightMeta = right.getItemMeta();
                leftMeta.displayName(((TextComponent)Component.text(Translator.translate(prevGUI)).color(NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
                leftMeta.getPersistentDataContainer().set(pageSetKey, PersistentDataType.INTEGER, (Object)(slot - 1));
                leftMeta.getPersistentDataContainer().set(pageScrollKey, PersistentDataType.INTEGER, (Object)0);
                leftMeta = OriginsReborn.getMVE().setCustomModelData(leftMeta, 1);
                leftMeta.getPersistentDataContainer().set(costKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)cost);
                leftMeta.getPersistentDataContainer().set(displayOnlyKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)false);
                rightMeta.displayName(((TextComponent)Component.text(Translator.translate(nextGUI)).color(NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
                rightMeta.getPersistentDataContainer().set(pageSetKey, PersistentDataType.INTEGER, (Object)(slot + 1));
                rightMeta.getPersistentDataContainer().set(pageScrollKey, PersistentDataType.INTEGER, (Object)0);
                rightMeta = OriginsReborn.getMVE().setCustomModelData(rightMeta, 2);
                rightMeta.getPersistentDataContainer().set(costKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)cost);
                rightMeta.getPersistentDataContainer().set(displayOnlyKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)false);
                left.setItemMeta(leftMeta);
                right.setItemMeta(rightMeta);
                swapperInventory.setItem(47, left);
                swapperInventory.setItem(51, right);
            }
            confirm.setItemMeta(confirmMeta);
            invisibleConfirm.setItemMeta(invisibleConfirmMeta);
            swapperInventory.setItem(48, confirm);
            swapperInventory.setItem(49, invisibleConfirm);
            swapperInventory.setItem(50, invisibleConfirm);
            player.openInventory(swapperInventory);
        }
    }

    public static Component applyFont(Component component, Key font) {
        return OriginsReborn.getMVE().applyFont(component, font);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack item = ShortcutUtils.getTopInventory(event.getWhoClicked()).getItem(1);
        if (item != null) {
            if (item.getItemMeta() == null) {
                return;
            }
            if (item.getItemMeta().getPersistentDataContainer().has(displayKey, (PersistentDataType)BooleanPDT.BOOLEAN)) {
                event.setCancelled(true);
            }
            String layer = (String)item.getItemMeta().getPersistentDataContainer().getOrDefault(layerKey, PersistentDataType.STRING, (Object)"origin");
            HumanEntity humanEntity = event.getWhoClicked();
            if (humanEntity instanceof Player) {
                Player player = (Player)humanEntity;
                ItemStack currentItem = event.getCurrentItem();
                if (currentItem == null || currentItem.getItemMeta() == null) {
                    return;
                }
                Integer page = (Integer)currentItem.getItemMeta().getPersistentDataContainer().get(pageSetKey, PersistentDataType.INTEGER);
                if (page != null) {
                    boolean cost = (Boolean)currentItem.getItemMeta().getPersistentDataContainer().getOrDefault(costKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)false);
                    boolean allowUnchoosable = (Boolean)currentItem.getItemMeta().getPersistentDataContainer().getOrDefault(displayOnlyKey, (PersistentDataType)BooleanPDT.BOOLEAN, (Object)false);
                    Integer scroll = (Integer)currentItem.getItemMeta().getPersistentDataContainer().get(pageScrollKey, PersistentDataType.INTEGER);
                    if (scroll == null) {
                        return;
                    }
                    player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, SoundCategory.MASTER, 1.0f, 1.0f);
                    OriginSwapper.openOriginSwapper(player, this.getReason(item), page, scroll, cost, allowUnchoosable, layer);
                }
                if (currentItem.getItemMeta().getPersistentDataContainer().has(confirmKey, PersistentDataType.INTEGER)) {
                    Origin origin;
                    if (ConfigManager.getConfigValue(ConfigManager.Option.ORIGIN_SELECTION_CONFIRM_SELECTION).booleanValue() && (Integer)currentItem.getItemMeta().getPersistentDataContainer().getOrDefault(confirmKey, PersistentDataType.INTEGER, (Object)1) == 1) {
                        ItemMeta meta = currentItem.getItemMeta();
                        meta.getPersistentDataContainer().set(confirmKey, PersistentDataType.INTEGER, (Object)2);
                        currentItem.setItemMeta(meta);
                        player.sendMessage(Component.text(Translator.translate(confirmSwapGUI)).color(NamedTextColor.RED));
                        return;
                    }
                    String originName = (String)item.getItemMeta().getPersistentDataContainer().get(originKey, PersistentDataType.STRING);
                    if (originName == null) {
                        return;
                    }
                    if (originName.equalsIgnoreCase("random")) {
                        List<String> excludedOrigins = ConfigManager.getConfigValue(ConfigManager.Option.ORIGIN_SELECTION_RANDOM_OPTION_EXCLUDE);
                        ArrayList<Origin> origins = new ArrayList<Origin>(AddonLoader.getOrigins(layer));
                        origins.removeIf(origin1 -> excludedOrigins.contains(origin1.getName()));
                        origins.removeIf(origin1 -> origin1.isUnchoosable(player, true));
                        origin = origins.isEmpty() ? AddonLoader.getFirstOrigin(layer) : (Origin)origins.get(random.nextInt(origins.size()));
                    } else {
                        origin = AddonLoader.getOrigin(originName);
                    }
                    int amount = OriginsReborn.getInstance().getConfig().getInt("swap-command.vault.cost", 1000);
                    if (!player.hasPermission(OriginsReborn.getInstance().getConfig().getString("swap-command.vault.bypass-permission", "originsreborn.costbypass")) && currentItem.getItemMeta().getPersistentDataContainer().has(costsCurrencyKey, PersistentDataType.INTEGER)) {
                        boolean bypass = false;
                        if (ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_VAULT_PERMANENT_PURCHASES).booleanValue() && usedOriginFileConfiguration.getStringList(event.getWhoClicked().getUniqueId().toString()).contains(origin.getName().toLowerCase())) {
                            bypass = true;
                        }
                        if (!bypass) {
                            amount = (Integer)currentItem.getItemMeta().getPersistentDataContainer().getOrDefault(costsCurrencyKey, PersistentDataType.INTEGER, (Object)amount);
                            if (!VaultHook.has(player, amount)) {
                                return;
                            }
                            VaultHook.withdraw(player, amount);
                        }
                    }
                    PlayerSwapOriginEvent.SwapReason reason = this.getReason(item);
                    player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, SoundCategory.MASTER, 1.0f, 1.0f);
                    player.closeInventory();
                    if (reason == PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN) {
                        orbCooldown.put(player, System.currentTimeMillis());
                    }
                    boolean resetPlayer = OriginSwapper.shouldResetPlayer(reason);
                    OriginSwapper.setOrigin(player, origin, reason, resetPlayer, layer);
                    if (reason == PlayerSwapOriginEvent.SwapReason.COMMAND) {
                        OriginsReborn.getCooldowns().setCooldown(player, OriginCommand.key, ConfigManager.getConfigValue(ConfigManager.Option.SWAP_COMMAND_COOLDOWN));
                    }
                } else if (currentItem.getItemMeta().getPersistentDataContainer().has(closeKey, (PersistentDataType)BooleanPDT.BOOLEAN)) {
                    event.getWhoClicked().closeInventory();
                }
            }
        }
    }

    public static boolean shouldResetPlayer(PlayerSwapOriginEvent.SwapReason reason) {
        return switch (reason) {
            case PlayerSwapOriginEvent.SwapReason.COMMAND -> OriginsReborn.getInstance().getConfig().getBoolean("swap-command.reset-player");
            case PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN -> OriginsReborn.getInstance().getConfig().getBoolean("orb-of-origin.reset-player");
            default -> false;
        };
    }

    public static int getWidth(String s) {
        int result = 0;
        for (char c : s.toCharArray()) {
            result += Translator.getWidth(c);
        }
        return result;
    }

    public static String getInverse(char c) {
        return switch (Translator.getWidth(c)) {
            case 0 -> "";
            case 2 -> "\uf001";
            case 3 -> "\uf002";
            case 4 -> "\uf003";
            case 5 -> "\uf004";
            case 6 -> "\uf005";
            case 7 -> "\uf006";
            case 8 -> "\uf007";
            case 9 -> "\uf008";
            case 10 -> "\uf009";
            case 11 -> "\uf008\uf001";
            case 12 -> "\uf009\uf001";
            case 13 -> "\uf009\uf002";
            case 14 -> "\uf009\uf003";
            case 15 -> "\uf009\uf004";
            case 16 -> "\uf009\uf005";
            case 17 -> "\uf009\uf006";
            default -> throw new IllegalStateException("Unexpected value: " + c);
        };
    }

    public static void resetPlayer(Player player, boolean full) {
        OriginSwapper.resetAttributes(player);
        player.closeInventory();
        OriginsReborn.getMVE().setWorldBorderOverlay(player, false);
        player.setCooldown(Material.SHIELD, 0);
        player.setAllowFlight(false);
        player.setFlying(false);
        for (Player otherPlayer : Bukkit.getOnlinePlayers()) {
            AbilityRegister.updateEntity(player, (Entity)otherPlayer);
        }
        for (PotionEffect effect : player.getActivePotionEffects()) {
            if (effect.getAmplifier() != -1 && !ShortcutUtils.isInfinite(effect)) continue;
            player.removePotionEffect(effect.getType());
        }
        if (!full) {
            return;
        }
        player.getInventory().clear();
        player.getEnderChest().clear();
        player.setSaturation(5.0f);
        player.setFallDistance(0.0f);
        player.setRemainingAir(player.getMaximumAir());
        player.setFoodLevel(20);
        player.setFireTicks(0);
        player.setHealth(OriginSwapper.getMaxHealth(player));
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        World world = OriginSwapper.getRespawnWorld(OriginSwapper.getOrigins(player));
        player.teleport(world.getSpawnLocation());
        OriginsReborn.getMVE().resetRespawnLocation(player);
    }

    @NotNull
    public static World getRespawnWorld(@NotNull List<Origin> origin) {
        World world;
        ArrayList<Ability> abilities = new ArrayList<Ability>();
        for (Origin o : origin) {
            abilities.addAll(o.getAbilities());
        }
        for (Ability ability : abilities) {
            DefaultSpawnAbility defaultSpawnAbility;
            World world2;
            if (!(ability instanceof DefaultSpawnAbility) || (world2 = (defaultSpawnAbility = (DefaultSpawnAbility)ability).getWorld()) == null) continue;
            return world2;
        }
        String overworld = OriginsReborn.getInstance().getConfig().getString("worlds.world");
        if (overworld == null) {
            overworld = "world";
            OriginsReborn.getInstance().getConfig().set("worlds.world", (Object)"world");
            OriginsReborn.getInstance().saveConfig();
        }
        if ((world = Bukkit.getWorld((String)overworld)) == null) {
            return (World)Bukkit.getWorlds().get(0);
        }
        return world;
    }

    public static double getMaxHealth(Player player) {
        OriginSwapper.applyAttributeChanges(player);
        AttributeInstance instance = player.getAttribute(MVAttribute.MAX_HEALTH.get());
        if (instance == null) {
            return 20.0;
        }
        return instance.getValue();
    }

    public static void applyAttributeChanges(Player player) {
        for (Pair<AttributeModifierAbility, NamespacedKey> abilityKeyPair : AbilityRegister.attributeModifierAbilities) {
            AttributeInstance instance;
            AttributeModifierAbility ability = abilityKeyPair.left();
            try {
                instance = player.getAttribute(ability.getAttribute());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (instance == null) continue;
            if (ability.hasAbility(player)) {
                AttributeModifier modifier = OriginsReborn.getMVE().getAttributeModifier(instance, (Key)abilityKeyPair.right());
                if (modifier != null) {
                    if (modifier.getAmount() == ability.getTotalAmount(player)) continue;
                    instance.removeModifier(modifier);
                }
                OriginsReborn.getMVE().addAttributeModifier(instance, abilityKeyPair.right(), ability.getRegisteredKey().asString(), ability.getTotalAmount(player), ability.getActualOperation());
                continue;
            }
            AttributeModifier am = OriginsReborn.getMVE().getAttributeModifier(instance, (Key)abilityKeyPair.right());
            if (am == null) continue;
            instance.removeModifier(am);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        OriginSwapper.loadOrigins(event.getPlayer());
        OriginSwapper.resetAttributes(event.getPlayer());
        lastJoinedTick.put(event.getPlayer(), Bukkit.getCurrentTick());
        for (String layer : AddonLoader.layers) {
            if (ShortcutUtils.getTopInventory((HumanEntity)event.getPlayer()).getType() == InventoryType.CHEST) continue;
            Origin origin = OriginSwapper.getOrigin(event.getPlayer(), layer);
            if (origin != null) {
                if (origin.getTeam() == null) continue;
                origin.getTeam().addPlayer((OfflinePlayer)event.getPlayer());
                continue;
            }
            if (event.getPlayer().getPersistentDataContainer().has(awaitingOriginChangeKey)) {
                return;
            }
            Origin def = AddonLoader.getDefaultOrigin(layer);
            if (def != null) {
                OriginSwapper.setOrigin(event.getPlayer(), def, PlayerSwapOriginEvent.SwapReason.INITIAL, false, layer);
                continue;
            }
            if (OriginsReborn.getInstance().getConfig().getBoolean("origin-selection.randomise.%s".formatted(layer))) {
                OriginSwapper.selectRandomOrigin(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.INITIAL, layer);
                continue;
            }
            if (ShortcutUtils.isBedrockPlayer(event.getPlayer().getUniqueId())) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> GeyserSwapper.openOriginSwapper(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.INITIAL, false, false, layer), (long)OriginsReborn.getInstance().getConfig().getInt("geyser.join-form-delay", 20));
                continue;
            }
            OriginSwapper.openOriginSwapper(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.INITIAL, 0, 0, layer);
        }
    }

    public static void resetAttributes(Player player) {
        double[] health = new double[]{player.getHealth()};
        for (MVAttribute attribute : MVAttribute.values()) {
            AttributeInstance instance;
            if (attribute.get() == null || (instance = player.getAttribute(attribute.get())) == null) continue;
            for (AttributeModifier modifier : instance.getModifiers()) {
                if (!MVAccessor.get().isCustomAttribute(modifier)) continue;
                instance.removeModifier(modifier);
            }
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> {
            AttributeInstance mh = player.getAttribute(MVAttribute.MAX_HEALTH.get());
            if (mh == null) {
                return;
            }
            double maxHealth = mh.getValue();
            health[0] = Math.min(maxHealth, health[0]);
            player.setHealth(health[0]);
        }, 10L);
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (OriginSwapper.shouldDisallowSelection(player, lastSwapReasons.getOrDefault(player, PlayerSwapOriginEvent.SwapReason.INITIAL))) {
            AbilityRegister.FlyData fd = AbilityRegister.flyData(player, true);
            if (fd.canFly() != player.getAllowFlight()) {
                player.setAllowFlight(fd.canFly());
            }
            if (fd.canFly() && fd.forceFly()) {
                player.setFlying(true);
            }
            AbilityRegister.updateFlight(player, true);
            OriginSwapper.resetAttributes(player);
        }
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        if (event.getTickNumber() % ConfigManager.getConfigValue(ConfigManager.Option.REFRESH_RATE) != 0) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            boolean invis;
            int delay = OriginsReborn.getInstance().getConfig().getInt("origin-selection.delay-before-required", 0);
            if (!lastJoinedTick.containsKey(player)) {
                lastJoinedTick.put(player, event.getTickNumber());
            }
            if (Bukkit.getCurrentTick() - delay < lastJoinedTick.get(player) || OriginSwapper.shouldDisallowSelection(player, lastSwapReasons.getOrDefault(player, PlayerSwapOriginEvent.SwapReason.INITIAL))) continue;
            if (!ConfigManager.getConfigValue(ConfigManager.Option.DISABLE_FLIGHT_STUFF).booleanValue()) {
                AbilityRegister.FlyData fd = AbilityRegister.flyData(player, false);
                if (fd.canFly() != player.getAllowFlight()) {
                    player.setAllowFlight(fd.canFly());
                }
                if (fd.canFly() && fd.forceFly()) {
                    player.setFlying(true);
                }
                AbilityRegister.updateFlight(player, false);
            }
            if ((invis = AbilityRegister.isInvisible(player, invisible.computeIfAbsent(player, p -> p.hasPotionEffect(PotionEffectType.INVISIBILITY)))) != player.isInvisible()) {
                player.setInvisible(invis);
            }
            OriginSwapper.applyAttributeChanges(player);
            String layer = AddonLoader.getFirstUnselectedLayer(player);
            if (layer == null || ShortcutUtils.getTopInventory((HumanEntity)player).getType() == InventoryType.CHEST || OriginsReborn.getInstance().getConfig().getBoolean("origin-selection.randomise.%s".formatted(layer)) || ShortcutUtils.isBedrockPlayer(player.getUniqueId())) continue;
            OriginSwapper.openOriginSwapper(player, lastSwapReasons.getOrDefault(player, PlayerSwapOriginEvent.SwapReason.INITIAL), 0, 0, layer);
        }
    }

    @EventHandler
    public void onEntityPotionEffect(EntityPotionEffectEvent event) {
        if (!event.getModifiedType().equals((Object)PotionEffectType.INVISIBILITY)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        invisible.put(player, event.getNewEffect() != null);
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (this.hasNotSelectedAllOrigins(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    public static boolean shouldDisallowSelection(Player player, PlayerSwapOriginEvent.SwapReason reason) {
        try {
            if (!AuthMeApi.getInstance().isAuthenticated(player)) {
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        String worldId = player.getWorld().getName();
        return !AddonLoader.shouldOpenSwapMenu(player, reason) || OriginsReborn.getInstance().getConfig().getStringList("worlds.disabled-worlds").contains(worldId);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            ItemStack item;
            Player player = (Player)entity;
            if (this.invulnerableMode.equalsIgnoreCase("INITIAL") && this.hasNotSelectedAllOrigins(player)) {
                event.setCancelled(true);
            } else if (this.invulnerableMode.equalsIgnoreCase("ON") && (item = ShortcutUtils.getTopInventory((HumanEntity)player).getItem(1)) != null && item.getItemMeta() != null && item.getItemMeta().getPersistentDataContainer().has(originKey, PersistentDataType.STRING)) {
                event.setCancelled(true);
            }
        }
    }

    public boolean hasNotSelectedAllOrigins(Player player) {
        for (String layer : AddonLoader.layers) {
            if (OriginSwapper.getOrigin(player, layer) != null) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerSwapOrigin(PlayerSwapOriginEvent event) {
        if (event.getNewOrigin() == null) {
            return;
        }
        if (!OriginsReborn.getInstance().getConfig().getBoolean("origin-selection.auto-spawn-teleport")) {
            return;
        }
        if (event.getReason() == PlayerSwapOriginEvent.SwapReason.INITIAL || event.getReason() == PlayerSwapOriginEvent.SwapReason.DIED) {
            Location loc = OriginsReborn.getMVE().getRespawnLocation(event.getPlayer());
            event.getPlayer().teleport(Objects.requireNonNullElseGet(loc, () -> OriginSwapper.getRespawnWorld(Collections.singletonList(event.getNewOrigin())).getSpawnLocation()));
        }
    }

    public static void selectRandomOrigin(Player player, PlayerSwapOriginEvent.SwapReason reason, String layer) {
        Origin origin = AddonLoader.getRandomOrigin(layer);
        OriginSwapper.setOrigin(player, origin, reason, OriginSwapper.shouldResetPlayer(reason), layer);
        OriginSwapper.openOriginSwapper(player, reason, AddonLoader.getOrigins(layer).indexOf(origin), 0, false, true, layer);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (OriginsReborn.getMVE().getRespawnLocation(event.getPlayer()) == null) {
            World world = OriginSwapper.getRespawnWorld(OriginSwapper.getOrigins(event.getPlayer()));
            event.setRespawnLocation(world.getSpawnLocation());
        }
        this.lastRespawnReasons.put(event.getPlayer(), event.getRespawnFlags());
    }

    @EventHandler
    public void onPlayerPostRespawn(PlayerPostRespawnEvent event) {
        if (this.lastRespawnReasons.get(event.getPlayer()).contains(PlayerRespawnEvent.RespawnFlag.END_PORTAL)) {
            return;
        }
        FileConfiguration config = OriginsReborn.getInstance().getConfig();
        if (config.getBoolean("origin-selection.death-origin-change")) {
            for (String layer : AddonLoader.layers) {
                OriginSwapper.setOrigin(event.getPlayer(), null, PlayerSwapOriginEvent.SwapReason.DIED, false, layer);
                if (OriginsReborn.getInstance().getConfig().getBoolean("origin-selection.randomise.%s".formatted(layer))) {
                    OriginSwapper.selectRandomOrigin(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.INITIAL, layer);
                    continue;
                }
                OriginSwapper.openOriginSwapper(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.INITIAL, 0, 0, layer);
            }
        }
        OriginSwapper.resetAttributes(event.getPlayer());
        OriginSwapper.applyAttributeChanges(event.getPlayer());
    }

    public PlayerSwapOriginEvent.SwapReason getReason(ItemStack icon) {
        return PlayerSwapOriginEvent.SwapReason.get((String)icon.getItemMeta().getPersistentDataContainer().get(swapTypeKey, PersistentDataType.STRING));
    }

    @Nullable
    public static Origin getOrigin(Player player, String layer) {
        if (!origins.containsKey(player.getUniqueId())) {
            OriginSwapper.loadOrigins(player);
        }
        return origins.get(player.getUniqueId()).get(layer);
    }

    @Nullable
    public static Origin getStoredOrigin(Player player, String layer) {
        String oldOrigin = originFileConfiguration.getString(player.getUniqueId().toString(), "null");
        if (!oldOrigin.equals("null") && layer.equals("origin") && !oldOrigin.contains("MemorySection")) {
            originFileConfiguration.set(String.valueOf(player.getUniqueId()) + "." + layer, (Object)oldOrigin);
            OriginSwapper.saveOrigins();
        }
        String name = originFileConfiguration.getString(String.valueOf(player.getUniqueId()) + "." + layer, "null");
        return AddonLoader.getOrigin(name);
    }

    public static void loadOrigins(Player player) {
        player.getPersistentDataContainer().remove(originKey);
        HashMap<String, Origin> playerOrigins = new HashMap<String, Origin>();
        origins.put(player.getUniqueId(), playerOrigins);
        for (String layer : AddonLoader.layers) {
            Origin origin = OriginSwapper.getStoredOrigin(player, layer);
            if (origin == null) {
                if (player.getPersistentDataContainer().has(awaitingOriginChangeKey) || AddonLoader.getDefaultOrigin(layer) == null) continue;
                OriginSwapper.setOrigin(player, AddonLoader.getDefaultOrigin(layer), PlayerSwapOriginEvent.SwapReason.INITIAL, false, layer);
                continue;
            }
            playerOrigins.put(layer, origin);
        }
    }

    public static List<Origin> getOrigins(Player player) {
        ArrayList<Origin> origins = new ArrayList<Origin>();
        for (String layer : AddonLoader.layers) {
            Origin o = OriginSwapper.getOrigin(player, layer);
            if (o == null) continue;
            origins.add(o);
        }
        return origins;
    }

    public static FileConfiguration getUsedOriginFileConfiguration() {
        return usedOriginFileConfiguration;
    }

    public static void setOrigin(Player player, @Nullable Origin origin, PlayerSwapOriginEvent.SwapReason reason, boolean resetPlayer, String layer) {
        PlayerSwapOriginEvent swapOriginEvent = new PlayerSwapOriginEvent(player, reason, resetPlayer, OriginSwapper.getOrigin(player, layer), origin);
        if (!swapOriginEvent.callEvent()) {
            return;
        }
        if (swapOriginEvent.getNewOrigin() == null) {
            originFileConfiguration.set(String.valueOf(player.getUniqueId()) + "." + layer, null);
            OriginSwapper.saveOrigins();
            OriginSwapper.resetPlayer(player, swapOriginEvent.isResetPlayer());
            OriginSwapper.executeCommands(player, swapOriginEvent.getNewOrigin());
            OriginSwapper.loadOrigins(player);
            return;
        }
        player.getPersistentDataContainer().remove(awaitingOriginChangeKey);
        if (swapOriginEvent.getNewOrigin().getTeam() != null) {
            swapOriginEvent.getNewOrigin().getTeam().addPlayer((OfflinePlayer)player);
        }
        OriginsReborn.getCooldowns().resetCooldowns(player);
        originFileConfiguration.set(String.valueOf(player.getUniqueId()) + "." + layer, (Object)swapOriginEvent.getNewOrigin().getName().toLowerCase());
        OriginSwapper.saveOrigins();
        ArrayList<String> usedOrigins = new ArrayList<String>(usedOriginFileConfiguration.getStringList(player.getUniqueId().toString()));
        usedOrigins.add(swapOriginEvent.getNewOrigin().getName().toLowerCase());
        usedOriginFileConfiguration.set(player.getUniqueId().toString(), usedOrigins);
        OriginSwapper.saveUsedOrigins();
        OriginSwapper.resetPlayer(player, swapOriginEvent.isResetPlayer());
        OriginSwapper.executeCommands(player, swapOriginEvent.getNewOrigin());
        OriginSwapper.loadOrigins(player);
    }

    public static void executeCommands(Player player, Origin origin) {
        if (origin == null) {
            return;
        }
        String name = "default";
        if (OriginsReborn.getInstance().getConfig().contains("commands-on-origin.%s".formatted(name))) {
            for (String s : OriginsReborn.getInstance().getConfig().getStringList("commands-on-origin.%s".formatted(name))) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)s.replace("%player%", player.getName()).replace("%uuid%", player.getUniqueId().toString()));
            }
        }
        name = origin.getName().replace(" ", "_").toLowerCase();
        if (OriginsReborn.getInstance().getConfig().contains("commands-on-origin.%s".formatted(name))) {
            for (String s : OriginsReborn.getInstance().getConfig().getStringList("commands-on-origin.%s".formatted(name))) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)s.replace("%player%", player.getName()).replace("%uuid%", player.getUniqueId().toString()));
            }
        }
    }

    public static FileConfiguration getOriginFileConfiguration() {
        return originFileConfiguration;
    }

    public OriginSwapper() {
        boolean ignored;
        Translator.registerTranslation(randomName, "Random");
        Translator.registerTranslation(randomDescription, "You'll be assigned one of the following:");
        Translator.registerTranslation(nextGUI, "Next Origin");
        Translator.registerTranslation(prevGUI, "Previous Origin");
        Translator.registerTranslation(upGUI, "Up");
        Translator.registerTranslation(downGUI, "Down");
        Translator.registerTranslation(confirmGUI, "Confirm");
        Translator.registerTranslation(confirmSwapGUI, "Press \"Confirm\" again to confirm your selection");
        this.invulnerableMode = OriginsReborn.getInstance().getConfig().getString("origin-selection.invulnerable-mode", "OFF");
        originFile = new File(OriginsReborn.getInstance().getDataFolder(), "internals/selected-origins.yml");
        if (!originFile.exists()) {
            ignored = originFile.getParentFile().mkdirs();
            OriginsReborn.getInstance().saveResource("internals/selected-origins.yml", false);
        }
        originFileConfiguration = new YamlConfiguration();
        try {
            originFileConfiguration.load(originFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
        usedOriginFile = new File(OriginsReborn.getInstance().getDataFolder(), "internals/used-origins.yml");
        if (!usedOriginFile.exists()) {
            ignored = usedOriginFile.getParentFile().mkdirs();
            OriginsReborn.getInstance().saveResource("internals/used-origins.yml", false);
        }
        usedOriginFileConfiguration = new YamlConfiguration();
        try {
            usedOriginFileConfiguration.load(usedOriginFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveOrigins() {
        try {
            originFileConfiguration.save(originFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveUsedOrigins() {
        try {
            usedOriginFileConfiguration.save(usedOriginFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class LineData {
        private final List<LineComponent> lines;

        public static List<LineComponent> makeLineFor(String text, LineComponent.LineType type) {
            StringBuilder result = new StringBuilder();
            StringBuilder rawResult = new StringBuilder();
            ArrayList<LineComponent> list = new ArrayList<LineComponent>();
            ArrayList<String> splitLines = new ArrayList<String>(Arrays.stream(text.split("\n", 2)).toList());
            StringBuilder otherPart = new StringBuilder();
            Object firstLine = (String)splitLines.remove(0);
            if (((String)firstLine).contains(" ") && OriginSwapper.getWidth((String)firstLine) > 140) {
                ArrayList<String> split = new ArrayList<String>(Arrays.stream(((String)firstLine).split(" ")).toList());
                StringBuilder firstPart = new StringBuilder((String)split.get(0));
                split.remove(0);
                boolean canAdd = true;
                for (String s : split) {
                    if (canAdd && OriginSwapper.getWidth(String.valueOf(firstPart) + " " + s) <= 140) {
                        firstPart.append(" ");
                        firstPart.append(s);
                        continue;
                    }
                    canAdd = false;
                    if (!otherPart.isEmpty()) {
                        otherPart.append(" ");
                    }
                    otherPart.append(s);
                }
                firstLine = firstPart.toString();
            }
            for (String s : splitLines) {
                if (!otherPart.isEmpty()) {
                    otherPart.append("\n");
                }
                otherPart.append(s);
            }
            if (type == LineComponent.LineType.DESCRIPTION) {
                firstLine = "\uf00a" + (String)firstLine;
            }
            for (ArrayList<String> arrayList : (ArrayList<String>)((String)firstLine).toCharArray()) {
                result.append((char)arrayList);
                rawResult.append(arrayList == 61450 ? "" : Character.valueOf(arrayList));
                result.append('\uf000');
            }
            rawResult.append(' ');
            Object finalText = firstLine;
            list.add(new LineComponent(((TextComponent)Component.text(result.toString().replace(" ", "\uefff")).color(type == LineComponent.LineType.TITLE ? NamedTextColor.WHITE : TextColor.fromHexString("#CACACA"))).append(Component.text(OriginSwapper.getInverse((String)finalText))), type, rawResult.toString()));
            if (!otherPart.isEmpty()) {
                list.addAll(LineData.makeLineFor(otherPart.toString(), type));
            }
            return list;
        }

        public LineData(Origin origin) {
            this.lines = new ArrayList<LineComponent>();
            this.lines.addAll(LineData.makeLineFor(origin.getDescription(), LineComponent.LineType.DESCRIPTION));
            List<VisibleAbility> visibleAbilities = origin.getVisibleAbilities();
            int size = visibleAbilities.size();
            int count = 0;
            if (size > 0) {
                this.lines.add(new LineComponent());
            }
            for (VisibleAbility visibleAbility : visibleAbilities) {
                this.lines.addAll(visibleAbility.getTitle());
                this.lines.addAll(visibleAbility.getDescription());
                if (++count >= size) continue;
                this.lines.add(new LineComponent());
            }
        }

        public LineData(List<LineComponent> lines) {
            this.lines = lines;
        }

        public List<Component> getLines(int startingPoint) {
            ArrayList<Component> resultLines = new ArrayList<Component>();
            for (int i = startingPoint; i < startingPoint + 6 && i < this.lines.size(); ++i) {
                resultLines.add(this.lines.get(i).getComponent(i - startingPoint));
            }
            return resultLines;
        }

        public List<LineComponent> getRawLines() {
            return this.lines;
        }

        public static class LineComponent {
            private final Component component;
            private final LineType type;
            private final String rawText;
            private final boolean empty;

            public boolean isEmpty() {
                return this.empty;
            }

            public LineType getType() {
                return this.type;
            }

            public LineComponent(Component component, LineType type, String rawText) {
                this.component = component;
                this.type = type;
                this.rawText = rawText;
                this.empty = false;
            }

            public LineComponent() {
                this.type = LineType.DESCRIPTION;
                this.component = Component.empty();
                this.rawText = "";
                this.empty = true;
            }

            public String getRawText() {
                return this.rawText;
            }

            public Component getComponent(int lineNumber) {
                String formatted = "minecraft:%stext_line_%s".formatted(this.type == LineType.DESCRIPTION ? "" : "title_", lineNumber);
                return OriginSwapper.applyFont(this.component, Key.key(formatted));
            }

            public static enum LineType {
                TITLE,
                DESCRIPTION;

            }
        }
    }

    public static class BooleanPDT
    implements PersistentDataType<Byte, Boolean> {
        public static BooleanPDT BOOLEAN = new BooleanPDT();

        @NotNull
        public Class<Byte> getPrimitiveType() {
            return Byte.class;
        }

        @NotNull
        public Class<Boolean> getComplexType() {
            return Boolean.class;
        }

        @NotNull
        public Byte toPrimitive(@NotNull Boolean aBoolean, @NotNull PersistentDataAdapterContext persistentDataAdapterContext) {
            return (byte)(aBoolean != false ? 1 : 0);
        }

        @NotNull
        public Boolean fromPrimitive(@NotNull Byte aByte, @NotNull PersistentDataAdapterContext persistentDataAdapterContext) {
            return aByte >= 1;
        }
    }
}

