/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.abilities.types.Ability;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Aquatic
implements Ability,
Listener {
    private float damageMultiplier;

    @Override
    @NotNull
    public Key getKey() {
        return Key.key("origins:aquatic");
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        this.runForAbility(event.getEntity(), player -> {
            Entity patt0$temp = event.getDamager();
            if (patt0$temp instanceof Trident) {
                Trident trident = (Trident)patt0$temp;
                event.setDamage(event.getDamage() + (double)((float)trident.getItem().getEnchantmentLevel(Enchantment.IMPALING) * this.damageMultiplier));
            } else {
                Entity patt1$temp = event.getDamager();
                if (patt1$temp instanceof LivingEntity) {
                    LivingEntity entity = (LivingEntity)patt1$temp;
                    if (entity.getEquipment() == null) {
                        return;
                    }
                    event.setDamage(event.getDamage() + (double)((float)entity.getEquipment().getItemInMainHand().getEnchantmentLevel(Enchantment.IMPALING) * this.damageMultiplier));
                }
            }
        });
    }

    @Override
    public void initialize(JavaPlugin plugin) {
        this.damageMultiplier = this.registerConfigOption(plugin, "impaling_damage_increase", Collections.singletonList("Amount to increase damage by per level of Impaling"), ConfigManager.SettingType.FLOAT, Float.valueOf(2.5f)).floatValue();
    }
}

